/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.client.integration.jei;

import com.github.iunius118.tolaserblade.ToLaserBlade;
import com.github.iunius118.tolaserblade.item.LaserBladeItemBase;
import com.github.iunius118.tolaserblade.item.ModItems;
import com.github.iunius118.tolaserblade.item.upgrade.LaserBladeUpgrade;
import com.github.iunius118.tolaserblade.item.upgrade.UpgradeResult;
import com.github.iunius118.tolaserblade.tags.ModItemTags;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import org.apache.commons.lang3.tuple.Triple;

@JeiPlugin
public class JEIToLaserBladePlugin
implements IModPlugin {
    private static final ResourceLocation ID = new ResourceLocation("tolaserblade", "main");

    public void registerRecipes(@Nonnull IRecipeRegistration registry) {
        registry.addRecipes(this.getUpgradeRecipes(registry.getVanillaRecipeFactory()), VanillaRecipeCategoryUid.ANVIL);
        registry.addRecipes(this.getColoringRecipes(registry.getVanillaRecipeFactory()), VanillaRecipeCategoryUid.ANVIL);
    }

    private List<Object> getUpgradeRecipes(IVanillaRecipeFactory factory) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Triple<ITag.INamedTag<Item>, LaserBladeUpgrade.Type, Function<ItemStack, UpgradeResult>> tag : ModItemTags.getTags()) {
            Object recipe = this.getUpdateAnvilRecipe(factory, (Item)ModItems.LASER_BLADE, ModItems.LB_BROKEN, (ITag.INamedTag<Item>)((ITag.INamedTag)tag.getLeft()), (Function)tag.getRight());
            Object recipeFP = this.getUpdateAnvilRecipe(factory, (Item)ModItems.LASER_BLADE_FP, ModItems.LB_BROKEN_FP, (ITag.INamedTag<Item>)((ITag.INamedTag)tag.getLeft()), (Function)tag.getRight());
            if (recipe != null) {
                list.add(recipe);
            }
            if (recipeFP == null) continue;
            list.add(recipeFP);
        }
        return list;
    }

    private List<Object> getColoringRecipes(IVanillaRecipeFactory factory) {
        ArrayList<Object> list = new ArrayList<Object>();
        ItemStack tintedLB = new ItemStack((IItemProvider)ModItems.LASER_BLADE);
        ModItems.LASER_BLADE.setBladeOuterColor(tintedLB, -13421773);
        ModItems.LASER_BLADE.setBladeInnerColor(tintedLB, -10066330);
        ModItems.LASER_BLADE.setGripColor(tintedLB, -10066330);
        ItemStack tintedLBFP = new ItemStack((IItemProvider)ModItems.LASER_BLADE_FP);
        ModItems.LASER_BLADE_FP.setBladeOuterColor(tintedLBFP, -13421773);
        ModItems.LASER_BLADE_FP.setBladeInnerColor(tintedLBFP, -10066330);
        ModItems.LASER_BLADE_FP.setGripColor(tintedLBFP, -10066330);
        ImmutableList laserBlades = ImmutableList.of((Object)tintedLB, (Object)tintedLBFP);
        List<ItemStack> stainedGlass = this.getUpgradeRecipes((ITag.INamedTag<Item>)Tags.Items.STAINED_GLASS);
        List<ItemStack> stainedGlassPanes = this.getUpgradeRecipes((ITag.INamedTag<Item>)Tags.Items.STAINED_GLASS_PANES);
        List<ItemStack> carpets = this.getUpgradeRecipes((ITag.INamedTag<Item>)ItemTags.field_200035_e);
        for (ItemStack laserBlade : laserBlades) {
            ItemStack output;
            if (!stainedGlass.isEmpty()) {
                output = laserBlade.func_77946_l();
                ModItems.LASER_BLADE.setBladeOuterColor(output, LaserBladeItemBase.LBColor.SPECIAL_GAMING.getBladeColor());
                list.add(factory.createAnvilRecipe(laserBlade.func_77946_l(), stainedGlass, Collections.singletonList(output)));
            }
            if (!stainedGlassPanes.isEmpty()) {
                output = laserBlade.func_77946_l();
                ModItems.LASER_BLADE.setBladeInnerColor(output, LaserBladeItemBase.LBColor.SPECIAL_GAMING.getBladeColor());
                list.add(factory.createAnvilRecipe(laserBlade.func_77946_l(), stainedGlassPanes, Collections.singletonList(output)));
            }
            if (carpets.isEmpty()) continue;
            output = laserBlade.func_77946_l();
            ModItems.LASER_BLADE.setGripColor(output, LaserBladeItemBase.LBColor.SPECIAL_GAMING.getBladeColor());
            list.add(factory.createAnvilRecipe(laserBlade.func_77946_l(), carpets, Collections.singletonList(output)));
        }
        return list;
    }

    private Object getUpdateAnvilRecipe(IVanillaRecipeFactory factory, Item laserBlade, Item brokenLaserBlade, ITag.INamedTag<Item> itemTag, Function<ItemStack, UpgradeResult> upgradeFunc) {
        ImmutableList left;
        List<ItemStack> right = this.getUpgradeRecipes(itemTag);
        ItemStack output = new ItemStack((IItemProvider)laserBlade);
        if (right.isEmpty()) {
            return null;
        }
        if (itemTag == ModItemTags.EFFICIENCY_REMOVER) {
            ImmutableList.Builder builder = ImmutableList.builder();
            int maxLevel = Enchantments.field_185305_q.func_77325_b();
            for (int level = Enchantments.field_185305_q.func_77319_d(); level <= maxLevel; ++level) {
                ItemStack efficiencyLB = new ItemStack((IItemProvider)laserBlade);
                efficiencyLB.func_77966_a(Enchantments.field_185305_q, level);
                builder.add((Object)efficiencyLB);
            }
            left = builder.build();
            output = upgradeFunc.apply(new ItemStack((IItemProvider)laserBlade)).getItemStack();
        } else if (itemTag == ModItemTags.CASING_REPAIR) {
            ItemStack damagedLB = new ItemStack((IItemProvider)laserBlade);
            damagedLB.func_196085_b(laserBlade.getMaxDamage(damagedLB) - 1);
            left = ImmutableList.of((Object)damagedLB, (Object)new ItemStack((IItemProvider)brokenLaserBlade));
        } else {
            if (itemTag == ModItemTags.FIREPROOF_UPGRADE && laserBlade == ModItems.LASER_BLADE_FP) {
                return null;
            }
            left = Collections.singletonList(new ItemStack((IItemProvider)laserBlade));
            output = upgradeFunc.apply(new ItemStack((IItemProvider)laserBlade)).getItemStack();
        }
        return factory.createAnvilRecipe((List)left, right, Collections.singletonList(output));
    }

    private List<ItemStack> getUpgradeRecipes(ITag.INamedTag<Item> itemTag) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        try {
            itemTag.func_230236_b_().forEach(item -> list.add(new ItemStack((IItemProvider)item)));
        }
        catch (IllegalStateException e) {
            ToLaserBlade.LOGGER.debug("Caught java.lang.IllegalStateException: {}\n\tat com.github.iunius118.tolaserblade.client.integration.jei.JEIToLaserBladePlugin.getUpgradeRecipes", (Object)e.getMessage());
        }
        return list;
    }

    public ResourceLocation getPluginUid() {
        return ID;
    }
}

