/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.client.model.laserblade;

import com.github.iunius118.tolaserblade.client.model.SimpleModel;
import com.github.iunius118.tolaserblade.client.renderer.LaserBladeItemColor;
import com.github.iunius118.tolaserblade.client.renderer.LaserBladeRenderType;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector4f;

public class LaserBladeModelType801
extends SimpleModel {
    private static final ResourceLocation TEXTURE;
    public static final List<SimpleModel.SimpleQuad> HILT_QUADS;
    public static final List<SimpleModel.SimpleQuad> HILT_NO_TINT_QUADS;
    public static final List<SimpleModel.SimpleQuad> BLADE_OFF_QUADS;
    public static final List<SimpleModel.SimpleQuad> BLADE_MID_QUADS;
    public static final List<SimpleModel.SimpleQuad> BLADE_IN_QUADS;
    public static final List<SimpleModel.SimpleQuad> BLADE_OUT_QUADS;

    @Override
    public void render(ItemStack itemStack, ItemCameraTransforms.TransformType transformType, MatrixStack matrixStack, IRenderTypeBuffer buffer, int lightmapCoord, int overlayColor) {
        if (transformType == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND || transformType == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND) {
            matrixStack.func_227862_a_(1.0f, 1.2f, 1.0f);
            matrixStack.func_227861_a_(0.0, -0.065, 0.0);
        } else if (transformType == ItemCameraTransforms.TransformType.FIXED || transformType == ItemCameraTransforms.TransformType.GUI || transformType == ItemCameraTransforms.TransformType.GROUND) {
            matrixStack.func_227861_a_(0.0, 0.1, 0.0);
            matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, 180.0f, true));
        }
        LaserBladeItemColor color = new LaserBladeItemColor(itemStack);
        int fullLight = 0xF000F0;
        int noTintColor = -1;
        int offColor = -3355444;
        IVertexBuilder currentBuffer = buffer.getBuffer(LaserBladeRenderType.HILT);
        this.renderQuads(matrixStack, currentBuffer, HILT_QUADS, color.gripColor, lightmapCoord, overlayColor);
        this.renderQuads(matrixStack, currentBuffer, HILT_NO_TINT_QUADS, -1, lightmapCoord, overlayColor);
        if (color.isBroken) {
            this.renderQuads(matrixStack, currentBuffer, BLADE_OFF_QUADS, -3355444, lightmapCoord, overlayColor);
            return;
        }
        currentBuffer = buffer.getBuffer(LaserBladeRenderType.LASER_FLAT);
        this.renderQuads(matrixStack, currentBuffer, BLADE_MID_QUADS, color.simpleOuterColor, 0xF000F0, overlayColor);
        this.renderQuads(matrixStack, currentBuffer, BLADE_IN_QUADS, color.simpleInnerColor, 0xF000F0, overlayColor);
        currentBuffer = color.isOuterSubColor ? buffer.getBuffer(LaserBladeRenderType.LASER_SUB) : buffer.getBuffer(LaserBladeRenderType.LASER_ADD);
        this.renderQuads(matrixStack, currentBuffer, BLADE_OUT_QUADS, color.outerColor, 0xF000F0, overlayColor);
    }

    @Override
    public ResourceLocation getTexture() {
        return TEXTURE;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void v297;
        void v298;
        void v293;
        void v292;
        void v289;
        void v282;
        void v276;
        void v268;
        void v258;
        void v259;
        void v261;
        void v256;
        void v254;
        void v255;
        void v252;
        void v253;
        void v249;
        void v246;
        void v242;
        void v241;
        void v234;
        void v235;
        void v231;
        void v232;
        void v229;
        void v224;
        void v223;
        void v218;
        void v219;
        void v220;
        void v221;
        void v215;
        void v212;
        void v209;
        void v206;
        void v203;
        void v204;
        void v205;
        void v198;
        void v201;
        void v194;
        void v195;
        void v190;
        void v186;
        void v188;
        void v184;
        void v181;
        void v182;
        void v179;
        void v175;
        void v176;
        void v178;
        void v172;
        void v170;
        void v163;
        void v159;
        void v160;
        void v155;
        void v137;
        void v138;
        void v129;
        void v124;
        void v120;
        void v117;
        ImmutableList.Builder builder;
        TEXTURE = new ResourceLocation("tolaserblade", "textures/item/internal/laser_blade_801.png");
        Vector4f c0 = new Vector4f(0.8f, 0.8f, 0.8f, 1.0f);
        Vector4f c1 = new Vector4f(0.8f, 0.8f, 0.8f, 1.0f);
        Vector4f c2 = new Vector4f(0.8f, 0.8f, 0.8f, 1.0f);
        Vector4f c3 = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
        Vector4f c4 = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
        Vector4f c5 = new Vector4f(1.0f, 1.0f, 1.0f, 0.25f);
        Vector3f v36 = new Vector3f(0.03125f, 0.8125f, 0.0625f);
        Vector3f v30 = new Vector3f(0.03125f, 0.75f, 0.125f);
        Vector3f v85 = new Vector3f(-0.03125f, 0.5f, 0.15625f);
        Vector3f v69 = new Vector3f(0.0625f, 0.375f, 0.125f);
        Vector3f v48 = new Vector3f(-0.03125f, 1.0625f, 0.0625f);
        Vector3f v1 = new Vector3f(0.03125f, 0.0625f, -0.125f);
        Vector3f v7 = new Vector3f(-0.03125f, -0.0625f, 0.0f);
        Vector3f v13 = new Vector3f(-0.03125f, 0.0625f, -0.0625f);
        Vector3f v55 = new Vector3f(-0.015625f, 0.40625f, -0.0625f);
        Vector3f v104 = new Vector3f(-0.025f, 1.36875f, 0.00625f);
        Vector3f v0 = new Vector3f(0.03125f, 0.0625f, 0.0f);
        Vector3f v312 = new Vector3f(0.0f, 0.24254f, 0.97014f);
        Vector3f v50 = new Vector3f(-0.015625f, 0.34375f, 0.0f);
        Vector3f v311 = new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f v35 = new Vector3f(0.03125f, 0.875f, 0.0625f);
        Vector3f v106 = new Vector3f(-0.0625f, 1.40625f, 0.09375f);
        Vector3f v8 = new Vector3f(0.03125f, 0.25f, 0.0625f);
        Vector3f v71 = new Vector3f(0.03125f, 0.375f, 0.0f);
        Vector3f v46 = new Vector3f(-0.03125f, 1.0625f, 0.0f);
        Vector3f v308 = new Vector3f(-1.0f, 0.0f, 0.0f);
        Vector3f v307 = new Vector3f(0.0f, 0.0f, -1.0f);
        Vector3f v93 = new Vector3f(0.0f, 1.0f, 0.15625f);
        Vector3f v73 = new Vector3f(0.03125f, 0.375f, 0.125f);
        Vector3f v67 = new Vector3f(0.0625f, 0.40625f, 0.0f);
        Vector3f v109 = new Vector3f(-0.0625f, 1.03125f, 0.09375f);
        Vector3f v306 = new Vector3f(1.0f, 0.0f, 0.0f);
        Vector3f v5 = new Vector3f(-0.03125f, -0.0625f, -0.125f);
        Vector3f v17 = new Vector3f(0.03125f, 0.6875f, 0.0f);
        Vector3f v84 = new Vector3f(0.03125f, 0.5f, 0.15625f);
        Vector3f v113 = new Vector3f(-0.0625f, 1.03125f, -0.03125f);
        Vector3f v112 = new Vector3f(-0.0625f, 1.40625f, -0.03125f);
        Vector3f v9 = new Vector3f(0.03125f, 0.25f, -0.0625f);
        Vector3f v100 = new Vector3f(0.025f, 1.06875f, 0.05625f);
        Vector3f v110 = new Vector3f(0.0625f, 1.40625f, -0.03125f);
        Vector3f v41 = new Vector3f(-0.03125f, 0.8125f, 0.125f);
        Vector3f v97 = new Vector3f(-0.03125f, 1.375f, 0.0625f);
        Vector3f v107 = new Vector3f(0.0625f, 1.40625f, 0.09375f);
        Vector3f v27 = new Vector3f(-0.03125f, 0.625f, 0.125f);
        Vector3f v42 = new Vector3f(0.03125f, 1.0625f, 0.0625f);
        Vector3f v310 = new Vector3f(0.0f, 0.0f, 1.0f);
        Vector3f v22 = new Vector3f(0.03125f, 0.625f, 0.125f);
        Vector3f v105 = new Vector3f(-0.025f, 1.06875f, 0.00625f);
        Vector3f v37 = new Vector3f(0.03125f, 0.8125f, 0.125f);
        Vector3f v313 = new Vector3f(0.0f, -0.24254f, -0.97014f);
        Vector3f v23 = new Vector3f(0.03125f, 0.625f, 0.0625f);
        Vector3f v4 = new Vector3f(-0.03125f, 0.0625f, -0.125f);
        Vector3f v103 = new Vector3f(0.025f, 1.06875f, 0.00625f);
        Vector3f v102 = new Vector3f(0.025f, 1.36875f, 0.00625f);
        Vector3f v87 = new Vector3f(0.03125f, 0.53125f, 0.15625f);
        Vector3f v3 = new Vector3f(0.03125f, -0.0625f, 0.0f);
        Vector3f v101 = new Vector3f(-0.025f, 1.06875f, 0.05625f);
        Vector3f v111 = new Vector3f(0.0625f, 1.03125f, -0.03125f);
        Vector3f v25 = new Vector3f(0.03125f, 0.5f, 0.125f);
        Vector3f v88 = new Vector3f(0.03125f, 0.53125f, 0.125f);
        Vector3f v29 = new Vector3f(-0.03125f, 0.5f, 0.0625f);
        Vector3f v19 = new Vector3f(-0.03125f, 0.6875f, 0.0f);
        Vector3f v49 = new Vector3f(-0.03125f, 0.9375f, 0.0625f);
        Vector3f v99 = new Vector3f(0.025f, 1.36875f, 0.05625f);
        Vector3f v80 = new Vector3f(-0.03125f, 1.0f, 0.1875f);
        Vector3f v58 = new Vector3f(-0.015625f, 0.3125f, 0.0f);
        Vector3f v39 = new Vector3f(-0.03125f, 0.8125f, 0.0625f);
        Vector3f v40 = new Vector3f(-0.03125f, 0.875f, 0.125f);
        Vector3f v108 = new Vector3f(0.0625f, 1.03125f, 0.09375f);
        Vector3f v83 = new Vector3f(-0.03125f, 0.875f, 0.0f);
        Vector3f v94 = new Vector3f(0.03125f, 1.375f, 0.0625f);
        Vector3f v66 = new Vector3f(0.0625f, 0.40625f, 0.125f);
        Vector3f v61 = new Vector3f(0.015625f, 0.40625f, 0.0f);
        Vector3f v12 = new Vector3f(-0.03125f, 0.25f, -0.0625f);
        Vector3f v2 = new Vector3f(0.03125f, -0.0625f, -0.125f);
        Vector3f v52 = new Vector3f(0.015625f, 0.34375f, -0.0625f);
        Vector3f v96 = new Vector3f(-0.03125f, 1.375f, 0.0f);
        Vector3f v95 = new Vector3f(0.03125f, 1.375f, 0.0f);
        Vector3f v92 = new Vector3f(0.0f, 1.0f, 0.125f);
        Vector3f v91 = new Vector3f(0.0f, 1.0625f, 0.125f);
        Vector3f v90 = new Vector3f(0.0f, 1.0625f, 0.15625f);
        Vector3f v89 = new Vector3f(-0.03125f, 0.53125f, 0.125f);
        Vector3f v54 = new Vector3f(0.015625f, 0.40625f, -0.0625f);
        Vector3f v86 = new Vector3f(-0.03125f, 0.53125f, 0.15625f);
        Vector3f v81 = new Vector3f(-0.03125f, 1.0f, 0.125f);
        Vector3f v34 = new Vector3f(0.03125f, 0.875f, 0.125f);
        Vector3f v82 = new Vector3f(0.03125f, 0.875f, 0.0f);
        Vector3f v77 = new Vector3f(0.03125f, 1.0f, 0.125f);
        Vector3f v38 = new Vector3f(-0.03125f, 0.875f, 0.0625f);
        Vector3f v45 = new Vector3f(0.03125f, 0.9375f, 0.0625f);
        Vector3f v51 = new Vector3f(0.015625f, 0.34375f, 0.0f);
        Vector3f v78 = new Vector3f(0.03125f, 1.0f, 0.1875f);
        Vector3f v26 = new Vector3f(-0.03125f, 0.625f, 0.0625f);
        Vector3f v98 = new Vector3f(-0.025f, 1.36875f, 0.05625f);
        Vector3f v79 = new Vector3f(-0.03125f, 1.0625f, 0.1875f);
        Vector3f v76 = new Vector3f(0.03125f, 1.0625f, 0.1875f);
        Vector3f v60 = new Vector3f(-0.015625f, 0.40625f, 0.0f);
        Vector3f v63 = new Vector3f(0.03125f, 0.3125f, 0.125f);
        Vector3f v62 = new Vector3f(0.03125f, 0.3125f, 0.0625f);
        Vector3f v74 = new Vector3f(0.03125f, 1.0625f, 0.125f);
        Vector3f v70 = new Vector3f(0.03125f, 0.40625f, 0.0f);
        Vector3f v6 = new Vector3f(-0.03125f, 0.0625f, 0.0f);
        Vector3f v72 = new Vector3f(0.03125f, 0.40625f, 0.125f);
        Vector3f v47 = new Vector3f(-0.03125f, 0.9375f, 0.0f);
        Vector3f v65 = new Vector3f(-0.03125f, 0.3125f, 0.0625f);
        Vector3f v64 = new Vector3f(-0.03125f, 0.3125f, 0.125f);
        Vector3f v75 = new Vector3f(-0.03125f, 1.0625f, 0.125f);
        Vector3f v59 = new Vector3f(0.015625f, 0.3125f, 0.0f);
        Vector3f v15 = new Vector3f(-0.03125f, 0.0625f, 0.0625f);
        Vector3f v57 = new Vector3f(0.015625f, 0.3125f, -0.0625f);
        Vector3f v24 = new Vector3f(0.03125f, 0.5f, 0.0625f);
        Vector3f v56 = new Vector3f(-0.015625f, 0.3125f, -0.0625f);
        Vector3f v28 = new Vector3f(-0.03125f, 0.5f, 0.125f);
        Vector3f v16 = new Vector3f(0.03125f, 0.6875f, 0.0625f);
        Vector3f v68 = new Vector3f(0.0625f, 0.375f, 0.0f);
        Vector3f v43 = new Vector3f(0.03125f, 1.0625f, 0.0f);
        Vector3f v309 = new Vector3f(0.0f, -1.0f, 0.0f);
        Vector3f v33 = new Vector3f(-0.03125f, 0.75f, 0.125f);
        Vector3f v20 = new Vector3f(-0.03125f, 0.25f, 0.0f);
        Vector3f v21 = new Vector3f(-0.03125f, 0.6875f, 0.0625f);
        Vector3f v31 = new Vector3f(0.03125f, 0.75f, 0.0625f);
        Vector3f v53 = new Vector3f(-0.015625f, 0.34375f, -0.0625f);
        Vector3f v11 = new Vector3f(0.03125f, 0.0625f, 0.0625f);
        Vector3f v10 = new Vector3f(0.03125f, 0.0625f, -0.0625f);
        Vector3f v32 = new Vector3f(-0.03125f, 0.75f, 0.0625f);
        Vector3f v18 = new Vector3f(0.03125f, 0.25f, 0.0f);
        Vector3f v44 = new Vector3f(0.03125f, 0.9375f, 0.0f);
        Vector3f v14 = new Vector3f(-0.03125f, 0.25f, 0.0625f);
        Vector2f v301 = new Vector2f(0.5f, 0.0625f);
        Vector2f v166 = new Vector2f(0.125f, 0.5625f);
        Vector2f v290 = new Vector2f(0.1875f, 0.0f);
        Vector2f v174 = new Vector2f(0.09375f, 0.40625f);
        Vector2f v272 = new Vector2f(0.375f, 0.1875f);
        Vector2f v230 = new Vector2f(0.0f, 0.25f);
        Vector2f v233 = new Vector2f(0.0f, 0.34375f);
        Vector2f v121 = new Vector2f(0.28125f, 1.0f);
        Vector2f v156 = new Vector2f(0.09375f, 0.65625f);
        Vector2f v239 = new Vector2f(0.125f, 0.34375f);
        Vector2f v245 = new Vector2f(0.0625f, 0.1875f);
        Vector2f v150 = new Vector2f(0.0f, 0.59375f);
        Vector2f v171 = new Vector2f(0.0625f, 0.375f);
        Vector2f v210 = new Vector2f(0.375f, 0.625f);
        Vector2f v288 = new Vector2f(0.1875f, 0.03125f);
        Vector2f v183 = new Vector2f(0.25f, 0.21875f);
        Vector2f v213 = new Vector2f(0.4375f, 0.6875f);
        Vector2f v114 = new Vector2f(0.125f, 0.9375f);
        Vector2f v250 = new Vector2f(0.15625f, 0.3125f);
        Vector2f v167 = new Vector2f(0.0f, 0.375f);
        Vector2f v279 = new Vector2f(0.3125f, 0.1875f);
        Vector2f v187 = new Vector2f(0.25f, 0.625f);
        Vector2f v132 = new Vector2f(0.28125f, 0.78125f);
        Vector2f v139 = new Vector2f(0.1875f, 0.71875f);
        Vector2f v119 = new Vector2f(0.21875f, 1.0f);
        Vector2f v173 = new Vector2f(0.09375f, 0.375f);
        Vector2f v177 = new Vector2f(0.15625f, 0.28125f);
        Vector2f v243 = new Vector2f(0.03125f, 0.1875f);
        Vector2f v304 = new Vector2f(0.4375f, 0.0f);
        Vector2f v154 = new Vector2f(0.0625f, 0.59375f);
        Vector2f v211 = new Vector2f(0.34375f, 0.625f);
        Vector2f v294 = new Vector2f(0.5625f, 0.0625f);
        Vector2f v141 = new Vector2f(0.15625f, 0.5f);
        Vector2f v197 = new Vector2f(0.0f, 0.78125f);
        Vector2f v157 = new Vector2f(0.0625f, 0.65625f);
        Vector2f v142 = new Vector2f(0.15625f, 0.71875f);
        Vector2f v199 = new Vector2f(0.09375f, 0.6875f);
        Vector2f v162 = new Vector2f(0.0625f, 0.5f);
        Vector2f v164 = new Vector2f(0.09375f, 0.5f);
        Vector2f v225 = new Vector2f(0.09375f, 0.46875f);
        Vector2f v222 = new Vector2f(0.0625f, 0.4375f);
        Vector2f v237 = new Vector2f(0.09375f, 0.34375f);
        Vector2f v147 = new Vector2f(0.1875f, 0.46875f);
        Vector2f v247 = new Vector2f(0.09375f, 0.21875f);
        Vector2f v152 = new Vector2f(0.03125f, 0.65625f);
        Vector2f v274 = new Vector2f(0.25f, 0.03125f);
        Vector2f v185 = new Vector2f(0.28125f, 0.59375f);
        Vector2f v287 = new Vector2f(0.15625f, 0.1875f);
        Vector2f v135 = new Vector2f(0.21875f, 0.71875f);
        Vector2f v161 = new Vector2f(0.0f, 0.5625f);
        Vector2f v238 = new Vector2f(0.125f, 0.25f);
        Vector2f v264 = new Vector2f(0.71875f, 0.03125f);
        Vector2f v265 = new Vector2f(0.71875f, 0.1875f);
        Vector2f v123 = new Vector2f(0.21875f, 0.875f);
        Vector2f v158 = new Vector2f(0.0f, 0.5f);
        Vector2f v260 = new Vector2f(0.65625f, 0.1875f);
        Vector2f v257 = new Vector2f(0.25f, 0.34375f);
        Vector2f v196 = new Vector2f(0.03125f, 0.78125f);
        Vector2f v263 = new Vector2f(0.6875f, 0.1875f);
        Vector2f v227 = new Vector2f(0.125f, 0.46875f);
        Vector2f v115 = new Vector2f(0.1875f, 0.9375f);
        Vector2f v207 = new Vector2f(0.34375f, 0.71875f);
        Vector2f v281 = new Vector2f(0.3125f, 0.0f);
        Vector2f v146 = new Vector2f(0.21875f, 0.46875f);
        Vector2f v145 = new Vector2f(0.21875f, 0.5f);
        Vector2f v144 = new Vector2f(0.1875f, 0.5f);
        Vector2f v193 = new Vector2f(0.3125f, 0.53125f);
        Vector2f v133 = new Vector2f(0.28125f, 0.875f);
        Vector2f v125 = new Vector2f(0.3125f, 0.9375f);
        Vector2f v228 = new Vector2f(0.125f, 0.375f);
        Vector2f v127 = new Vector2f(0.1875f, 0.875f);
        Vector2f v273 = new Vector2f(0.34375f, 0.1875f);
        Vector2f v140 = new Vector2f(0.125f, 0.5f);
        Vector2f v302 = new Vector2f(0.5f, 0.25f);
        Vector2f v148 = new Vector2f(0.25f, 0.5f);
        Vector2f v128 = new Vector2f(0.125f, 0.78125f);
        Vector2f v296 = new Vector2f(0.625f, 0.25f);
        Vector2f v118 = new Vector2f(0.21875f, 0.9375f);
        Vector2f v169 = new Vector2f(0.03125f, 0.40625f);
        Vector2f v143 = new Vector2f(0.125f, 0.71875f);
        Vector2f v226 = new Vector2f(0.125f, 0.4375f);
        Vector2f v305 = new Vector2f(0.5625f, 0.0f);
        Vector2f v303 = new Vector2f(0.5f, 0.0f);
        Vector2f v278 = new Vector2f(0.3125f, 0.03125f);
        Vector2f v236 = new Vector2f(0.09375f, 0.25f);
        Vector2f v286 = new Vector2f(0.15625f, 0.03125f);
        Vector2f v299 = new Vector2f(0.4375f, 0.0625f);
        Vector2f v200 = new Vector2f(0.09375f, 0.78125f);
        Vector2f v240 = new Vector2f(0.03125f, 0.21875f);
        Vector2f v295 = new Vector2f(0.625f, 0.0625f);
        Vector2f v244 = new Vector2f(0.0f, 0.21875f);
        Vector2f v136 = new Vector2f(0.25f, 0.78125f);
        Vector2f v208 = new Vector2f(0.40625f, 0.6875f);
        Vector2f v291 = new Vector2f(0.15625f, 0.0f);
        Vector2f v153 = new Vector2f(0.0f, 0.65625f);
        Vector2f v217 = new Vector2f(0.125f, 0.65625f);
        Vector2f v116 = new Vector2f(0.1875f, 1.0f);
        Vector2f v126 = new Vector2f(0.3125f, 1.0f);
        Vector2f v300 = new Vector2f(0.4375f, 0.25f);
        Vector2f v202 = new Vector2f(0.125f, 0.6875f);
        Vector2f v285 = new Vector2f(0.125f, 0.03125f);
        Vector2f v284 = new Vector2f(0.21875f, 0.03125f);
        Vector2f v283 = new Vector2f(0.21875f, 0.1875f);
        Vector2f v134 = new Vector2f(0.25f, 0.71875f);
        Vector2f v251 = new Vector2f(0.15625f, 0.34375f);
        Vector2f v191 = new Vector2f(0.3125f, 0.5f);
        Vector2f v280 = new Vector2f(0.34375f, 0.0f);
        Vector2f v131 = new Vector2f(0.21875f, 0.78125f);
        Vector2f v130 = new Vector2f(0.125f, 0.875f);
        Vector2f v122 = new Vector2f(0.25f, 0.875f);
        Vector2f v248 = new Vector2f(0.125f, 0.1875f);
        Vector2f v151 = new Vector2f(0.03125f, 0.59375f);
        Vector2f v277 = new Vector2f(0.25f, 0.1875f);
        Vector2f v189 = new Vector2f(0.25f, 0.53125f);
        Vector2f v192 = new Vector2f(0.28125f, 0.5f);
        Vector2f v216 = new Vector2f(0.125f, 0.59375f);
        Vector2f v275 = new Vector2f(0.28125f, 0.03125f);
        Vector2f v271 = new Vector2f(0.375f, 0.03125f);
        Vector2f v180 = new Vector2f(0.1875f, 0.28125f);
        Vector2f v266 = new Vector2f(0.75f, 0.03125f);
        Vector2f v168 = new Vector2f(0.03125f, 0.375f);
        Vector2f v165 = new Vector2f(0.09375f, 0.5625f);
        Vector2f v269 = new Vector2f(0.6875f, 0.0f);
        Vector2f v214 = new Vector2f(0.4375f, 0.71875f);
        Vector2f v267 = new Vector2f(0.75f, 0.1875f);
        Vector2f v149 = new Vector2f(0.15625f, 0.46875f);
        Vector2f v270 = new Vector2f(0.34375f, 0.03125f);
        Vector2f v262 = new Vector2f(0.6875f, 0.03125f);
        Vector2f vector2f = new Vector2f(0.0f, 0.6875f);
        Vector2f vector2f2 = new Vector2f(0.3125f, 0.78125f);
        Vector2f vector2f3 = new Vector2f(0.625f, 0.1875f);
        Vector2f vector2f4 = new Vector2f(0.65625f, 0.03125f);
        Vector2f vector2f5 = new Vector2f(0.40625f, 0.71875f);
        Vector2f vector2f6 = new Vector2f(0.1875f, 0.34375f);
        Vector2f vector2f7 = new Vector2f(0.25f, 0.9375f);
        Vector2f vector2f8 = new Vector2f(0.09375f, 0.4375f);
        Vector2f vector2f9 = new Vector2f(0.25f, 0.3125f);
        Vector2f vector2f10 = new Vector2f(0.21875f, 0.34375f);
        Vector2f vector2f11 = new Vector2f(0.21875f, 0.3125f);
        Vector2f vector2f12 = new Vector2f(0.1875f, 0.3125f);
        Vector2f vector2f13 = new Vector2f(0.25f, 0.28125f);
        Vector2f vector2f14 = new Vector2f(0.125f, 0.3125f);
        Vector2f vector2f15 = new Vector2f(0.25f, 0.6875f);
        Vector2f vector2f16 = new Vector2f(0.125f, 0.28125f);
        Vector2f vector2f17 = new Vector2f(0.09375f, 0.1875f);
        Vector2f vector2f18 = new Vector2f(0.5625f, 0.25f);
        Vector2f vector2f19 = new Vector2f(0.0f, 0.1875f);
        Vector2f vector2f20 = new Vector2f(0.0625f, 0.21875f);
        Vector2f vector2f21 = new Vector2f(0.375f, 0.25f);
        Vector2f vector2f22 = new Vector2f(0.0f, 0.40625f);
        Vector2f vector2f23 = new Vector2f(0.375f, 0.0625f);
        Vector2f vector2f24 = new Vector2f(0.0625f, 0.34375f);
        Vector2f vector2f25 = new Vector2f(0.28125f, 0.9375f);
        Vector2f vector2f26 = new Vector2f(0.03125f, 0.34375f);
        Vector2f vector2f27 = new Vector2f(0.1875f, 0.21875f);
        Vector2f vector2f28 = new Vector2f(0.65625f, 0.0f);
        Vector2f vector2f29 = new Vector2f(0.0625f, 0.25f);
        Vector2f vector2f30 = new Vector2f(0.125f, 0.40625f);
        Vector2f vector2f31 = new Vector2f(0.25f, 0.59375f);
        Vector2f vector2f32 = new Vector2f(0.28125f, 0.625f);
        Vector2f vector2f33 = new Vector2f(0.21875f, 0.21875f);
        Vector2f vector2f34 = new Vector2f(0.15625f, 0.21875f);
        Vector2f vector2f35 = new Vector2f(0.0625f, 0.40625f);
        Vector2f vector2f36 = new Vector2f(0.0625f, 0.46875f);
        Vector2f vector2f37 = new Vector2f(0.3125f, 0.71875f);
        Vector2f vector2f38 = new Vector2f(0.0f, 0.4375f);
        Vector2f vector2f39 = new Vector2f(0.0f, 0.46875f);
        Vector2f vector2f40 = new Vector2f(0.03125f, 0.4375f);
        Vector2f vector2f41 = new Vector2f(0.3125f, 0.6875f);
        Vector2f vector2f42 = new Vector2f(0.03125f, 0.46875f);
        Vector2f vector2f43 = new Vector2f(0.625f, 0.03125f);
        Vector2f vector2f44 = new Vector2f(0.125f, 1.0f);
        Vector2f vector2f45 = new Vector2f(0.28125f, 0.1875f);
        Vector2f vector2f46 = new Vector2f(0.3125f, 0.625f);
        Vector2f vector2f47 = new Vector2f(0.03125f, 0.6875f);
        Vector2f vector2f48 = new Vector2f(0.1875f, 0.78125f);
        Vector2f vector2f49 = new Vector2f(0.375f, 0.6875f);
        Vector2f vector2f50 = new Vector2f(0.09375f, 0.59375f);
        Vector2f vector2f51 = new Vector2f(0.0625f, 0.5625f);
        Vector2f vector2f52 = new Vector2f(0.03125f, 0.5625f);
        Vector2f vector2f53 = new Vector2f(0.1875f, 0.1875f);
        Vector2f vector2f54 = new Vector2f(0.21875f, 0.0f);
        Vector2f vector2f55 = new Vector2f(0.03125f, 0.5f);
        Vector2f vector2f56 = new Vector2f(0.03125f, 0.25f);
        Vector2f vector2f57 = new Vector2f(0.0625f, 0.6875f);
        Vector2f vector2f58 = new Vector2f(0.21875f, 0.28125f);
        Vector2f vector2f59 = new Vector2f(0.34375f, 0.6875f);
        Vector2f vector2f60 = new Vector2f(0.0625f, 0.78125f);
        Vector2f vector2f61 = new Vector2f(0.125f, 0.21875f);
        Vector2f vector2f62 = new Vector2f(0.28125f, 0.0f);
        Vector2f vector2f63 = new Vector2f(0.28125f, 0.53125f);
        Vector2f vector2f64 = new Vector2f(0.3125f, 0.875f);
        ImmutableList.Builder builder2 = ImmutableList.builder();
        builder.add((Object)new SimpleModel.SimpleQuad(v3, c0, (Vector2f)v117, v306, v2, c0, v116, v306, v1, c0, v115, v306, v0, c0, v114, v306));
        builder.add((Object)new SimpleModel.SimpleQuad(v2, c0, v116, v307, v5, c0, v119, v307, v4, c0, v118, v307, v1, c0, v115, v307));
        builder.add((Object)new SimpleModel.SimpleQuad(v5, c0, v119, v308, v7, c0, v121, v308, v6, c0, (Vector2f)v120, v308, v4, c0, v118, v308));
        builder.add((Object)new SimpleModel.SimpleQuad(v5, c0, (Vector2f)v124, v309, v2, c0, v118, v309, v3, c0, v123, v309, v7, c0, v122, v309));
        builder.add((Object)new SimpleModel.SimpleQuad(v7, c0, v121, v310, v3, c0, v126, v310, v0, c0, v125, v310, v6, c0, (Vector2f)v120, v310));
        builder.add((Object)new SimpleModel.SimpleQuad(v1, c0, v115, v311, v4, c0, v118, v311, v6, c0, v123, v311, v0, c0, v127, v311));
        builder.add((Object)new SimpleModel.SimpleQuad(v11, c0, v130, v306, v10, c0, v127, v306, v9, c0, (Vector2f)v129, v306, v8, c0, v128, v306));
        builder.add((Object)new SimpleModel.SimpleQuad(v10, c0, v127, v307, v13, c0, v123, v307, v12, c0, v131, v307, v9, c0, (Vector2f)v129, v307));
        builder.add((Object)new SimpleModel.SimpleQuad(v13, c0, v123, v308, v15, c0, v133, v308, v14, c0, v132, v308, v12, c0, v131, v308));
        builder.add((Object)new SimpleModel.SimpleQuad(v13, c0, v136, v309, v10, c0, v131, v309, v11, c0, v135, v309, v15, c0, v134, v309));
        builder.add((Object)new SimpleModel.SimpleQuad(v15, c0, v133, v310, v11, c0, (Vector2f)v138, v310, v8, c0, (Vector2f)v137, v310, v14, c0, v132, v310));
        builder.add((Object)new SimpleModel.SimpleQuad(v9, c0, (Vector2f)v129, v311, v12, c0, v131, v311, v14, c0, v135, v311, v8, c0, v139, v311));
        builder.add((Object)new SimpleModel.SimpleQuad(v8, c0, v143, v306, v18, c0, v142, v306, v17, c0, v141, v306, v16, c0, v140, v306));
        builder.add((Object)new SimpleModel.SimpleQuad(v18, c0, v142, v307, v20, c0, v139, v307, v19, c0, v144, v307, v17, c0, v141, v307));
        builder.add((Object)new SimpleModel.SimpleQuad(v20, c0, v139, v308, v14, c0, v135, v308, v21, c0, v145, v308, v19, c0, v144, v308));
        builder.add((Object)new SimpleModel.SimpleQuad(v20, c0, v145, v309, v18, c0, v144, v309, v8, c0, v147, v309, v14, c0, v146, v309));
        builder.add((Object)new SimpleModel.SimpleQuad(v14, c0, v135, v310, v8, c0, v134, v310, v16, c0, v148, v310, v21, c0, v145, v310));
        builder.add((Object)new SimpleModel.SimpleQuad(v17, c0, v141, v311, v19, c0, v144, v311, v21, c0, v147, v311, v16, c0, v149, v311));
        builder.add((Object)new SimpleModel.SimpleQuad(v25, c0, v153, v306, v24, c0, v152, v306, v23, c0, v151, v306, v22, c0, v150, v306));
        builder.add((Object)new SimpleModel.SimpleQuad(v29, c0, v157, v308, v28, c0, v156, v308, v27, c0, (Vector2f)v155, v308, v26, c0, v154, v308));
        builder.add((Object)new SimpleModel.SimpleQuad(v22, c0, v161, v306, v23, c0, (Vector2f)v160, v306, v31, c0, (Vector2f)v159, v306, v30, c0, v158, v306));
        builder.add((Object)new SimpleModel.SimpleQuad(v23, c0, (Vector2f)v160, v307, v26, c0, (Vector2f)v163, v307, v32, c0, v162, v307, v31, c0, (Vector2f)v159, v307));
        builder.add((Object)new SimpleModel.SimpleQuad(v26, c0, (Vector2f)v163, v308, v27, c0, v165, v308, v33, c0, v164, v308, v32, c0, v162, v308));
        builder.add((Object)new SimpleModel.SimpleQuad(v27, c0, v165, v310, v22, c0, v166, v310, v30, c0, v140, v310, v33, c0, v164, v310));
        builder.add((Object)new SimpleModel.SimpleQuad(v37, c0, (Vector2f)v170, v306, v36, c0, v169, v306, v35, c0, v168, v306, v34, c0, v167, v306));
        builder.add((Object)new SimpleModel.SimpleQuad(v36, c0, v169, v307, v39, c0, (Vector2f)v172, v307, v38, c0, v171, v307, v35, c0, v168, v307));
        builder.add((Object)new SimpleModel.SimpleQuad(v39, c0, (Vector2f)v172, v308, v41, c0, v174, v308, v40, c0, v173, v308, v38, c0, v171, v308));
        builder.add((Object)new SimpleModel.SimpleQuad(v45, c0, (Vector2f)v178, v306, v44, c0, v177, v306, v43, c0, (Vector2f)v176, v306, v42, c0, (Vector2f)v175, v306));
        builder.add((Object)new SimpleModel.SimpleQuad(v44, c0, v177, v307, v47, c0, v180, v307, v46, c0, (Vector2f)v179, v307, v43, c0, (Vector2f)v176, v307));
        builder.add((Object)new SimpleModel.SimpleQuad(v47, c0, v180, v308, v49, c0, (Vector2f)v182, v308, v48, c0, (Vector2f)v181, v308, v46, c0, (Vector2f)v179, v308));
        builder.add((Object)new SimpleModel.SimpleQuad(v49, c0, (Vector2f)v182, v310, v45, c0, (Vector2f)v184, v310, v42, c0, v183, v310, v48, c0, (Vector2f)v181, v310));
        HILT_QUADS = builder.build();
        builder = ImmutableList.builder();
        builder.add((Object)new SimpleModel.SimpleQuad(v53, c1, (Vector2f)v188, v309, v52, c1, v187, v309, v51, c1, (Vector2f)v186, v309, v50, c1, v185, v309));
        builder.add((Object)new SimpleModel.SimpleQuad(v50, c1, v185, v311, v51, c1, (Vector2f)v186, v311, v52, c1, v187, v311, v53, c1, (Vector2f)v188, v311));
        builder.add((Object)new SimpleModel.SimpleQuad(v57, c1, (Vector2f)v186, v307, v56, c1, v185, v307, v55, c1, (Vector2f)v190, v307, v54, c1, v189, v307));
        builder.add((Object)new SimpleModel.SimpleQuad(v56, c1, v193, v309, v57, c1, (Vector2f)v190, v309, v59, c1, v192, v309, v58, c1, v191, v309));
        builder.add((Object)new SimpleModel.SimpleQuad(v54, c1, v189, v311, v55, c1, (Vector2f)v190, v311, v60, c1, v192, v311, v61, c1, v148, v311));
        builder.add((Object)new SimpleModel.SimpleQuad(v54, c1, v189, v310, v55, c1, (Vector2f)v190, v310, v56, c1, v185, v310, v57, c1, (Vector2f)v186, v310));
        builder.add((Object)new SimpleModel.SimpleQuad(v58, c1, v191, v311, v59, c1, v192, v311, v57, c1, (Vector2f)v190, v311, v56, c1, v193, v311));
        builder.add((Object)new SimpleModel.SimpleQuad(v61, c1, v148, v309, v60, c1, v192, v309, v55, c1, (Vector2f)v190, v309, v54, c1, v189, v309));
        builder.add((Object)new SimpleModel.SimpleQuad(v63, c1, v197, v306, v62, c1, v196, v306, v24, c1, (Vector2f)v195, v306, v25, c1, (Vector2f)v194, v306));
        builder.add((Object)new SimpleModel.SimpleQuad(v65, c1, (Vector2f)v201, v308, v64, c1, v200, v308, v28, c1, v199, v308, v29, c1, (Vector2f)v198, v308));
        builder.add((Object)new SimpleModel.SimpleQuad(v65, c1, v199, v309, v62, c1, (Vector2f)v198, v309, v63, c1, v157, v309, v64, c1, v156, v309));
        builder.add((Object)new SimpleModel.SimpleQuad(v64, c1, v200, v310, v63, c1, v128, v310, v25, c1, v202, v310, v28, c1, v199, v310));
        builder.add((Object)new SimpleModel.SimpleQuad(v69, c1, v134, v306, v68, c1, (Vector2f)v205, v306, v67, c1, (Vector2f)v204, v306, v66, c1, (Vector2f)v203, v306));
        builder.add((Object)new SimpleModel.SimpleQuad(v68, c1, (Vector2f)v205, v307, v71, c1, v207, v307, v70, c1, (Vector2f)v206, v307, v67, c1, (Vector2f)v204, v307));
        builder.add((Object)new SimpleModel.SimpleQuad(v71, c1, v207, v308, v73, c1, (Vector2f)v209, v308, v72, c1, v208, v308, v70, c1, (Vector2f)v206, v308));
        builder.add((Object)new SimpleModel.SimpleQuad(v71, c1, (Vector2f)v212, v309, v68, c1, (Vector2f)v206, v309, v69, c1, v211, v309, v73, c1, v210, v309));
        builder.add((Object)new SimpleModel.SimpleQuad(v73, c1, (Vector2f)v209, v310, v69, c1, v214, v310, v66, c1, v213, v310, v72, c1, v208, v310));
        builder.add((Object)new SimpleModel.SimpleQuad(v67, c1, (Vector2f)v204, v311, v70, c1, (Vector2f)v206, v311, v72, c1, v211, v311, v66, c1, (Vector2f)v215, v311));
        builder.add((Object)new SimpleModel.SimpleQuad(v28, c1, v156, v310, v25, c1, v217, v310, v22, c1, v216, v310, v27, c1, (Vector2f)v155, v310));
        builder.add((Object)new SimpleModel.SimpleQuad(v30, c1, (Vector2f)v221, v306, v31, c1, (Vector2f)v220, v306, v36, c1, (Vector2f)v219, v306, v37, c1, (Vector2f)v218, v306));
        builder.add((Object)new SimpleModel.SimpleQuad(v31, c1, (Vector2f)v220, v307, v32, c1, (Vector2f)v223, v307, v39, c1, v222, v307, v36, c1, (Vector2f)v219, v307));
        builder.add((Object)new SimpleModel.SimpleQuad(v32, c1, (Vector2f)v223, v308, v33, c1, v225, v308, v41, c1, (Vector2f)v224, v308, v39, c1, v222, v308));
        builder.add((Object)new SimpleModel.SimpleQuad(v33, c1, v225, v310, v30, c1, v227, v310, v37, c1, v226, v310, v41, c1, (Vector2f)v224, v310));
        builder.add((Object)new SimpleModel.SimpleQuad(v41, c1, v174, v310, v37, c1, (Vector2f)v229, v310, v34, c1, v228, v310, v40, c1, v173, v310));
        builder.add((Object)new SimpleModel.SimpleQuad(v34, c1, v233, v306, v35, c1, (Vector2f)v232, v306, v42, c1, (Vector2f)v231, v306, v74, c1, v230, v306));
        builder.add((Object)new SimpleModel.SimpleQuad(v35, c1, (Vector2f)v232, v307, v38, c1, (Vector2f)v235, v307, v48, c1, (Vector2f)v234, v307, v42, c1, (Vector2f)v231, v307));
        builder.add((Object)new SimpleModel.SimpleQuad(v38, c1, (Vector2f)v235, v308, v40, c1, v237, v308, v75, c1, v236, v308, v48, c1, (Vector2f)v234, v308));
        builder.add((Object)new SimpleModel.SimpleQuad(v40, c1, v237, v310, v34, c1, v239, v310, v74, c1, v238, v310, v75, c1, v236, v310));
        builder.add((Object)new SimpleModel.SimpleQuad(v42, c1, (Vector2f)v231, v311, v48, c1, (Vector2f)v234, v311, v75, c1, (Vector2f)v241, v311, v74, c1, v240, v311));
        builder.add((Object)new SimpleModel.SimpleQuad(v78, c1, v244, v306, v77, c1, v240, v306, v74, c1, v243, v306, v76, c1, (Vector2f)v242, v306));
        builder.add((Object)new SimpleModel.SimpleQuad(v81, c1, (Vector2f)v241, v308, v80, c1, v247, v308, v79, c1, (Vector2f)v246, v308, v75, c1, v245, v308));
        builder.add((Object)new SimpleModel.SimpleQuad(v80, c1, v247, v310, v78, c1, (Vector2f)v175, v310, v76, c1, v248, v310, v79, c1, (Vector2f)v246, v310));
        builder.add((Object)new SimpleModel.SimpleQuad(v76, c1, (Vector2f)v242, v308, v74, c1, v243, v308, v77, c1, v240, v308, v78, c1, v244, v308));
        builder.add((Object)new SimpleModel.SimpleQuad(v75, c1, v245, v306, v79, c1, (Vector2f)v246, v306, v80, c1, v247, v306, v81, c1, (Vector2f)v241, v306));
        builder.add((Object)new SimpleModel.SimpleQuad(v79, c1, (Vector2f)v246, v307, v76, c1, v248, v307, v78, c1, (Vector2f)v175, v307, v80, c1, v247, v307));
        builder.add((Object)new SimpleModel.SimpleQuad(v35, c1, v239, v306, v82, c1, v251, v306, v44, c1, v250, v306, v45, c1, (Vector2f)v249, v306));
        builder.add((Object)new SimpleModel.SimpleQuad(v82, c1, v251, v307, v83, c1, (Vector2f)v253, v307, v47, c1, (Vector2f)v252, v307, v44, c1, v250, v307));
        builder.add((Object)new SimpleModel.SimpleQuad(v83, c1, (Vector2f)v253, v308, v38, c1, (Vector2f)v255, v308, v49, c1, (Vector2f)v254, v308, v47, c1, (Vector2f)v252, v308));
        builder.add((Object)new SimpleModel.SimpleQuad(v83, c1, (Vector2f)v254, v309, v82, c1, (Vector2f)v252, v309, v35, c1, v180, v309, v38, c1, (Vector2f)v182, v309));
        builder.add((Object)new SimpleModel.SimpleQuad(v38, c1, (Vector2f)v255, v310, v35, c1, v257, v310, v45, c1, (Vector2f)v256, v310, v49, c1, (Vector2f)v254, v310));
        builder.add((Object)new SimpleModel.SimpleQuad(v85, c1, v156, v312, v84, c1, v217, v312, v22, c1, v216, v312, v27, c1, (Vector2f)v155, v312));
        builder.add((Object)new SimpleModel.SimpleQuad(v89, c1, v199, v309, v88, c1, (Vector2f)v198, v309, v87, c1, v157, v309, v86, c1, v156, v309));
        builder.add((Object)new SimpleModel.SimpleQuad(v27, c1, (Vector2f)v155, v313, v22, c1, v216, v313, v84, c1, v217, v313, v85, c1, v156, v313));
        builder.add((Object)new SimpleModel.SimpleQuad(v86, c1, v156, v311, v87, c1, v157, v311, v88, c1, (Vector2f)v198, v311, v89, c1, v199, v311));
        builder.add((Object)new SimpleModel.SimpleQuad(v93, c1, v240, v306, v92, c1, (Vector2f)v241, v306, v91, c1, v245, v306, v90, c1, v243, v306));
        builder.add((Object)new SimpleModel.SimpleQuad(v90, c1, v243, v308, v91, c1, v245, v308, v92, c1, (Vector2f)v241, v308, v93, c1, v240, v308));
        HILT_NO_TINT_QUADS = builder.build();
        builder = ImmutableList.builder();
        builder.add((Object)new SimpleModel.SimpleQuad(v42, c2, (Vector2f)v261, v306, v43, c2, v260, v306, v95, c2, (Vector2f)v259, v306, v94, c2, (Vector2f)v258, v306));
        builder.add((Object)new SimpleModel.SimpleQuad(v43, c2, v260, v307, v46, c2, v263, v307, v96, c2, v262, v307, v95, c2, (Vector2f)v259, v307));
        builder.add((Object)new SimpleModel.SimpleQuad(v46, c2, v263, v308, v48, c2, v265, v308, v97, c2, v264, v308, v96, c2, v262, v308));
        builder.add((Object)new SimpleModel.SimpleQuad(v48, c2, v265, v310, v42, c2, v267, v310, v94, c2, v266, v310, v97, c2, v264, v310));
        builder.add((Object)new SimpleModel.SimpleQuad(v95, c2, (Vector2f)v259, v311, v96, c2, v262, v311, v97, c2, v269, v311, v94, c2, (Vector2f)v268, v311));
        BLADE_OFF_QUADS = builder.build();
        builder = ImmutableList.builder();
        builder.add((Object)new SimpleModel.SimpleQuad(v46, c3, v273, v310, v43, c3, v272, v310, v95, c3, v271, v310, v96, c3, v270, v310));
        builder.add((Object)new SimpleModel.SimpleQuad(v48, c3, v277, v306, v46, c3, (Vector2f)v276, v306, v96, c3, v275, v306, v97, c3, v274, v306));
        builder.add((Object)new SimpleModel.SimpleQuad(v42, c3, (Vector2f)v276, v307, v48, c3, v279, v307, v97, c3, v278, v307, v94, c3, v275, v307));
        builder.add((Object)new SimpleModel.SimpleQuad(v43, c3, v279, v308, v42, c3, v273, v308, v94, c3, v270, v308, v95, c3, v278, v308));
        builder.add((Object)new SimpleModel.SimpleQuad(v96, c3, v270, v309, v95, c3, v278, v309, v94, c3, v281, v309, v97, c3, v280, v309));
        builder.add((Object)new SimpleModel.SimpleQuad(v43, c3, v275, v311, v46, c3, v278, v311, v48, c3, v281, v311, v42, c3, (Vector2f)v282, v311));
        BLADE_MID_QUADS = builder.build();
        builder = ImmutableList.builder();
        builder.add((Object)new SimpleModel.SimpleQuad(v100, c4, v277, v310, v99, c4, v274, v310, v98, c4, v284, v310, v101, c4, v283, v310));
        builder.add((Object)new SimpleModel.SimpleQuad(v103, c4, v287, v306, v102, c4, v286, v306, v99, c4, v285, v306, v100, c4, v248, v306));
        builder.add((Object)new SimpleModel.SimpleQuad(v105, c4, (Vector2f)v289, v307, v104, c4, v288, v307, v102, c4, v286, v307, v103, c4, v287, v307));
        builder.add((Object)new SimpleModel.SimpleQuad(v101, c4, v283, v308, v98, c4, v284, v308, v104, c4, v288, v308, v105, c4, (Vector2f)v289, v308));
        builder.add((Object)new SimpleModel.SimpleQuad(v99, c4, v291, v311, v102, c4, v286, v311, v104, c4, v288, v311, v98, c4, v290, v311));
        builder.add((Object)new SimpleModel.SimpleQuad(v105, c4, v284, v309, v103, c4, v288, v309, v100, c4, v290, v309, v101, c4, (Vector2f)v292, v309));
        BLADE_IN_QUADS = builder.build();
        builder = ImmutableList.builder();
        builder.add((Object)new SimpleModel.SimpleQuad(v108, c5, v296, v310, v107, c5, v295, v310, v106, c5, v294, v310, v109, c5, (Vector2f)v293, v310));
        builder.add((Object)new SimpleModel.SimpleQuad(v111, c5, v300, v306, v110, c5, v299, v306, v107, c5, (Vector2f)v298, v306, v108, c5, (Vector2f)v297, v306));
        builder.add((Object)new SimpleModel.SimpleQuad(v113, c5, v302, v307, v112, c5, v301, v307, v110, c5, v299, v307, v111, c5, v300, v307));
        builder.add((Object)new SimpleModel.SimpleQuad(v109, c5, (Vector2f)v293, v308, v106, c5, v294, v308, v112, c5, v301, v308, v113, c5, v302, v308));
        builder.add((Object)new SimpleModel.SimpleQuad(v107, c5, v304, v311, v110, c5, v299, v311, v112, c5, v301, v311, v106, c5, v303, v311));
        builder.add((Object)new SimpleModel.SimpleQuad(v109, c5, v305, v309, v113, c5, v294, v309, v111, c5, v301, v309, v108, c5, v303, v309));
        BLADE_OUT_QUADS = builder.build();
    }
}

