/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.client.model.laserblade;

import com.github.iunius118.tolaserblade.client.model.SimpleModel;
import com.github.iunius118.tolaserblade.client.renderer.LaserBladeItemColor;
import com.github.iunius118.tolaserblade.client.renderer.LaserBladeRenderType;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.BlockModelConfiguration;
import net.minecraftforge.client.model.IModelBuilder;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.SimpleModelTransform;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.client.model.geometry.IModelGeometryPart;
import net.minecraftforge.client.model.obj.OBJModel;

public class LaserBladeOBJModel
extends SimpleModel {
    private final Map<Part, List<BakedQuad>> PARTS = Maps.newEnumMap(Part.class);
    private final ResourceLocation TEXTURE = PlayerContainer.field_226615_c_;

    public void loadLaserBladeOBJModel(ModelLoader loader) {
        this.PARTS.clear();
        ResourceLocation modelLocation = new ResourceLocation("tolaserblade", "item/laser_blade_obj");
        IUnbakedModel model = loader.getModelOrMissing(modelLocation);
        if (!(model instanceof BlockModel)) {
            return;
        }
        BlockModelConfiguration modelConfig = ((BlockModel)model).customData;
        IModelGeometry modelGeometry = modelConfig.getCustomGeometry();
        Collection<Object> geometryParts = Collections.emptyList();
        if (modelGeometry instanceof OBJModel) {
            Optional part = modelGeometry.getPart("laser_blade");
            if (part.isPresent() && part.get() instanceof OBJModel.ModelGroup) {
                geometryParts = ((OBJModel.ModelGroup)part.get()).getParts();
            }
        } else if (modelGeometry != null) {
            geometryParts = modelGeometry.getParts();
        } else {
            return;
        }
        for (IModelGeometryPart iModelGeometryPart : geometryParts) {
            Part part = Part.find(iModelGeometryPart.name());
            if (part == null) continue;
            IModelBuilder builder = IModelBuilder.of((IModelConfiguration)modelConfig, (ItemOverrideList)ItemOverrideList.field_188022_a, (TextureAtlasSprite)Minecraft.func_71410_x().func_175599_af().func_175037_a().func_199934_a((IItemProvider)Items.field_151042_j));
            iModelGeometryPart.addQuads((IModelConfiguration)modelConfig, builder, (ModelBakery)loader, ModelLoader.defaultTextureGetter(), (IModelTransform)SimpleModelTransform.IDENTITY, modelLocation);
            this.PARTS.put(part, builder.build().getQuads(null, null, new Random(42L), (IModelData)EmptyModelData.INSTANCE));
        }
    }

    @Override
    public void render(ItemStack itemStack, ItemCameraTransforms.TransformType transformType, MatrixStack matrixStack, IRenderTypeBuffer buffer, int lightmapCoord, int overlayColor) {
        LaserBladeItemColor color = new LaserBladeItemColor(itemStack);
        int fullLight = 0xF000F0;
        IVertexBuilder currentBuffer = buffer.getBuffer(LaserBladeRenderType.HILT);
        this.renderBakedQuads(matrixStack, currentBuffer, this.getBakedQuads(Part.HILT), color.gripColor, lightmapCoord, overlayColor);
        this.renderBakedQuads(matrixStack, currentBuffer, this.getBakedQuads(Part.HILT_NO_TINT), -1, lightmapCoord, overlayColor);
        currentBuffer = buffer.getBuffer(LaserBladeRenderType.LASER_FLAT);
        this.renderBakedQuads(matrixStack, currentBuffer, this.getBakedQuads(Part.HILT_LIGHT), -1, 0xF000F0, overlayColor);
        if (color.isBroken) {
            return;
        }
        currentBuffer = color.isInnerSubColor ? buffer.getBuffer(LaserBladeRenderType.LASER_SUB_INNER) : buffer.getBuffer(LaserBladeRenderType.LASER_ADD);
        this.renderBakedQuads(matrixStack, currentBuffer, this.getBakedQuads(Part.BLADE_INNER), color.innerColor, 0xF000F0, overlayColor);
        currentBuffer = color.isOuterSubColor ? buffer.getBuffer(LaserBladeRenderType.LASER_SUB) : buffer.getBuffer(LaserBladeRenderType.LASER_ADD);
        this.renderBakedQuads(matrixStack, currentBuffer, this.getBakedQuads(Part.BLADE_OUTER_1), color.outerColor, 0xF000F0, overlayColor);
        this.renderBakedQuads(matrixStack, currentBuffer, this.getBakedQuads(Part.BLADE_OUTER_2), color.outerColor, 0xF000F0, overlayColor);
    }

    public void renderBakedQuads(MatrixStack matrixStack, IVertexBuilder buffer, List<BakedQuad> quads, int color, int lightmapCoord, int overlayColor) {
        MatrixStack.Entry matrixEntry = matrixStack.func_227866_c_();
        float alpha = (float)(color >>> 24 & 0xFF) / 255.0f;
        float red = (float)(color >>> 16 & 0xFF) / 255.0f;
        float green = (float)(color >>> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        for (BakedQuad quad : quads) {
            buffer.addVertexData(matrixEntry, quad, red, green, blue, alpha, lightmapCoord, OverlayTexture.field_229196_a_, true);
        }
    }

    public List<BakedQuad> getBakedQuads(Part part) {
        return this.PARTS.getOrDefault((Object)part, Collections.emptyList());
    }

    @Override
    public ResourceLocation getTexture() {
        return this.TEXTURE;
    }

    public static enum Part {
        HILT("laser_blade/hilt"),
        HILT_NO_TINT("laser_blade/hilt_no_tint"),
        HILT_LIGHT("laser_blade/hilt_light"),
        BLADE_INNER("laser_blade/blade_inner"),
        BLADE_OUTER_1("laser_blade/blade_outer_1"),
        BLADE_OUTER_2("laser_blade/blade_outer_2");

        private final String name;

        private Part(String nameIn) {
            this.name = nameIn;
        }

        public String getName() {
            return this.name;
        }

        public static Part find(String nameIn) {
            for (Part value : Part.values()) {
                if (!value.getName().equals(nameIn)) continue;
                return value;
            }
            return null;
        }
    }
}

