/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.client.renderer;

import com.github.iunius118.tolaserblade.ToLaserBladeConfig;
import com.github.iunius118.tolaserblade.client.model.LaserBladeModelHolder;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeBuffers;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LaserBladeRenderType
extends RenderType {
    private static final LaserBladeTextureState LASER_BLADE_TEXTURE_STATE = new LaserBladeTextureState();
    public static final RenderType HILT = LaserBladeRenderType.getBladeRenderType("hilt", LaserBladeRenderType.getLaserHiltRenderState());
    public static final RenderType LASER_FLAT = LaserBladeRenderType.getBladeRenderType("laser_flat", LaserBladeRenderType.getLaserFlatRenderState());
    public static final RenderType LASER_ADD = LaserBladeRenderType.getBladeRenderType("laser_add", LaserBladeRenderType.getLaserAddRenderState());
    public static final RenderType LASER_SUB_INNER = LaserBladeRenderType.getBladeRenderType("laser_sub_in", LaserBladeRenderType.getLaserSubRenderState());
    public static final RenderType LASER_SUB = LaserBladeRenderType.getBladeRenderType("laser_sub", LaserBladeRenderType.getLaserSubRenderState());

    public LaserBladeRenderType(String name, VertexFormat vertexFormat, int drawMode, int bufferSize, boolean useDelegate, boolean needsSorting, Runnable setupTask, Runnable clearTask) {
        super(name, vertexFormat, drawMode, bufferSize, useDelegate, needsSorting, setupTask, clearTask);
    }

    private static RenderType getBladeRenderType(String name, RenderType.State renderState) {
        return RenderType.func_228633_a_((String)name, (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)7, (int)256, (boolean)true, (boolean)false, (RenderType.State)renderState);
    }

    public static RenderType getTrapRenderType(ResourceLocation locationIn) {
        return RenderType.func_228633_a_((String)"laser_trap", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)7, (int)256, (boolean)true, (boolean)false, (RenderType.State)LaserBladeRenderType.getLaserTrapRenderState(locationIn));
    }

    private static RenderType.State getLaserHiltRenderState() {
        return RenderType.State.func_228694_a_().func_228724_a_((RenderState.TextureState)LASER_BLADE_TEXTURE_STATE).func_228726_a_(field_228515_g_).func_228716_a_(field_228532_x_).func_228713_a_(field_228517_i_).func_228719_a_(field_228528_t_).func_228722_a_(field_228530_v_).func_228728_a_(true);
    }

    private static RenderType.State getLaserFlatRenderState() {
        return RenderType.State.func_228694_a_().func_228724_a_((RenderState.TextureState)LASER_BLADE_TEXTURE_STATE).func_228726_a_(field_228515_g_).func_228713_a_(field_228517_i_).func_228719_a_(field_228528_t_).func_228722_a_(field_228530_v_).func_228728_a_(true);
    }

    private static RenderType.State getLaserAddRenderState() {
        return RenderType.State.func_228694_a_().func_228724_a_((RenderState.TextureState)LASER_BLADE_TEXTURE_STATE).func_228726_a_(field_228512_d_).func_228713_a_(field_228517_i_).func_228719_a_(field_228528_t_).func_228722_a_(field_228530_v_).func_228728_a_(true);
    }

    private static RenderType.State getLaserSubRenderState() {
        RenderState.TransparencyState transparencyState = new RenderState.TransparencyState("sub_transparency", () -> {
            RenderSystem.enableBlend();
            RenderSystem.blendEquation((int)32779);
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        }, () -> {
            RenderSystem.disableBlend();
            RenderSystem.blendEquation((int)32774);
            RenderSystem.defaultBlendFunc();
        });
        return RenderType.State.func_228694_a_().func_228724_a_((RenderState.TextureState)LASER_BLADE_TEXTURE_STATE).func_228726_a_(transparencyState).func_228713_a_(field_228517_i_).func_228719_a_(field_228528_t_).func_228722_a_(field_228530_v_).func_228728_a_(true);
    }

    private static RenderType.State getLaserTrapRenderState(ResourceLocation locationIn) {
        return RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(locationIn, false, false)).func_228726_a_(field_228510_b_).func_228713_a_(field_228517_i_).func_228719_a_(field_228528_t_).func_228722_a_(field_228530_v_).func_228728_a_(true);
    }

    private static void registerRenderTypes() {
        if (!((Boolean)ToLaserBladeConfig.CLIENT.useFixedVertexBuffer.get()).booleanValue()) {
            return;
        }
        RenderTypeBuffers renderTypeBuffers = Minecraft.func_71410_x().func_228019_au_();
        renderTypeBuffers.field_228480_b_.put(LASER_FLAT, new BufferBuilder(LASER_FLAT.func_228662_o_()));
        renderTypeBuffers.field_228480_b_.put(LASER_SUB_INNER, new BufferBuilder(LASER_SUB_INNER.func_228662_o_()));
        renderTypeBuffers.field_228480_b_.put(LASER_ADD, new BufferBuilder(LASER_ADD.func_228662_o_()));
        renderTypeBuffers.field_228480_b_.put(LASER_SUB, new BufferBuilder(LASER_SUB.func_228662_o_()));
    }

    static {
        LaserBladeRenderType.registerRenderTypes();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class LaserBladeTextureState
    extends RenderState.TextureState {
        private LaserBladeTextureState() {
        }

        public void func_228547_a_() {
            RenderSystem.enableTexture();
            TextureManager texturemanager = Minecraft.func_71410_x().func_110434_K();
            texturemanager.func_110577_a(LaserBladeModelHolder.getTexture());
            texturemanager.func_229267_b_(LaserBladeModelHolder.getTexture()).func_174937_a(false, false);
        }

        public void func_228549_b_() {
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other != null && ((Object)((Object)this)).getClass() == other.getClass()) {
                LaserBladeTextureState state = (LaserBladeTextureState)((Object)other);
                return this.func_228606_c_().equals(state.func_228606_c_());
            }
            return false;
        }

        public int hashCode() {
            return LaserBladeModelHolder.getTexture().hashCode();
        }

        protected Optional<ResourceLocation> func_228606_c_() {
            return Optional.of(LaserBladeModelHolder.getTexture());
        }
    }
}

