/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.dispenser;

import com.github.iunius118.tolaserblade.ToLaserBladeConfig;
import com.github.iunius118.tolaserblade.entity.LaserTrapEntity;
import com.github.iunius118.tolaserblade.item.ModItems;
import com.github.iunius118.tolaserblade.util.LaserTrapPlayer;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.AbstractFurnaceBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.Pair;

public class DispenseLaserBladeBehavior
implements IDispenseItemBehavior {
    public static final IDispenseItemBehavior DEFAULT_ITEM_BEHAVIOR = new DefaultDispenseItemBehavior();
    public static final Predicate<Entity> LASER_TRAP_TARGETS = EntityPredicates.field_180132_d.and(EntityPredicates.field_94557_a).and(Entity::func_70067_L).and(entity -> (Boolean)ToLaserBladeConfig.COMMON.canLaserTrapAttackPlayer.get() != false || !(entity instanceof PlayerEntity));

    public ItemStack dispense(IBlockSource source, ItemStack stack) {
        if (!((Boolean)ToLaserBladeConfig.COMMON.isEnabledLaserTrap.get()).booleanValue()) {
            return DEFAULT_ITEM_BEHAVIOR.dispense(source, stack);
        }
        ServerWorld world = source.func_197524_h();
        if (world instanceof ServerWorld) {
            ServerWorld serverWorld = world;
            BlockPos pos = source.func_180699_d();
            Direction dir = (Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a);
            BlockPos targetPos = pos.func_177972_a(dir);
            TileEntity tile = world.func_175625_s(targetPos);
            if (((Boolean)ToLaserBladeConfig.COMMON.canLaserTrapHeatUpFurnace.get()).booleanValue() && tile instanceof AbstractFurnaceTileEntity) {
                this.heatFurnace((AbstractFurnaceTileEntity)tile, stack);
            } else {
                this.attackEntities(serverWorld, pos, dir, stack);
            }
        }
        return stack;
    }

    private void heatFurnace(AbstractFurnaceTileEntity furnaceTile, ItemStack stack) {
        if (stack.func_77973_b() == ModItems.LASER_BLADE_FP) {
            boolean isNotBurning;
            boolean bl = isNotBurning = furnaceTile.field_214018_j < 1;
            if (isNotBurning || furnaceTile.field_214018_j < 201) {
                furnaceTile.field_214018_j = 201;
                furnaceTile.field_214019_k = 200;
                furnaceTile.func_70296_d();
                if (isNotBurning) {
                    World world = furnaceTile.func_145831_w();
                    BlockPos pos = furnaceTile.func_174877_v();
                    world.func_180501_a(pos, (BlockState)world.func_180495_p(pos).func_206870_a((Property)AbstractFurnaceBlock.field_220091_b, (Comparable)Boolean.TRUE), 3);
                }
            }
        }
    }

    private void attackEntities(ServerWorld world, BlockPos pos, Direction dir, ItemStack stack) {
        LaserTrapPlayer laserTrapPlayer = LaserTrapPlayer.get(world);
        laserTrapPlayer.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
        laserTrapPlayer.initInventory(stack.func_77946_l());
        BlockPos targetPos = pos.func_177972_a(dir);
        this.attackEntitiesInPos(laserTrapPlayer, targetPos);
        laserTrapPlayer.func_70106_y();
        Pair bladeColor = ModItems.LASER_BLADE.getBladeOuterColor(stack);
        int outerColor = ModItems.LASER_BLADE.checkGamingColor((Integer)bladeColor.getLeft());
        outerColor = ((Boolean)bladeColor.getRight() != false ? ~outerColor : outerColor) | 0xFF000000;
        LaserTrapEntity laserTrapEntity = new LaserTrapEntity((World)world, targetPos, dir, outerColor);
        world.func_217376_c((Entity)laserTrapEntity);
    }

    private void attackEntitiesInPos(LaserTrapPlayer laserTrapPlayer, BlockPos pos) {
        AxisAlignedBB boundingBox = new AxisAlignedBB(pos).func_186662_g(0.5);
        List targetEntities = laserTrapPlayer.field_70170_p.func_175674_a(null, boundingBox, LASER_TRAP_TARGETS);
        float attackDamage = (float)laserTrapPlayer.func_110148_a(Attributes.field_233823_f_).func_111126_e();
        for (Entity targetEntity : targetEntities) {
            targetEntity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)laserTrapPlayer), attackDamage);
        }
    }
}

