/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.item;

import com.github.iunius118.tolaserblade.ToLaserBladeConfig;
import com.github.iunius118.tolaserblade.client.renderer.LaserBladeItemRenderer;
import com.github.iunius118.tolaserblade.dispenser.DispenseLaserBladeBehavior;
import com.github.iunius118.tolaserblade.enchantment.ModEnchantments;
import com.github.iunius118.tolaserblade.item.LaserBladeItemBase;
import com.github.iunius118.tolaserblade.item.ModItems;
import com.github.iunius118.tolaserblade.item.ModMainItemGroup;
import com.github.iunius118.tolaserblade.item.upgrade.LaserBladeUpgrade;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.DispenserBlock;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SwordItem;
import net.minecraft.item.UseAction;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import org.apache.commons.lang3.tuple.Pair;

public class LaserBladeItem
extends SwordItem
implements LaserBladeItemBase {
    private final IItemTier tier = this.func_200891_e();
    private final float attackDamage = 3.0f + this.tier.func_200929_c();
    private final float attackSpeed;
    public static Item.Properties properties = new Item.Properties().setNoRepair().func_200916_a(ModMainItemGroup.ITEM_GROUP).setISTER(() -> LaserBladeItemRenderer::new);
    private ItemStack laserBladeNormal;
    private ItemStack laserBladeUpgraded;
    private ItemStack laserBladeDamaged;
    private ItemStack laserBladeFullMod;

    public LaserBladeItem(boolean isFireproof) {
        super((IItemTier)new ItemTier(isFireproof), 3, -1.2f, LaserBladeItemBase.setFireproof(properties, isFireproof));
        this.attackSpeed = -1.2f;
        DispenserBlock.func_199774_a((IItemProvider)this, (IDispenseItemBehavior)new DispenseLaserBladeBehavior());
    }

    @Override
    public boolean canUpgrade(LaserBladeUpgrade.Type type) {
        return true;
    }

    public boolean isShield(ItemStack stack, @Nullable LivingEntity entity) {
        return ToLaserBladeConfig.COMMON.isEnabledBlockingWithLaserBladeInServer.get();
    }

    public UseAction func_77661_b(ItemStack stack) {
        if (ToLaserBladeConfig.COMMON.isEnabledBlockingWithLaserBladeInServer.get().booleanValue()) {
            return UseAction.BLOCK;
        }
        return UseAction.NONE;
    }

    public int func_77626_a(ItemStack stack) {
        if (ToLaserBladeConfig.COMMON.isEnabledBlockingWithLaserBladeInServer.get().booleanValue()) {
            return 72000;
        }
        return 0;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        UseAction offhandItemAction;
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (ToLaserBladeConfig.COMMON.isEnabledBlockingWithLaserBladeInServer.get().booleanValue() && (offhandItemAction = playerIn.func_184592_cb().func_77975_n()) != UseAction.BOW && offhandItemAction != UseAction.SPEAR) {
            playerIn.func_184598_c(handIn);
        }
        return new ActionResult(ActionResultType.PASS, (Object)itemstack);
    }

    public void onCriticalHit(CriticalHitEvent event) {
        Entity target = event.getTarget();
        float attack = this.getLaserBladeATK(event.getPlayer().func_184614_ca());
        if (target instanceof WitherEntity || attack > 7.0f) {
            event.setDamageModifier(event.getDamageModifier() + 0.5f);
        }
    }

    public float func_200894_d() {
        return this.attackDamage;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (!worldIn.field_72995_K && state.func_185887_b((IBlockReader)worldIn, pos) != 0.0f) {
            stack.func_222118_a(1, entityLiving, playerEntity -> playerEntity.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        return true;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.func_222118_a(1, attacker, playerEntity -> playerEntity.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        return this.tier.func_200928_b() * this.getDestroySpeedRate(stack);
    }

    public boolean func_150897_b(BlockState blockIn) {
        return true;
    }

    public int getHarvestLevel(ItemStack stack, ToolType tool, PlayerEntity player, BlockState blockState) {
        return this.tier.func_200925_d();
    }

    public boolean isDamageable(ItemStack stack) {
        return true;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.field_77351_y == EnchantmentType.WEAPON || enchantment == Enchantments.field_185305_q || enchantment == Enchantments.field_185296_A || enchantment == Enchantments.field_190940_C;
    }

    public boolean canEquip(ItemStack stack, EquipmentSlotType armorType, Entity entity) {
        return armorType == EquipmentSlotType.HEAD;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EquipmentSlotType.MAINHAND) {
            multimap.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)(this.attackDamage + this.getLaserBladeATK(stack)), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)(this.attackSpeed + this.getLaserBladeSPD(stack)), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        this.addLaserBladeInformation(stack, worldIn, tooltip, flagIn, LaserBladeUpgrade.Type.OTHER);
    }

    private ItemStack getLaserBladeNormal() {
        ItemStack laserBlade = new ItemStack((IItemProvider)ModItems.LASER_BLADE);
        laserBlade.func_77966_a(ModEnchantments.LIGHT_ELEMENT, 2);
        laserBlade.func_77966_a(Enchantments.field_185305_q, 1);
        return laserBlade;
    }

    private ItemStack getLaserBladeUpgraded() {
        ItemStack laserBlade = new ItemStack((IItemProvider)ModItems.LASER_BLADE);
        this.setLaserBladeATK(laserBlade, 8.0f);
        this.setLaserBladeSPD(laserBlade, 1.2f);
        this.setGripColor(laserBlade, LaserBladeItemBase.LBColor.GRAY.getGripColor());
        this.setBladeInnerColor(laserBlade, LaserBladeItemBase.LBColor.LIGHT_BLUE.getBladeColor());
        this.setBladeOuterColor(laserBlade, LaserBladeItemBase.LBColor.BLUE.getBladeColor());
        laserBlade.func_77966_a(ModEnchantments.LIGHT_ELEMENT, ModEnchantments.LIGHT_ELEMENT.func_77325_b());
        laserBlade.func_77966_a(Enchantments.field_185305_q, Enchantments.field_185305_q.func_77325_b());
        laserBlade.func_77966_a(Enchantments.field_185296_A, Enchantments.field_185296_A.func_77325_b());
        return laserBlade;
    }

    private ItemStack getLaserBladeFullMod() {
        ItemStack laserBlade = this.getLaserBladeUpgraded();
        this.setBladeInnerColor(laserBlade, LaserBladeItemBase.LBColor.WHITE.getBladeColor());
        this.setBladeInnerSubColorFlag(laserBlade, true);
        this.setBladeOuterColor(laserBlade, LaserBladeItemBase.LBColor.CYAN.getBladeColor());
        this.setBladeOuterSubColorFlag(laserBlade, true);
        laserBlade.func_77966_a(Enchantments.field_77334_n, Enchantments.field_77334_n.func_77325_b());
        laserBlade.func_77966_a(Enchantments.field_191530_r, Enchantments.field_191530_r.func_77325_b());
        laserBlade.func_77966_a(Enchantments.field_185304_p, Enchantments.field_185304_p.func_77325_b());
        return laserBlade;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        super.func_150895_a(group, items);
        if (group == ModMainItemGroup.ITEM_GROUP && this.func_234687_u_()) {
            if (this.laserBladeNormal == null) {
                this.laserBladeNormal = this.getLaserBladeNormal();
            }
            if (this.laserBladeUpgraded == null) {
                this.laserBladeUpgraded = this.getLaserBladeUpgraded();
            }
            if (this.laserBladeDamaged == null) {
                this.laserBladeDamaged = this.getLaserBladeUpgraded();
                this.laserBladeDamaged.func_196085_b(31999);
            }
            if (this.laserBladeFullMod == null) {
                this.laserBladeFullMod = this.getLaserBladeFullMod();
            }
            items.add((Object)this.laserBladeNormal);
            items.add((Object)this.laserBladeUpgraded);
            items.add((Object)this.laserBladeDamaged);
            items.add((Object)this.laserBladeFullMod);
        }
    }

    public static class ItemTier
    implements IItemTier {
        private static final int NETHERITIC_HARVEST_LEVEL = 4;
        private static final int HARVEST_LEVEL = 3;
        private static final float NETHERITIC_DAMAGE = 4.0f;
        private static final float NORMAL_DAMAGE = 3.0f;
        private static final int ENCHANTABILITY = 15;
        private final boolean isNetheritic;

        public ItemTier(boolean isFireproof) {
            this.isNetheritic = isFireproof;
        }

        public int func_200925_d() {
            return this.isNetheritic ? 4 : 3;
        }

        public int func_200926_a() {
            return 32000;
        }

        public float func_200928_b() {
            return ToLaserBladeConfig.COMMON.laserBladeEfficiencyInServer.get().intValue();
        }

        public float func_200929_c() {
            return this.isNetheritic ? 4.0f : 3.0f;
        }

        public int func_200927_e() {
            return 15;
        }

        public Ingredient func_200924_f() {
            ITag tag = ItemTags.func_199903_a().func_199910_a(new ResourceLocation("forge", "ingots/iron"));
            if (tag != null) {
                return Ingredient.func_199805_a((ITag)tag);
            }
            return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151042_j});
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ColorHandler
    implements IItemColor {
        public int getColor(ItemStack stack, int tintIndex) {
            switch (tintIndex) {
                case 0: {
                    int color = ModItems.LASER_BLADE.checkGamingColor(ModItems.LASER_BLADE.getGripColor(stack));
                    return color | 0xFF000000;
                }
                case 1: {
                    Pair bladeColor = ModItems.LASER_BLADE.getBladeOuterColor(stack);
                    int color = ModItems.LASER_BLADE.checkGamingColor((Integer)bladeColor.getLeft());
                    return ((Boolean)bladeColor.getRight() != false ? ~color : color) | 0xFF000000;
                }
                case 2: {
                    Pair bladeColor = ModItems.LASER_BLADE.getBladeInnerColor(stack);
                    int color = ModItems.LASER_BLADE.checkGamingColor((Integer)bladeColor.getLeft());
                    return ((Boolean)bladeColor.getRight() != false ? ~color : color) | 0xFF000000;
                }
            }
            return -1;
        }
    }
}

