/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.item;

import com.github.iunius118.tolaserblade.item.upgrade.LaserBladeUpgrade;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;

public interface LaserBladeItemBase {
    public static final LBColor[] colors = new LBColor[]{LBColor.WHITE, LBColor.ORANGE, LBColor.MAGENTA, LBColor.LIGHT_BLUE, LBColor.YELLOW, LBColor.LIME, LBColor.PINK, LBColor.GRAY, LBColor.LIGHT_GRAY, LBColor.CYAN, LBColor.PURPLE, LBColor.BLUE, LBColor.BROWN, LBColor.GREEN, LBColor.RED, LBColor.BLACK, LBColor.TEMP_DESERT, LBColor.TEMP_SAVANNA, LBColor.TEMP_JUNGLE, LBColor.TEMP_TAIGA, LBColor.TEMP_ICE_PLAIN, LBColor.TEMP_SNOWY_TAIGA};
    public static final int DEFAULT_COLOR_INNER = LBColor.WHITE.getBladeColor();
    public static final int DEFAULT_COLOR_OUTER = LBColor.RED.getBladeColor();
    public static final int DEFAULT_COLOR_GRIP = LBColor.WHITE.getGripColor();
    public static final String KEY_ATK = "ATK";
    public static final String KEY_SPD = "SPD";
    public static final String KEY_GRIP_COLOR = "colorG";
    public static final String KEY_INNER_COLOR = "colorC";
    public static final String KEY_OUTER_COLOR = "colorH";
    public static final String KEY_IS_INNER_SUB_COLOR = "isSubC";
    public static final String KEY_IS_OUTER_SUB_COLOR = "isSubH";
    public static final String KEY_TOOLTIP_FIREPROOF = "upgrade.tolaserblade.fireproof";
    public static final String KEY_TOOLTIP_ATTACK_DAMAGE = "upgrade.tolaserblade.attackDamage";
    public static final String KEY_TOOLTIP_ATTACK_SPEED = "upgrade.tolaserblade.attackSpeed";
    public static final float MOD_SPD_MIN = 0.0f;
    public static final float MOD_SPD_MAX = 1.2f;
    public static final float MOD_ATK_MIN = 0.0f;
    public static final float MOD_ATK_CLASS_1 = -1.0f;
    public static final float MOD_ATK_CLASS_2 = 0.0f;
    public static final float MOD_ATK_CLASS_3 = 3.0f;
    public static final float MOD_ATK_CLASS_4 = 7.0f;
    public static final float MOD_ATK_CLASS_5 = 8.0f;
    public static final float MOD_ATK_MAX = 2041.0f;
    public static final float MOD_CRITICAL_BONUS_VS_WITHER = 0.5f;
    public static final int LVL_LIGHT_ELEMENT_1 = 1;
    public static final int LVL_LIGHT_ELEMENT_2 = 2;
    public static final int LVL_LIGHT_ELEMENT_5 = 5;
    public static final int MAX_USES = 32000;

    public static Item.Properties setFireproof(Item.Properties properties, boolean isFireproof) {
        return isFireproof ? properties.func_234689_a_() : properties;
    }

    default public int getGripColor(ItemStack stack) {
        int gripColor = DEFAULT_COLOR_GRIP;
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_150297_b(KEY_GRIP_COLOR, 3)) {
            gripColor = nbt.func_74762_e(KEY_GRIP_COLOR);
        }
        return gripColor;
    }

    default public Pair<Integer, Boolean> getBladeInnerColor(ItemStack stack) {
        int bladeInnerColor = DEFAULT_COLOR_INNER;
        boolean isBladeInnerSubColor = false;
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null) {
            if (nbt.func_150297_b(KEY_INNER_COLOR, 3)) {
                bladeInnerColor = nbt.func_74762_e(KEY_INNER_COLOR);
            }
            isBladeInnerSubColor = nbt.func_74767_n(KEY_IS_INNER_SUB_COLOR);
        }
        return Pair.of((Object)bladeInnerColor, (Object)isBladeInnerSubColor);
    }

    default public Pair<Integer, Boolean> getBladeOuterColor(ItemStack stack) {
        int bladeOuterColor = DEFAULT_COLOR_OUTER;
        boolean isBladeOuterSubColor = false;
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null) {
            if (nbt.func_150297_b(KEY_OUTER_COLOR, 3)) {
                bladeOuterColor = nbt.func_74762_e(KEY_OUTER_COLOR);
            }
            isBladeOuterSubColor = nbt.func_74767_n(KEY_IS_OUTER_SUB_COLOR);
        }
        return Pair.of((Object)bladeOuterColor, (Object)isBladeOuterSubColor);
    }

    default public int checkGamingColor(int colorIn) {
        if (colorIn == LBColor.SPECIAL_GAMING.getBladeColor()) {
            return this.getGamingColor();
        }
        return colorIn;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public int getGamingColor() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            int tick1 = (int)(player.field_70170_p.func_82737_E() % 30L);
            int tick2 = tick1 % 10;
            float partialTick = Minecraft.func_71410_x().func_184121_ak();
            if (tick2 % 10 < 5) {
                int colorElement = (int)(((float)tick2 + partialTick) * 51.0f) & 0xFF;
                switch (tick1 / 10) {
                    case 0: {
                        return 0xFFFF0000 | colorElement << 8;
                    }
                    case 1: {
                        return 0xFF00FF00 | colorElement;
                    }
                }
                return 0xFF0000FF | colorElement << 16;
            }
            int colorElement = (int)(((float)(10 - tick2) - partialTick) * 51.0f) & 0xFF;
            switch (tick1 / 10) {
                case 0: {
                    return 0xFF00FF00 | colorElement << 16;
                }
                case 1: {
                    return 0xFF0000FF | colorElement << 8;
                }
            }
            return 0xFFFF0000 | colorElement;
        }
        return -16711423;
    }

    default public ItemStack setGripColor(ItemStack stack, int color) {
        CompoundNBT nbt = stack.func_196082_o();
        nbt.func_74768_a(KEY_GRIP_COLOR, color);
        return stack;
    }

    default public ItemStack setBladeInnerColor(ItemStack stack, int color) {
        CompoundNBT nbt = stack.func_196082_o();
        nbt.func_74768_a(KEY_INNER_COLOR, color);
        return stack;
    }

    default public ItemStack setBladeOuterColor(ItemStack stack, int color) {
        CompoundNBT nbt = stack.func_196082_o();
        nbt.func_74768_a(KEY_OUTER_COLOR, color);
        return stack;
    }

    default public ItemStack setBladeInnerSubColorFlag(ItemStack stack, boolean isSubColor) {
        CompoundNBT nbt = stack.func_196082_o();
        nbt.func_74757_a(KEY_IS_INNER_SUB_COLOR, isSubColor);
        return stack;
    }

    default public ItemStack setBladeOuterSubColorFlag(ItemStack stack, boolean isSubColor) {
        CompoundNBT nbt = stack.func_196082_o();
        nbt.func_74757_a(KEY_IS_OUTER_SUB_COLOR, isSubColor);
        return stack;
    }

    default public float getLaserBladeATK(ItemStack stack) {
        float attackDamage = 0.0f;
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null) {
            attackDamage = MathHelper.func_76131_a((float)nbt.func_74760_g(KEY_ATK), (float)0.0f, (float)2041.0f);
        }
        return attackDamage;
    }

    default public float getLaserBladeSPD(ItemStack stack) {
        float attackSpeed = 0.0f;
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null) {
            attackSpeed = MathHelper.func_76131_a((float)nbt.func_74760_g(KEY_SPD), (float)0.0f, (float)1.2f);
        }
        return attackSpeed;
    }

    default public float getDestroySpeedRate(ItemStack stack) {
        float rate = (float)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185305_q, (ItemStack)stack) / 5.0f;
        rate = MathHelper.func_76131_a((float)rate, (float)0.0f, (float)1.0f);
        return rate;
    }

    default public ItemStack setLaserBladeATK(ItemStack stack, float atk) {
        float attackDamage = MathHelper.func_76131_a((float)atk, (float)0.0f, (float)2041.0f);
        CompoundNBT nbt = stack.func_196082_o();
        nbt.func_74776_a(KEY_ATK, attackDamage);
        return stack;
    }

    default public ItemStack setLaserBladeSPD(ItemStack stack, float spd) {
        float attackSpeed = MathHelper.func_76131_a((float)spd, (float)0.0f, (float)1.2f);
        CompoundNBT nbt = stack.func_196082_o();
        nbt.func_74776_a(KEY_SPD, attackSpeed);
        return stack;
    }

    default public int getBladeColorFromTintIndex(int index, boolean isInner) {
        return this.getColorFromTintIndex(index, true, isInner);
    }

    default public int getGripColorFromTintIndex(int index) {
        return this.getColorFromTintIndex(index, false, false);
    }

    default public int getColorFromTintIndex(int index, boolean isBlade, boolean isInner) {
        if (index >= 0 && index < colors.length) {
            return isBlade ? colors[index].getBladeColor() : colors[index].getGripColor();
        }
        return isBlade ? (isInner ? DEFAULT_COLOR_INNER : DEFAULT_COLOR_OUTER) : DEFAULT_COLOR_GRIP;
    }

    default public boolean canUpgrade(LaserBladeUpgrade.Type type) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void addLaserBladeInformation(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn, LaserBladeUpgrade.Type type) {
        float spd;
        float atk;
        boolean isFireproof = stack.func_77973_b().func_234687_u_();
        if (isFireproof) {
            tooltip.add((ITextComponent)new TranslationTextComponent(KEY_TOOLTIP_FIREPROOF).func_240699_a_(TextFormatting.GOLD));
        }
        if ((type == LaserBladeUpgrade.Type.REPAIR || type == LaserBladeUpgrade.Type.MEDIUM) && ((atk = this.getLaserBladeATK(stack)) <= -0.005f || (double)atk >= 0.005)) {
            tooltip.add(this.getUpgradeTextComponent(KEY_TOOLTIP_ATTACK_DAMAGE, atk));
        }
        if ((type == LaserBladeUpgrade.Type.REPAIR || type == LaserBladeUpgrade.Type.BATTERY) && ((spd = this.getLaserBladeSPD(stack)) <= -0.005f || (double)spd >= 0.005)) {
            tooltip.add(this.getUpgradeTextComponent(KEY_TOOLTIP_ATTACK_SPEED, spd));
        }
    }

    default public ITextComponent getUpgradeTextComponent(String key, float value) {
        return new TranslationTextComponent(key, new Object[]{(value < 0.0f ? "" : "+") + ItemStack.field_111284_a.format(value)}).func_240699_a_(TextFormatting.DARK_GREEN);
    }

    public static enum LBColor {
        WHITE(-1, -393218),
        ORANGE(-38881, -425955),
        MAGENTA(-65408, -3715395),
        LIGHT_BLUE(-16733441, -12930086),
        YELLOW(-4608, -75715),
        LIME(-5636302, -8337633),
        PINK(-65460, -816214),
        GRAY(-11184811, -12103854),
        LIGHT_GRAY(-5592406, -6447721),
        CYAN(-16711681, -15295332),
        PURPLE(-65281, -7785800),
        BLUE(-16776961, -12827478),
        BROWN(-38144, -8170446),
        GREEN(-8323328, -10585066),
        RED(-65536, -5231066),
        BLACK(-16645630, -14869215),
        TEMP_DESERT(-6291201, -393218),
        TEMP_SAVANNA(-65332, -393218),
        TEMP_JUNGLE(-15360, -393218),
        TEMP_TAIGA(-16711936, -393218),
        TEMP_ICE_PLAIN(-16744193, -393218),
        TEMP_SNOWY_TAIGA(-16764673, -393218),
        SPECIAL_GAMING(-16711423, -16711423);

        private final int bladeColor;
        private final int gripColor;

        private LBColor(int bladeColorIn, int gripColorIn) {
            this.bladeColor = bladeColorIn;
            this.gripColor = gripColorIn;
        }

        public int getBladeColor() {
            return this.bladeColor;
        }

        public int getGripColor() {
            return this.gripColor;
        }
    }
}

