/*
 * Decompiled with CFR 0.152.
 */
package com.github.iunius118.tolaserblade.network;

import com.github.iunius118.tolaserblade.ToLaserBlade;
import com.github.iunius118.tolaserblade.ToLaserBladeConfig;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class ServerConfigMessage {
    private static final Marker SVRCFGMSG_MARKER = MarkerManager.getMarker((String)"ServerConfigMessage");
    private final boolean isEnabledBlockingWithLaserBladeInServer;
    private final int laserBladeEfficiencyInServer;
    private final int maxAttackDamageUpgradeCountInServer;

    public ServerConfigMessage(ToLaserBladeConfig.ServerConfig serverConfig) {
        this.isEnabledBlockingWithLaserBladeInServer = serverConfig.isEnabledBlockingWithLaserBladeInServer;
        this.laserBladeEfficiencyInServer = serverConfig.laserBladeEfficiencyInServer;
        this.maxAttackDamageUpgradeCountInServer = serverConfig.maxAttackDamageUpgradeCountInServer;
    }

    public static void encode(ServerConfigMessage msg, PacketBuffer buf) {
        buf.writeBoolean(msg.isEnabledBlockingWithLaserBladeInServer);
        buf.writeInt(msg.laserBladeEfficiencyInServer);
        buf.writeInt(msg.maxAttackDamageUpgradeCountInServer);
    }

    public static ServerConfigMessage decode(PacketBuffer buf) {
        ToLaserBladeConfig.ServerConfig serverConfig = new ToLaserBladeConfig.ServerConfig();
        serverConfig.isEnabledBlockingWithLaserBladeInServer = buf.readBoolean();
        serverConfig.laserBladeEfficiencyInServer = buf.readInt();
        serverConfig.maxAttackDamageUpgradeCountInServer = buf.readInt();
        return new ServerConfigMessage(serverConfig);
    }

    public static void handle(ServerConfigMessage msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ToLaserBladeConfig.COMMON.isEnabledBlockingWithLaserBladeInServer = msg.isEnabledBlockingWithLaserBladeInServer ? () -> true : () -> false;
            ToLaserBlade.LOGGER.info(SVRCFGMSG_MARKER, "config.common.enabledBlockingWithLaserBladeInServer: {}", (Object)msg.isEnabledBlockingWithLaserBladeInServer);
            ToLaserBladeConfig.COMMON.laserBladeEfficiencyInServer = () -> msg.laserBladeEfficiencyInServer;
            ToLaserBlade.LOGGER.info(SVRCFGMSG_MARKER, "config.common.laserBladeEfficiencyInServer: {}", (Object)msg.laserBladeEfficiencyInServer);
            ToLaserBladeConfig.COMMON.maxAttackDamageUpgradeCountInServer = () -> msg.maxAttackDamageUpgradeCountInServer;
            ToLaserBlade.LOGGER.info(SVRCFGMSG_MARKER, "config.common.maxAttackDamageUpgradeCountInServer: {}", (Object)msg.maxAttackDamageUpgradeCountInServer);
        });
        ctx.get().setPacketHandled(true);
    }
}

