/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.block;

import com.google.common.cache.LoadingCache;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.block.pattern.BlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;
import quek.undergarden.registry.UndergardenBlocks;
import quek.undergarden.registry.UndergardenDimensions;
import quek.undergarden.registry.UndergardenSoundEvents;
import quek.undergarden.registry.UndergardenTags;
import quek.undergarden.world.UndergardenTeleporter;

public class UndergardenPortalBlock
extends Block {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.field_208199_z;
    protected static final VoxelShape X_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape Z_AABB = Block.func_208617_a((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);

    public UndergardenPortalBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151567_E).func_200943_b(-1.0f).func_200942_a().func_200951_a(10).func_222380_e());
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(AXIS, (Comparable)Direction.Axis.X));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction.Axis)state.func_177229_b(AXIS)) {
            case Z: {
                return Z_AABB;
            }
        }
        return X_AABB;
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
    }

    public boolean trySpawnPortal(IWorld worldIn, BlockPos pos) {
        Size UndergardenPortalBlock$size = this.isPortal(worldIn, pos);
        if (UndergardenPortalBlock$size != null && !UndergardenPortalBlock.onTrySpawnPortal(worldIn, pos, UndergardenPortalBlock$size)) {
            UndergardenPortalBlock$size.placePortalBlocks();
            return true;
        }
        return false;
    }

    public static boolean onTrySpawnPortal(IWorld world, BlockPos pos, Size size) {
        return MinecraftForge.EVENT_BUS.post((Event)new PortalSpawnEvent(world, pos, world.func_180495_p(pos), size));
    }

    @Nullable
    public Size isPortal(IWorld worldIn, BlockPos pos) {
        Size UndergardenPortalBlock$size = new Size(worldIn, pos, Direction.Axis.X);
        if (UndergardenPortalBlock$size.isValid() && UndergardenPortalBlock$size.portalBlockCount == 0) {
            return UndergardenPortalBlock$size;
        }
        Size UndergardenPortalBlock$size1 = new Size(worldIn, pos, Direction.Axis.Z);
        return UndergardenPortalBlock$size1.isValid() && UndergardenPortalBlock$size1.portalBlockCount == 0 ? UndergardenPortalBlock$size1 : null;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        Direction.Axis direction$axis = facing.func_176740_k();
        Direction.Axis direction$axis1 = (Direction.Axis)stateIn.func_177229_b(AXIS);
        boolean flag = direction$axis1 != direction$axis && direction$axis.func_176722_c();
        return !flag && facingState.func_177230_c() != this && !new Size(worldIn, currentPos, direction$axis1).func_208508_f() ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entity) {
        if (!entity.func_184218_aH() && !entity.func_184207_aI() && entity.func_184222_aU()) {
            if (entity.field_71088_bW > 0) {
                entity.field_71088_bW = entity.func_82147_ab();
            } else {
                if (!entity.field_70170_p.field_72995_K && !pos.equals((Object)entity.field_181016_an)) {
                    entity.field_181016_an = new BlockPos((Vec3i)pos);
                    BlockPattern.PatternHelper helper = UndergardenPortalBlock.createPatternHelper((IWorld)entity.field_70170_p, entity.field_181016_an);
                    double axis = helper.func_177669_b().func_176740_k() == Direction.Axis.X ? (double)helper.func_181117_a().func_177952_p() : (double)helper.func_181117_a().func_177958_n();
                    double x = Math.abs(MathHelper.func_181160_c((double)((helper.func_177669_b().func_176740_k() == Direction.Axis.X ? entity.func_226281_cx_() : entity.func_226277_ct_()) - (double)(helper.func_177669_b().func_176746_e().func_176743_c() == Direction.AxisDirection.NEGATIVE ? 1 : 0)), (double)axis, (double)(axis - (double)helper.func_181118_d())));
                    double y = MathHelper.func_181160_c((double)(entity.func_226278_cu_() - 1.0), (double)helper.func_181117_a().func_177956_o(), (double)(helper.func_181117_a().func_177956_o() - helper.func_181119_e()));
                    entity.field_181017_ao = new Vec3d(x, y, 0.0);
                    entity.field_181018_ap = helper.func_177669_b();
                }
                if (entity.field_70170_p instanceof ServerWorld && entity.field_70170_p.func_73046_m().func_71255_r() && !entity.func_184218_aH()) {
                    entity.field_71088_bW = entity.func_82147_ab();
                    DimensionType type = worldIn.field_73011_w.func_186058_p() == UndergardenDimensions.undergarden_dimension ? DimensionType.field_223227_a_ : UndergardenDimensions.undergarden_dimension;
                    entity.changeDimension(type, (ITeleporter)new UndergardenTeleporter());
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (rand.nextInt(100) == 0) {
            worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, UndergardenSoundEvents.UNDERGARDEN_PORTAL_AMBIENT, SoundCategory.BLOCKS, 0.5f, rand.nextFloat() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double d0 = (double)pos.func_177958_n() + (double)rand.nextFloat();
            double d1 = (double)pos.func_177956_o() + (double)rand.nextFloat();
            double d2 = (double)pos.func_177952_p() + (double)rand.nextFloat();
            double d3 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d4 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d5 = ((double)rand.nextFloat() - 0.5) * 0.5;
            int j = rand.nextInt(2) * 2 - 1;
            if (worldIn.func_180495_p(pos.func_177976_e()).func_177230_c() != this && worldIn.func_180495_p(pos.func_177974_f()).func_177230_c() != this) {
                d0 = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)j;
                d3 = rand.nextFloat() * 2.0f * (float)j;
            } else {
                d2 = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)j;
                d5 = rand.nextFloat() * 2.0f * (float)j;
            }
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0, d1, d2, d3, d4, d5);
        }
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return ItemStack.field_190927_a;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)state.func_177229_b(AXIS)) {
                    case Z: {
                        return (BlockState)state.func_206870_a(AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        return (BlockState)state.func_206870_a(AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                return state;
            }
        }
        return state;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{AXIS});
    }

    public static BlockPattern.PatternHelper createPatternHelper(IWorld world, BlockPos pos) {
        Direction.Axis direction$axis = Direction.Axis.Z;
        Size UndergardenPortalBlock$size = new Size(world, pos, Direction.Axis.X);
        LoadingCache loadingcache = BlockPattern.func_181627_a((IWorldReader)world, (boolean)true);
        if (!UndergardenPortalBlock$size.isValid()) {
            direction$axis = Direction.Axis.X;
            UndergardenPortalBlock$size = new Size(world, pos, Direction.Axis.Z);
        }
        if (!UndergardenPortalBlock$size.isValid()) {
            return new BlockPattern.PatternHelper(pos, Direction.NORTH, Direction.UP, loadingcache, 1, 1, 1);
        }
        int[] aint = new int[Direction.AxisDirection.values().length];
        Direction direction = UndergardenPortalBlock$size.rightDir.func_176735_f();
        BlockPos blockpos = UndergardenPortalBlock$size.bottomLeft.func_177981_b(UndergardenPortalBlock$size.getHeight() - 1);
        for (Direction.AxisDirection direction$axisdirection : Direction.AxisDirection.values()) {
            BlockPattern.PatternHelper blockpattern$patternhelper = new BlockPattern.PatternHelper(direction.func_176743_c() == direction$axisdirection ? blockpos : blockpos.func_177967_a(UndergardenPortalBlock$size.rightDir, UndergardenPortalBlock$size.getWidth() - 1), Direction.func_181076_a((Direction.AxisDirection)direction$axisdirection, (Direction.Axis)direction$axis), Direction.UP, loadingcache, UndergardenPortalBlock$size.getWidth(), UndergardenPortalBlock$size.getHeight(), 1);
            for (int i = 0; i < UndergardenPortalBlock$size.getWidth(); ++i) {
                for (int j = 0; j < UndergardenPortalBlock$size.getHeight(); ++j) {
                    CachedBlockInfo cachedblockinfo = blockpattern$patternhelper.func_177670_a(i, j, 1);
                    if (cachedblockinfo.func_177509_a().func_196958_f()) continue;
                    int n = direction$axisdirection.ordinal();
                    aint[n] = aint[n] + 1;
                }
            }
        }
        Direction.AxisDirection direction$axisdirection1 = Direction.AxisDirection.POSITIVE;
        for (Direction.AxisDirection direction$axisdirection2 : Direction.AxisDirection.values()) {
            if (aint[direction$axisdirection2.ordinal()] >= aint[direction$axisdirection1.ordinal()]) continue;
            direction$axisdirection1 = direction$axisdirection2;
        }
        return new BlockPattern.PatternHelper(direction.func_176743_c() == direction$axisdirection1 ? blockpos : blockpos.func_177967_a(UndergardenPortalBlock$size.rightDir, UndergardenPortalBlock$size.getWidth() - 1), Direction.func_181076_a((Direction.AxisDirection)direction$axisdirection1, (Direction.Axis)direction$axis), Direction.UP, loadingcache, UndergardenPortalBlock$size.getWidth(), UndergardenPortalBlock$size.getHeight(), 1);
    }

    public static class Size {
        private final IWorld world;
        private final Direction.Axis axis;
        private final Direction rightDir;
        private final Direction leftDir;
        private int portalBlockCount;
        @Nullable
        private BlockPos bottomLeft;
        private int height;
        private int width;

        public Size(IWorld worldIn, BlockPos pos, Direction.Axis axisIn) {
            this.world = worldIn;
            this.axis = axisIn;
            if (axisIn == Direction.Axis.X) {
                this.leftDir = Direction.EAST;
                this.rightDir = Direction.WEST;
            } else {
                this.leftDir = Direction.NORTH;
                this.rightDir = Direction.SOUTH;
            }
            BlockPos blockpos = pos;
            while (pos.func_177956_o() > blockpos.func_177956_o() - 21 && pos.func_177956_o() > 0 && this.func_196900_a(worldIn.func_180495_p(pos.func_177977_b()))) {
                pos = pos.func_177977_b();
            }
            int i = this.getDistanceUntilEdge(pos, this.leftDir) - 1;
            if (i >= 0) {
                this.bottomLeft = pos.func_177967_a(this.leftDir, i);
                this.width = this.getDistanceUntilEdge(this.bottomLeft, this.rightDir);
                if (this.width < 2 || this.width > 21) {
                    this.bottomLeft = null;
                    this.width = 0;
                }
            }
            if (this.bottomLeft != null) {
                this.height = this.calculatePortalHeight();
            }
        }

        protected int getDistanceUntilEdge(BlockPos pos, Direction directionIn) {
            BlockPos blockpos;
            int i;
            for (i = 0; i < 22 && this.func_196900_a(this.world.func_180495_p(blockpos = pos.func_177967_a(directionIn, i))) && this.world.func_180495_p(blockpos.func_177977_b()).func_177230_c().func_203417_a(UndergardenTags.Blocks.PORTAL_FRAME_BLOCKS); ++i) {
            }
            BlockPos framePos = pos.func_177967_a(directionIn, i);
            return this.world.func_180495_p(framePos).func_177230_c().func_203417_a(UndergardenTags.Blocks.PORTAL_FRAME_BLOCKS) ? i : 0;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        protected int calculatePortalHeight() {
            this.height = 0;
            block0: while (this.height < 21) {
                for (int i = 0; i < this.width; ++i) {
                    BlockPos framePos;
                    BlockPos blockpos = this.bottomLeft.func_177967_a(this.rightDir, i).func_177981_b(this.height);
                    BlockState blockstate = this.world.func_180495_p(blockpos);
                    if (!this.func_196900_a(blockstate)) break block0;
                    Block block = blockstate.func_177230_c();
                    if (block == UndergardenBlocks.undergarden_portal.get()) {
                        ++this.portalBlockCount;
                    }
                    if (i == 0 ? !this.world.func_180495_p(framePos = blockpos.func_177972_a(this.leftDir)).func_177230_c().func_203417_a(UndergardenTags.Blocks.PORTAL_FRAME_BLOCKS) : i == this.width - 1 && !this.world.func_180495_p(framePos = blockpos.func_177972_a(this.rightDir)).func_177230_c().func_203417_a(UndergardenTags.Blocks.PORTAL_FRAME_BLOCKS)) break block0;
                }
                ++this.height;
            }
            for (int j = 0; j < this.width; ++j) {
                BlockPos framePos = this.bottomLeft.func_177967_a(this.rightDir, j).func_177981_b(this.height);
                if (this.world.func_180495_p(framePos).func_177230_c().func_203417_a(UndergardenTags.Blocks.PORTAL_FRAME_BLOCKS)) continue;
                this.height = 0;
                break;
            }
            if (this.height <= 21 && this.height >= 3) {
                return this.height;
            }
            this.bottomLeft = null;
            this.width = 0;
            this.height = 0;
            return 0;
        }

        protected boolean func_196900_a(BlockState pos) {
            Block block = pos.func_177230_c();
            return pos.func_196958_f() || block == UndergardenBlocks.undergarden_portal.get();
        }

        public boolean isValid() {
            return this.bottomLeft != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
        }

        public void placePortalBlocks() {
            for (int i = 0; i < this.width; ++i) {
                BlockPos blockpos = this.bottomLeft.func_177967_a(this.rightDir, i);
                for (int j = 0; j < this.height; ++j) {
                    this.world.func_180501_a(blockpos.func_177981_b(j), (BlockState)((Block)UndergardenBlocks.undergarden_portal.get()).func_176223_P().func_206870_a(AXIS, (Comparable)this.axis), 18);
                }
            }
        }

        private boolean func_196899_f() {
            return this.portalBlockCount >= this.width * this.height;
        }

        public boolean func_208508_f() {
            return this.isValid() && this.func_196899_f();
        }
    }

    @Cancelable
    public static class PortalSpawnEvent
    extends BlockEvent {
        private final Size size;

        public PortalSpawnEvent(IWorld world, BlockPos pos, BlockState state, Size size) {
            super(world, pos, state);
            this.size = size;
        }

        public Size getPortalSize() {
            return this.size;
        }
    }
}

