/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.block.world;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import quek.undergarden.registry.UndergardenBlocks;
import quek.undergarden.registry.UndergardenEntities;
import quek.undergarden.registry.UndergardenItems;

public class BlisterberryBushBlock
extends Block
implements IGrowable,
IPlantable {
    public static final IntegerProperty AGE = BlockStateProperties.field_208168_U;
    private static final VoxelShape field_220126_b = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);
    private static final VoxelShape field_220127_c = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public BlisterberryBushBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151585_k).func_200943_b(0.0f).func_200947_a(SoundType.field_185850_c).func_200944_c().func_200942_a().func_200951_a(6));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
    }

    public boolean isValidGround(BlockState state, IBlockReader worldIn, BlockPos pos) {
        Block block = state.func_177230_c();
        return block == UndergardenBlocks.ashen_deepturf.get();
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        return this.isValidGround(worldIn.func_180495_p(blockpos), (IBlockReader)worldIn, blockpos);
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return false;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return type == PathType.AIR && !this.field_196274_w || super.func_196266_a(state, worldIn, pos, type);
    }

    public BlockState getPlant(IBlockReader world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return this.func_176223_P();
        }
        return state;
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)UndergardenItems.blisterberry.get());
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if ((Integer)state.func_177229_b((IProperty)AGE) == 0) {
            return field_220126_b;
        }
        return (Integer)state.func_177229_b((IProperty)AGE) < 3 ? field_220127_c : super.func_220053_a(state, worldIn, pos, context);
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        super.func_225534_a_(state, worldIn, pos, rand);
        int i = (Integer)state.func_177229_b((IProperty)AGE);
        if (i < 3 && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (rand.nextInt(5) == 0 ? 1 : 0) != 0)) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn != null && entityIn.func_200600_R() != UndergardenEntities.scintling) {
            entityIn.func_213295_a(state, new Vec3d((double)0.8f, 0.75, (double)0.8f));
            if (!(worldIn.field_72995_K || (Integer)state.func_177229_b((IProperty)AGE) <= 0 || entityIn.field_70142_S == entityIn.func_226277_ct_() && entityIn.field_70136_U == entityIn.func_226281_cx_())) {
                double d0 = Math.abs(entityIn.func_226277_ct_() - entityIn.field_70142_S);
                double d1 = Math.abs(entityIn.func_226281_cx_() - entityIn.field_70136_U);
                if (d0 >= (double)0.003f || d1 >= (double)0.003f) {
                    entityIn.func_70097_a(DamageSource.field_220302_v, 2.0f);
                }
            }
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult p_225533_6_) {
        boolean flag;
        int age = (Integer)state.func_177229_b((IProperty)AGE);
        boolean bl = flag = age == 3;
        if (!flag && player.func_184586_b(handIn).func_77973_b() == Items.field_196106_bc) {
            return ActionResultType.PASS;
        }
        if (age > 1) {
            int random = 1 + worldIn.field_73012_v.nextInt(2);
            int random2 = worldIn.field_73012_v.nextInt(2);
            BlisterberryBushBlock.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)UndergardenItems.blisterberry.get(), random + (flag ? 1 : 0)));
            BlisterberryBushBlock.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)UndergardenItems.rotten_blisterberry.get(), random2 + (flag ? 1 : 0)));
            worldIn.func_184133_a(null, pos, SoundEvents.field_219693_lB, SoundCategory.BLOCKS, 1.0f, 0.8f + worldIn.field_73012_v.nextFloat() * 0.4f);
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(1)), 2);
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, p_225533_6_);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{AGE});
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return (Integer)state.func_177229_b((IProperty)AGE) < 3;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        int i = Math.min(3, (Integer)state.func_177229_b((IProperty)AGE) + 1);
        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(i)), 2);
    }
}

