/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.block.world;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;
import quek.undergarden.block.world.UndergardenBushBlock;
import quek.undergarden.registry.UndergardenBlocks;

public class DitchbulbBlock
extends UndergardenBushBlock {
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0);

    public DitchbulbBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151582_l).func_200943_b(0.0f).func_200947_a(SoundType.field_185850_c).func_200942_a().func_226896_b_().func_200951_a(6));
    }

    @Override
    public boolean isValidGround(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_200015_d(worldIn, pos);
    }

    @Override
    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        Block block = blockstate.func_177230_c();
        if (block != UndergardenBlocks.deepturf_block.get() && block != UndergardenBlocks.deepsoil.get() && block != UndergardenBlocks.depthrock.get()) {
            return worldIn.func_226659_b_(pos, 0) < 0 && blockstate.canSustainPlant((IBlockReader)worldIn, blockpos, Direction.UP, (IPlantable)this);
        }
        return true;
    }

    @Override
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        double d0 = (double)pos.func_177958_n() + 0.5;
        double d1 = (double)pos.func_177956_o() + 0.8;
        double d2 = (double)pos.func_177952_p() + 0.5;
        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d0, d1, d2, 0.0, 0.0, 0.0);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }
}

