/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.block.world;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import quek.undergarden.registry.UndergardenBlocks;

public class GlowingKelpTopBlock
extends Block
implements ILiquidContainer {
    public static final IntegerProperty AGE = BlockStateProperties.field_208172_Y;
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);

    public GlowingKelpTopBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_203243_f).func_200942_a().func_200943_b(0.0f).func_200947_a(SoundType.field_211382_m).func_200951_a(5));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        return ifluidstate.func_206884_a(FluidTags.field_206959_a) && ifluidstate.func_206882_g() == 8 ? this.randomAge((IWorld)context.func_195991_k()) : null;
    }

    public BlockState randomAge(IWorld world) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(world.func_201674_k().nextInt(25)));
    }

    public IFluidState func_204507_t(BlockState state) {
        return Fluids.field_204546_a.func_207204_a(false);
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (!state.func_196955_c((IWorldReader)worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
        } else {
            BlockPos blockpos = pos.func_177984_a();
            BlockState blockstate = worldIn.func_180495_p(blockpos);
            if (blockstate.func_177230_c() == Blocks.field_150355_j && (Integer)state.func_177229_b((IProperty)AGE) < 25 && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)blockpos, (BlockState)state, (rand.nextDouble() < 0.14 ? 1 : 0) != 0)) {
                worldIn.func_175656_a(blockpos, (BlockState)state.func_177231_a((IProperty)AGE));
                ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)blockpos, (BlockState)state);
            }
        }
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        Block block = blockstate.func_177230_c();
        if (block == Blocks.field_196814_hQ) {
            return false;
        }
        return block == this || block == UndergardenBlocks.glowing_kelp_plant.get() || blockstate.func_224755_d((IBlockReader)worldIn, blockpos, Direction.UP);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!stateIn.func_196955_c((IWorldReader)worldIn, currentPos)) {
            if (facing == Direction.UP) {
                return Blocks.field_150350_a.func_176223_P();
            }
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        }
        if (facing == Direction.DOWN && facingState.func_177230_c() == this) {
            return ((Block)UndergardenBlocks.glowing_kelp_plant.get()).func_176223_P();
        }
        worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{AGE});
    }

    public boolean func_204510_a(IBlockReader worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return false;
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, IFluidState fluidStateIn) {
        return false;
    }
}

