/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.block.world;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.LogBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityType;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import quek.undergarden.registry.UndergardenBlocks;

public class UndergardenLeavesBlock
extends LeavesBlock {
    public static final IntegerProperty DISTANCE = BlockStateProperties.field_208514_aa;

    public UndergardenLeavesBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151584_j).func_200943_b(0.2f).func_200947_a(SoundType.field_185850_c).func_226896_b_());
    }

    public boolean isFlammable(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return true;
    }

    public int getFlammability(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return 300;
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        worldIn.func_180501_a(pos, UndergardenLeavesBlock.updateDistance(state, (IWorld)worldIn, pos), 3);
    }

    private static BlockState updateDistance(BlockState state, IWorld worldIn, BlockPos pos) {
        int i = 7;
        try (BlockPos.PooledMutable blockpos$pooledmutable = BlockPos.PooledMutable.func_185346_s();){
            for (Direction direction : Direction.values()) {
                blockpos$pooledmutable.func_189533_g((Vec3i)pos).func_189536_c(direction);
                i = Math.min(i, UndergardenLeavesBlock.getDistance(worldIn.func_180495_p((BlockPos)blockpos$pooledmutable)) + 1);
                if (i != 1) continue;
                break;
            }
        }
        return (BlockState)state.func_206870_a((IProperty)DISTANCE, (Comparable)Integer.valueOf(i));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        int i = UndergardenLeavesBlock.getDistance(facingState) + 1;
        if (i != 1 || (Integer)stateIn.func_177229_b((IProperty)DISTANCE) != i) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        }
        return stateIn;
    }

    private static int getDistance(BlockState neighbor) {
        if (((LogBlock)UndergardenBlocks.smogstem_log.get()).func_176223_P() == neighbor.getBlockState()) {
            return 0;
        }
        if (((LogBlock)UndergardenBlocks.wigglewood_log.get()).func_176223_P() == neighbor.getBlockState()) {
            return 0;
        }
        return neighbor.func_177230_c() instanceof UndergardenLeavesBlock ? (Integer)neighbor.func_177229_b((IProperty)DISTANCE) : 7;
    }

    public boolean func_220067_a(BlockState state, IBlockReader worldIn, BlockPos pos, EntityType<?> type) {
        return false;
    }
}

