/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.block.world;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IPlantable;
import quek.undergarden.block.world.UndergardenBushBlock;
import quek.undergarden.registry.UndergardenBlocks;

public class UndergardenMushroomBlock
extends UndergardenBushBlock
implements IGrowable {
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);

    public UndergardenMushroomBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151585_k).func_200942_a().func_200944_c().func_200943_b(0.0f).func_200947_a(SoundType.field_185850_c));
    }

    public UndergardenMushroomBlock(int light) {
        super(Block.Properties.func_200945_a((Material)Material.field_151585_k).func_200942_a().func_200944_c().func_200943_b(0.0f).func_200947_a(SoundType.field_185850_c).func_200951_a(light));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (rand.nextInt(25) == 0) {
            int i = 5;
            int j = 4;
            for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-4, -1, -4), (BlockPos)pos.func_177982_a(4, 1, 4))) {
                if (worldIn.func_180495_p(blockpos).func_177230_c() != this || --i > 0) continue;
                return;
            }
            BlockPos blockpos1 = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(2) - rand.nextInt(2), rand.nextInt(3) - 1);
            for (int k = 0; k < 4; ++k) {
                if (worldIn.func_175623_d(blockpos1) && state.func_196955_c((IWorldReader)worldIn, blockpos1)) {
                    pos = blockpos1;
                }
                blockpos1 = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(2) - rand.nextInt(2), rand.nextInt(3) - 1);
            }
            if (worldIn.func_175623_d(blockpos1) && state.func_196955_c((IWorldReader)worldIn, blockpos1)) {
                worldIn.func_180501_a(blockpos1, state, 2);
            }
        }
    }

    @Override
    public boolean isValidGround(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_200015_d(worldIn, pos);
    }

    @Override
    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        Block block = blockstate.func_177230_c();
        if (block != UndergardenBlocks.deepturf_block.get() && block != UndergardenBlocks.deepsoil.get()) {
            return worldIn.func_226659_b_(pos, 0) < 13 && blockstate.canSustainPlant((IBlockReader)worldIn, blockpos, Direction.UP, (IPlantable)this);
        }
        return true;
    }

    public boolean bigShroom(ServerWorld world, BlockPos pos, BlockState state, Random rand) {
        ConfiguredFeature configuredfeature;
        world.func_217377_a(pos, false);
        if (this == Blocks.field_150338_P) {
            configuredfeature = Feature.field_202319_S.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226768_ac_);
        } else {
            if (this != Blocks.field_150337_Q) {
                world.func_180501_a(pos, state, 3);
                return false;
            }
            configuredfeature = Feature.field_202318_R.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226767_ab_);
        }
        if (configuredfeature.func_222734_a((IWorld)world, world.func_72863_F().func_201711_g(), rand, pos)) {
            return true;
        }
        world.func_180501_a(pos, state, 3);
        return false;
    }

    public boolean func_176473_a(IBlockReader iBlockReader, BlockPos blockPos, BlockState blockState, boolean b) {
        return false;
    }

    public boolean func_180670_a(World world, Random random, BlockPos blockPos, BlockState blockState) {
        return false;
    }

    public void func_225535_a_(ServerWorld world, Random rand, BlockPos pos, BlockState state) {
        this.bigShroom(world, pos, state, rand);
    }
}

