/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client;

import java.awt.Color;
import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.entity.SpriteRenderer;
import net.minecraft.item.BlockItem;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import quek.undergarden.UndergardenConfig;
import quek.undergarden.client.audio.OthersideAmbianceSound;
import quek.undergarden.client.audio.UndergardenAmbianceSound;
import quek.undergarden.client.render.entity.BlisterbomberRender;
import quek.undergarden.client.render.entity.BruteRender;
import quek.undergarden.client.render.entity.DwellerRender;
import quek.undergarden.client.render.entity.GloomperRender;
import quek.undergarden.client.render.entity.GwiblingRender;
import quek.undergarden.client.render.entity.MasticatorRender;
import quek.undergarden.client.render.entity.RotDwellerRender;
import quek.undergarden.client.render.entity.RotbeastRender;
import quek.undergarden.client.render.entity.RotwalkerRender;
import quek.undergarden.client.render.entity.ScintlingRender;
import quek.undergarden.registry.UndergardenBlocks;
import quek.undergarden.registry.UndergardenEntities;
import quek.undergarden.registry.UndergardenSoundEvents;
import quek.undergarden.world.OthersideDimension;
import quek.undergarden.world.UndergardenDimension;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="undergarden", value={Dist.CLIENT})
public class ClientStuff {
    private static final Minecraft CLIENT = Minecraft.func_71410_x();
    private static ISound playingMusic;
    private static final ISound UNDERGARDEN_AMBIANCE;
    private static final ISound OTHERSIDE_AMBIANCE;

    private static void render(Supplier<? extends Block> block, RenderType render) {
        RenderTypeLookup.setRenderLayer((Block)block.get(), (RenderType)render);
    }

    public static void registerBlockRenderers() {
        RenderType cutout = RenderType.func_228643_e_();
        RenderType mipped = RenderType.func_228641_d_();
        RenderType translucent = RenderType.func_228645_f_();
        ClientStuff.render(UndergardenBlocks.deepturf_block, mipped);
        ClientStuff.render(UndergardenBlocks.tall_deepturf, cutout);
        ClientStuff.render(UndergardenBlocks.shimmerweed, cutout);
        ClientStuff.render(UndergardenBlocks.smogstem_sapling, cutout);
        ClientStuff.render(UndergardenBlocks.wigglewood_sapling, cutout);
        ClientStuff.render(UndergardenBlocks.indigo_mushroom, cutout);
        ClientStuff.render(UndergardenBlocks.veil_mushroom, cutout);
        ClientStuff.render(UndergardenBlocks.ink_mushroom, cutout);
        ClientStuff.render(UndergardenBlocks.blood_mushroom, cutout);
        ClientStuff.render(UndergardenBlocks.underbean_bush, cutout);
        ClientStuff.render(UndergardenBlocks.smogstem_torch, cutout);
        ClientStuff.render(UndergardenBlocks.smogstem_wall_torch, cutout);
        ClientStuff.render(UndergardenBlocks.ditchbulb_plant, cutout);
        ClientStuff.render(UndergardenBlocks.double_deepturf, cutout);
        ClientStuff.render(UndergardenBlocks.double_shimmerweed, cutout);
        ClientStuff.render(UndergardenBlocks.cloggrum_bars, cutout);
        ClientStuff.render(UndergardenBlocks.glowing_kelp, cutout);
        ClientStuff.render(UndergardenBlocks.glowing_kelp_plant, cutout);
        ClientStuff.render(UndergardenBlocks.glowing_sea_grass, cutout);
        ClientStuff.render(UndergardenBlocks.undergarden_portal, translucent);
        ClientStuff.render(UndergardenBlocks.goo, translucent);
        ClientStuff.render(UndergardenBlocks.smogstem_door, cutout);
        ClientStuff.render(UndergardenBlocks.wigglewood_door, cutout);
        ClientStuff.render(UndergardenBlocks.smogstem_trapdoor, cutout);
        ClientStuff.render(UndergardenBlocks.wigglewood_trapdoor, cutout);
        ClientStuff.render(UndergardenBlocks.ashen_tall_deepturf, cutout);
        ClientStuff.render(UndergardenBlocks.blisterberry_bush, cutout);
        ClientStuff.render(UndergardenBlocks.gloomgourd_stem, cutout);
        ClientStuff.render(UndergardenBlocks.gloomgourd_stem_attached, cutout);
    }

    public static void registerEntityRenderers() {
        ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
        RenderingRegistry.registerEntityRenderingHandler(UndergardenEntities.slingshot_ammo, entity -> new SpriteRenderer(entity, itemRenderer));
        RenderingRegistry.registerEntityRenderingHandler(UndergardenEntities.goo_ball, entity -> new SpriteRenderer(entity, itemRenderer));
        RenderingRegistry.registerEntityRenderingHandler(UndergardenEntities.rotten_blisterberry, entity -> new SpriteRenderer(entity, itemRenderer));
        RenderingRegistry.registerEntityRenderingHandler(UndergardenEntities.blisterbomb, entity -> new SpriteRenderer(entity, itemRenderer));
        RenderingRegistry.registerEntityRenderingHandler(UndergardenEntities.rotwalker, RotwalkerRender::new);
        RenderingRegistry.registerEntityRenderingHandler(UndergardenEntities.rotbeast, RotbeastRender::new);
        RenderingRegistry.registerEntityRenderingHandler(UndergardenEntities.dweller, DwellerRender::new);
        RenderingRegistry.registerEntityRenderingHandler(UndergardenEntities.rotdweller, RotDwellerRender::new);
        RenderingRegistry.registerEntityRenderingHandler(UndergardenEntities.gwibling, GwiblingRender::new);
        RenderingRegistry.registerEntityRenderingHandler(UndergardenEntities.brute, BruteRender::new);
        RenderingRegistry.registerEntityRenderingHandler(UndergardenEntities.scintling, ScintlingRender::new);
        RenderingRegistry.registerEntityRenderingHandler(UndergardenEntities.blisterbomber, BlisterbomberRender::new);
        RenderingRegistry.registerEntityRenderingHandler(UndergardenEntities.gloomper, GloomperRender::new);
        RenderingRegistry.registerEntityRenderingHandler(UndergardenEntities.masticator, MasticatorRender::new);
    }

    public static void registerBlockColors() {
        BlockColors colors = Minecraft.func_71410_x().func_184125_al();
        colors.func_186722_a((state, world, pos, tint) -> world != null && pos != null ? BiomeColors.func_228358_a_((ILightReader)world, (BlockPos)pos) : new Color(91, 117, 91).getRGB(), new Block[]{(Block)UndergardenBlocks.deepturf_block.get(), (Block)UndergardenBlocks.tall_deepturf.get(), (Block)UndergardenBlocks.shimmerweed.get(), (Block)UndergardenBlocks.double_deepturf.get(), (Block)UndergardenBlocks.double_shimmerweed.get(), (Block)UndergardenBlocks.gloomgourd_stem.get(), (Block)UndergardenBlocks.gloomgourd_stem_attached.get()});
    }

    public static void registerItemColors() {
        BlockColors bColors = Minecraft.func_71410_x().func_184125_al();
        ItemColors iColors = Minecraft.func_71410_x().getItemColors();
        iColors.func_199877_a((stack, tint) -> bColors.func_228054_a_(((BlockItem)stack.func_77973_b()).func_179223_d().func_176223_P(), null, null, 0), new IItemProvider[]{(IItemProvider)UndergardenBlocks.deepturf_block.get(), (IItemProvider)UndergardenBlocks.tall_deepturf.get(), (IItemProvider)UndergardenBlocks.shimmerweed.get(), (IItemProvider)UndergardenBlocks.double_shimmerweed.get(), (IItemProvider)UndergardenBlocks.double_deepturf.get()});
        iColors.func_199877_a((stack, tint) -> {
            if (tint == 0) {
                return new Color(91, 117, 91).getRGB();
            }
            return -1;
        }, new IItemProvider[]{(IItemProvider)UndergardenBlocks.shimmerweed.get(), (IItemProvider)UndergardenBlocks.double_shimmerweed.get()});
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (!CLIENT.func_147113_T()) {
            ClientPlayerEntity player = ClientStuff.CLIENT.field_71439_g;
            if (player == null) {
                return;
            }
            if (event.phase == TickEvent.Phase.END && playingMusic != null && !CLIENT.func_147118_V().func_215294_c(playingMusic)) {
                playingMusic = null;
            }
            if (UndergardenDimension.isTheUndergarden(player.field_70170_p)) {
                ClientStuff.doAmbiance(UNDERGARDEN_AMBIANCE);
            }
            if (OthersideDimension.isTheOtherside(player.field_70170_p)) {
                ClientStuff.doAmbiance(OTHERSIDE_AMBIANCE);
            }
        }
    }

    @SubscribeEvent
    public static void onPlaySound(PlaySoundEvent event) {
        if (!ClientStuff.isMusicSound()) {
            return;
        }
        if (ClientStuff.CLIENT.field_71439_g != null && UndergardenDimension.isTheUndergarden(ClientStuff.CLIENT.field_71439_g.field_70170_p)) {
            SoundEvent sound = UndergardenSoundEvents.UNDERGARDEN_MUSIC;
            if (sound == null || playingMusic != null) {
                event.setResultSound(null);
                return;
            }
            playingMusic = SimpleSound.func_184370_a((SoundEvent)sound);
            event.setResultSound(playingMusic);
        }
    }

    private static boolean isMusicSound() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        return Arrays.stream(stackTrace).anyMatch(e -> e.getClassName().equals(MusicTicker.class.getName()));
    }

    private static void doAmbiance(ISound sound) {
        SoundHandler soundHandler;
        if (((Boolean)UndergardenConfig.toggleAmbiance.get()).booleanValue() && !(soundHandler = CLIENT.func_147118_V()).func_215294_c(sound)) {
            try {
                soundHandler.func_147683_b(sound);
                soundHandler.func_147682_a(sound);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    static {
        UNDERGARDEN_AMBIANCE = new UndergardenAmbianceSound();
        OTHERSIDE_AMBIANCE = new OthersideAmbianceSound();
    }
}

