/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.model;

import com.google.common.collect.ImmutableSet;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import quek.undergarden.entity.RotbeastEntity;

@OnlyIn(value=Dist.CLIENT)
public class RotbeastModel<T extends RotbeastEntity>
extends SegmentedModel<T> {
    private final ModelRenderer rotbeast;
    private final ModelRenderer head;
    private final ModelRenderer jaw;
    private final ModelRenderer leftarm;
    private final ModelRenderer lowerarm;
    private final ModelRenderer rightarm;
    private final ModelRenderer lowerarm2;
    private final ModelRenderer torso;
    private final ModelRenderer torsolower;
    private final ModelRenderer leftleg;
    private final ModelRenderer lowerleg;
    private final ModelRenderer rightleg;
    private final ModelRenderer lowerleg2;

    public RotbeastModel() {
        this.field_78090_t = 128;
        this.field_78089_u = 128;
        this.rotbeast = new ModelRenderer((Model)this);
        this.rotbeast.func_78793_a(0.0f, 24.0f, 0.0f);
        this.head = new ModelRenderer((Model)this);
        this.head.func_78793_a(0.0f, -35.0f, -8.0f);
        this.rotbeast.func_78792_a(this.head);
        this.setRotationAngle(this.head, 0.3491f, 0.0f, 0.0f);
        this.head.func_78784_a(0, 22).func_228303_a_(-5.0f, -9.0f, -7.0f, 10.0f, 6.0f, 7.0f, 0.0f, false);
        this.head.func_78784_a(0, 83).func_228303_a_(-3.0f, -8.0f, -1.0f, 6.0f, 9.0f, 2.0f, 0.0f, true);
        this.jaw = new ModelRenderer((Model)this);
        this.jaw.func_78793_a(0.0f, 0.0f, 0.0f);
        this.head.func_78792_a(this.jaw);
        this.setRotationAngle(this.jaw, 0.2618f, 0.0f, 0.0f);
        this.jaw.func_78784_a(22, 66).func_228303_a_(-5.0f, -3.0f, -6.0f, 10.0f, 1.0f, 6.0f, 0.0f, false);
        this.leftarm = new ModelRenderer((Model)this);
        this.leftarm.func_78793_a(10.0f, -32.0f, -4.0f);
        this.rotbeast.func_78792_a(this.leftarm);
        this.setRotationAngle(this.leftarm, 0.2618f, 0.0f, 0.0f);
        this.leftarm.func_78784_a(34, 22).func_228303_a_(0.0f, -2.0f, -3.0f, 5.0f, 18.0f, 6.0f, 0.0f, false);
        this.lowerarm = new ModelRenderer((Model)this);
        this.lowerarm.func_78793_a(2.0f, 16.0f, 0.0f);
        this.leftarm.func_78792_a(this.lowerarm);
        this.setRotationAngle(this.lowerarm, -0.3491f, 0.0f, 0.0f);
        this.lowerarm.func_78784_a(0, 46).func_228303_a_(-2.0f, -1.0f, -3.0f, 5.0f, 14.0f, 6.0f, 0.0f, false);
        this.rightarm = new ModelRenderer((Model)this);
        this.rightarm.func_78793_a(-10.0f, -32.0f, -4.0f);
        this.rotbeast.func_78792_a(this.rightarm);
        this.setRotationAngle(this.rightarm, 0.2618f, 0.0f, 0.0f);
        this.rightarm.func_78784_a(34, 22).func_228303_a_(-5.0f, -2.0f, -3.0f, 5.0f, 18.0f, 6.0f, 0.0f, true);
        this.lowerarm2 = new ModelRenderer((Model)this);
        this.lowerarm2.func_78793_a(-2.0f, 16.0f, 0.0f);
        this.rightarm.func_78792_a(this.lowerarm2);
        this.setRotationAngle(this.lowerarm2, -0.3491f, 0.0f, 0.0f);
        this.lowerarm2.func_78784_a(0, 46).func_228303_a_(-3.0f, -1.0f, -3.0f, 5.0f, 14.0f, 6.0f, 0.0f, true);
        this.torso = new ModelRenderer((Model)this);
        this.torso.func_78793_a(0.0f, -30.0f, -3.0f);
        this.rotbeast.func_78792_a(this.torso);
        this.setRotationAngle(this.torso, 0.6109f, 0.0f, 0.0f);
        this.torso.func_78784_a(0, 0).func_228303_a_(-10.0f, -7.0f, -5.0f, 20.0f, 12.0f, 10.0f, 0.0f, false);
        this.torsolower = new ModelRenderer((Model)this);
        this.torsolower.func_78793_a(0.0f, 8.0f, -2.0f);
        this.torso.func_78792_a(this.torsolower);
        this.setRotationAngle(this.torsolower, -0.3491f, 0.0f, 0.0f);
        this.torsolower.func_78784_a(60, 0).func_228303_a_(-8.0f, -5.0f, -1.0f, 16.0f, 11.0f, 6.0f, 0.0f, false);
        this.leftleg = new ModelRenderer((Model)this);
        this.leftleg.func_78793_a(4.0f, -17.0f, 3.0f);
        this.rotbeast.func_78792_a(this.leftleg);
        this.setRotationAngle(this.leftleg, -0.3491f, 0.0f, 0.0f);
        this.leftleg.func_78784_a(54, 66).func_228303_a_(-2.0f, -1.0f, -3.0f, 5.0f, 8.0f, 6.0f, 0.0f, false);
        this.lowerleg = new ModelRenderer((Model)this);
        this.lowerleg.func_78793_a(0.0f, 7.0f, 1.0f);
        this.leftleg.func_78792_a(this.lowerleg);
        this.setRotationAngle(this.lowerleg, 0.3491f, 0.0f, 0.0f);
        this.lowerleg.func_78784_a(44, 46).func_228303_a_(-2.0f, -1.0f, -4.0f, 5.0f, 11.0f, 6.0f, 0.0f, false);
        this.rightleg = new ModelRenderer((Model)this);
        this.rightleg.func_78793_a(-4.0f, -17.0f, 3.0f);
        this.rotbeast.func_78792_a(this.rightleg);
        this.setRotationAngle(this.rightleg, -0.3491f, 0.0f, 0.0f);
        this.rightleg.func_78784_a(54, 66).func_228303_a_(-3.0f, -1.0f, -3.0f, 5.0f, 8.0f, 6.0f, 0.0f, true);
        this.lowerleg2 = new ModelRenderer((Model)this);
        this.lowerleg2.func_78793_a(0.0f, 7.0f, 1.0f);
        this.rightleg.func_78792_a(this.lowerleg2);
        this.setRotationAngle(this.lowerleg2, 0.3491f, 0.0f, 0.0f);
        this.lowerleg2.func_78784_a(44, 46).func_228303_a_(-3.0f, -1.0f, -4.0f, 5.0f, 11.0f, 6.0f, 0.0f, true);
    }

    public void setRotationAngles(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
        this.head.field_78795_f = 0.3491f + headPitch * ((float)Math.PI / 180);
        this.leftleg.field_78795_f = -0.3491f + MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.rightleg.field_78795_f = -0.3491f + MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
    }

    public void setLivingAnimations(T entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        int i = ((RotbeastEntity)((Object)entityIn)).getAttackTimer();
        if (i > 0) {
            this.rightarm.field_78795_f = -2.0f + 1.5f * this.triangleWave((float)i - partialTick, 10.0f);
            this.leftarm.field_78795_f = -2.0f + 1.5f * this.triangleWave((float)i - partialTick, 10.0f);
        } else {
            this.rightarm.field_78795_f = (-0.2f + 1.5f * this.triangleWave(limbSwing, 13.0f)) * limbSwingAmount;
            this.leftarm.field_78795_f = (-0.2f - 1.5f * this.triangleWave(limbSwing, 13.0f)) * limbSwingAmount;
        }
    }

    private float triangleWave(float p_78172_1_, float p_78172_2_) {
        return (Math.abs(p_78172_1_ % p_78172_2_ - p_78172_2_ * 0.5f) - p_78172_2_ * 0.25f) / (p_78172_2_ * 0.25f);
    }

    public Iterable<ModelRenderer> func_225601_a_() {
        return ImmutableSet.of((Object)this.rotbeast);
    }

    public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }
}

