/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.SkyRenderHandler;

public class OthersideSkyRender
implements SkyRenderHandler {
    private static final ResourceLocation VORTEX_TEXTURE = new ResourceLocation("undergarden", "textures/environment/otherside_vortex.png");
    private final VertexFormat skyVertexFormat = DefaultVertexFormats.field_181705_e;
    @Nullable
    private VertexBuffer skyVBO;
    @Nullable
    private VertexBuffer sky2VBO;

    public OthersideSkyRender() {
        this.generateSky();
        this.generateSky2();
    }

    private void generateSky() {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        if (this.skyVBO != null) {
            this.skyVBO.close();
        }
        this.skyVBO = new VertexBuffer(this.skyVertexFormat);
        this.renderSky(bufferbuilder, 32.0f, false);
        bufferbuilder.func_178977_d();
        this.skyVBO.func_227875_a_(bufferbuilder);
    }

    private void renderSky(BufferBuilder bufferBuilderIn, float posY, boolean reverseX) {
        bufferBuilderIn.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (int k = -384; k <= 384; k += 64) {
            for (int l = -384; l <= 384; l += 64) {
                float f = k;
                float f1 = k + 64;
                if (reverseX) {
                    f1 = k;
                    f = k + 64;
                }
                bufferBuilderIn.func_225582_a_((double)f, (double)posY, (double)l).func_181675_d();
                bufferBuilderIn.func_225582_a_((double)f1, (double)posY, (double)l).func_181675_d();
                bufferBuilderIn.func_225582_a_((double)f1, (double)posY, (double)(l + 64)).func_181675_d();
                bufferBuilderIn.func_225582_a_((double)f, (double)posY, (double)(l + 64)).func_181675_d();
            }
        }
    }

    private void generateSky2() {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        if (this.sky2VBO != null) {
            this.sky2VBO.close();
        }
        this.sky2VBO = new VertexBuffer(this.skyVertexFormat);
        this.renderSky(bufferbuilder, -32.0f, true);
        bufferbuilder.func_178977_d();
        this.sky2VBO.func_227875_a_(bufferbuilder);
    }

    public void render(int ticks, float partialTicks, MatrixStack matrixStack, ClientWorld world, Minecraft mc) {
        float blue;
        float green;
        float red;
        TextureManager textureManager = mc.func_110434_K();
        RenderSystem.disableTexture();
        Vec3d vec3d = world.func_228318_a_(mc.field_71460_t.func_215316_n().func_216780_d(), partialTicks);
        float f = (float)vec3d.field_72450_a;
        float f1 = (float)vec3d.field_72448_b;
        float f2 = (float)vec3d.field_72449_c;
        FogRenderer.func_228373_b_();
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableFog();
        RenderSystem.color3f((float)f, (float)f1, (float)f2);
        this.skyVBO.func_177359_a();
        this.skyVertexFormat.func_227892_a_(0L);
        this.skyVBO.func_227874_a_(matrixStack.func_227866_c_().func_227870_a_(), 7);
        VertexBuffer.func_177361_b();
        this.skyVertexFormat.func_227895_d_();
        RenderSystem.disableFog();
        RenderSystem.disableAlphaTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableTexture();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        matrixStack.func_227860_a_();
        RenderSystem.color4f((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-180.0f));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(70.0f));
        Matrix4f matrix4f1 = matrixStack.func_227866_c_().func_227870_a_();
        float f12 = 60.0f;
        textureManager.func_110577_a(VORTEX_TEXTURE);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_227888_a_(matrix4f1, -f12, 100.0f, -f12).func_225583_a_(0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, f12, 100.0f, -f12).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, f12, 100.0f, f12).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, -f12, 100.0f, f12).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        RenderSystem.disableTexture();
        this.skyVertexFormat.func_227895_d_();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableFog();
        matrixStack.func_227865_b_();
        RenderSystem.disableTexture();
        if (world.field_73011_w.func_76561_g()) {
            red = f * 0.2f + 0.04f;
            green = f1 * 0.2f + 0.04f;
            blue = f2 * 0.6f + 0.1f;
        } else {
            red = f;
            green = f1;
            blue = f2;
        }
        RenderSystem.color3f((float)red, (float)green, (float)blue);
        RenderSystem.enableTexture();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableFog();
    }
}

