/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity;

import java.util.EnumSet;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import quek.undergarden.entity.projectile.RottenBlisterberryEntity;

public class BlisterbomberEntity
extends FlyingEntity
implements IMob {
    public BlisterbomberEntity(EntityType<? extends BlisterbomberEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new MoveHelperController(this);
        this.field_70728_aV = 5;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new RandomFlyGoal(this));
        this.field_70714_bg.func_75776_a(0, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 128.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 1000, false, false, entity -> Math.abs(entity.func_226278_cu_() - this.func_226278_cu_()) <= 4.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new ThrowBlisterberryGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookAroundGoal(this));
    }

    public void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(25.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(128.0);
    }

    public static boolean canBlisterbomberSpawn(EntityType<? extends BlisterbomberEntity> type, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return worldIn.func_175659_aa() != Difficulty.PEACEFUL && BlisterbomberEntity.func_223315_a(type, (IWorld)worldIn, (SpawnReason)reason, (BlockPos)pos, (Random)randomIn);
    }

    protected boolean func_225511_J_() {
        return true;
    }

    static class MoveHelperController
    extends MovementController {
        private final BlisterbomberEntity parentEntity;
        private int courseChangeCooldown;

        public MoveHelperController(BlisterbomberEntity blisterbomber) {
            super((MobEntity)blisterbomber);
            this.parentEntity = blisterbomber;
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO && this.courseChangeCooldown-- <= 0) {
                this.courseChangeCooldown += this.parentEntity.func_70681_au().nextInt(5) + 2;
                Vec3d vec3d = new Vec3d(this.field_75646_b - this.parentEntity.func_226277_ct_(), this.field_75647_c - this.parentEntity.func_226278_cu_(), this.field_75644_d - this.parentEntity.func_226281_cx_());
                double d0 = vec3d.func_72433_c();
                if (this.func_220673_a(vec3d = vec3d.func_72432_b(), MathHelper.func_76143_f((double)d0))) {
                    this.parentEntity.func_213317_d(this.parentEntity.func_213322_ci().func_178787_e(vec3d.func_186678_a(0.1)));
                } else {
                    this.field_188491_h = MovementController.Action.WAIT;
                }
            }
        }

        private boolean func_220673_a(Vec3d p_220673_1_, int p_220673_2_) {
            AxisAlignedBB axisalignedbb = this.parentEntity.func_174813_aQ();
            for (int i = 1; i < p_220673_2_; ++i) {
                if (this.parentEntity.field_70170_p.func_226665_a__((Entity)this.parentEntity, axisalignedbb = axisalignedbb.func_191194_a(p_220673_1_))) continue;
                return false;
            }
            return true;
        }
    }

    static class ThrowBlisterberryGoal
    extends Goal {
        private final BlisterbomberEntity parentEntity;
        public int attackTimer;

        public ThrowBlisterberryGoal(BlisterbomberEntity blisterbomber) {
            this.parentEntity = blisterbomber;
        }

        public boolean func_75250_a() {
            return this.parentEntity.func_70638_az() != null;
        }

        public void func_75249_e() {
            this.attackTimer = 0;
        }

        public void func_75246_d() {
            LivingEntity livingentity = this.parentEntity.func_70638_az();
            if (livingentity.func_70068_e((Entity)this.parentEntity) < 4096.0 && this.parentEntity.func_70685_l((Entity)livingentity)) {
                World world = this.parentEntity.field_70170_p;
                ++this.attackTimer;
                if (this.attackTimer == 5) {
                    world.func_184148_a(null, this.parentEntity.func_226277_ct_(), this.parentEntity.func_226278_cu_(), this.parentEntity.func_226281_cx_(), SoundEvents.field_187797_fA, SoundCategory.NEUTRAL, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                    RottenBlisterberryEntity berry = new RottenBlisterberryEntity(world, (LivingEntity)this.parentEntity);
                    berry.func_184538_a((Entity)this.parentEntity, this.parentEntity.field_70125_A, this.parentEntity.field_70177_z, 0.0f, 1.5f, 1.0f);
                    world.func_217376_c((Entity)berry);
                    this.attackTimer = -40;
                }
            } else if (this.attackTimer > 0) {
                --this.attackTimer;
            }
        }
    }

    static class LookAroundGoal
    extends Goal {
        private final BlisterbomberEntity parentEntity;

        public LookAroundGoal(BlisterbomberEntity blisterbomber) {
            this.parentEntity = blisterbomber;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            if (this.parentEntity.func_70638_az() == null) {
                Vec3d vec3d = this.parentEntity.func_213322_ci();
                this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c)) * 57.295776f;
            } else {
                PlayerEntity playerEntity = (PlayerEntity)this.parentEntity.func_70638_az();
                if (playerEntity.func_70068_e((Entity)this.parentEntity) < 4096.0) {
                    double d1 = playerEntity.func_226277_ct_() - this.parentEntity.func_226277_ct_();
                    double d2 = playerEntity.func_226281_cx_() - this.parentEntity.func_226281_cx_();
                    this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)d1, (double)d2)) * 57.295776f;
                }
            }
        }
    }

    static class RandomFlyGoal
    extends Goal {
        private final BlisterbomberEntity parentEntity;

        public RandomFlyGoal(BlisterbomberEntity blisterbomber) {
            this.parentEntity = blisterbomber;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            double d2;
            double d1;
            MovementController movementcontroller = this.parentEntity.func_70605_aq();
            if (!movementcontroller.func_75640_a()) {
                return true;
            }
            double d0 = movementcontroller.func_179917_d() - this.parentEntity.func_226277_ct_();
            double d3 = d0 * d0 + (d1 = movementcontroller.func_179919_e() - this.parentEntity.func_226278_cu_()) * d1 + (d2 = movementcontroller.func_179918_f() - this.parentEntity.func_226281_cx_()) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            Random random = this.parentEntity.func_70681_au();
            double d0 = this.parentEntity.func_226277_ct_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.parentEntity.func_226278_cu_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d2 = this.parentEntity.func_226281_cx_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.parentEntity.func_70605_aq().func_75642_a(d0, d1, d2, 1.0);
        }
    }
}

