/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity;

import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import quek.undergarden.registry.UndergardenBlocks;
import quek.undergarden.registry.UndergardenSoundEvents;

public class BruteEntity
extends MonsterEntity {
    private static final UUID ATTACK_SPEED_BOOST_MODIFIER_UUID = UUID.fromString("49455A49-7EC5-45BA-B886-3B90B23A1718");
    private static final AttributeModifier ATTACK_SPEED_BOOST_MODIFIER = new AttributeModifier(ATTACK_SPEED_BOOST_MODIFIER_UUID, "Attacking speed boost", 0.1, AttributeModifier.Operation.ADDITION).func_111168_a(false);
    private int angerLevel;
    private int randomSoundDelay;
    private UUID angerTargetUUID;

    public BruteEntity(EntityType<? extends BruteEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected boolean func_225511_J_() {
        return false;
    }

    public void func_70604_c(@Nullable LivingEntity livingBase) {
        super.func_70604_c(livingBase);
        if (livingBase != null) {
            this.angerTargetUUID = livingBase.func_110124_au();
        }
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByAggressorGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new TargetAggressorGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, BruteEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.23);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
    }

    public static boolean canBruteSpawn(EntityType<? extends MonsterEntity> animal, IWorld worldIn, SpawnReason reason, BlockPos pos, Random random) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == UndergardenBlocks.deepturf_block.get();
    }

    protected void func_70619_bc() {
        IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
        LivingEntity livingentity = this.func_70643_av();
        if (this.field_70170_p.func_175659_aa() != Difficulty.PEACEFUL) {
            if (this.isAngry()) {
                LivingEntity livingentity1;
                if (!this.func_70631_g_() && !iattributeinstance.func_180374_a(ATTACK_SPEED_BOOST_MODIFIER)) {
                    iattributeinstance.func_111121_a(ATTACK_SPEED_BOOST_MODIFIER);
                }
                --this.angerLevel;
                LivingEntity livingEntity = livingentity1 = livingentity != null ? livingentity : this.func_70638_az();
                if (!this.isAngry() && livingentity1 != null) {
                    if (!this.func_70685_l((Entity)livingentity1)) {
                        this.func_70604_c(null);
                        this.func_70624_b(null);
                    } else {
                        this.angerLevel = this.func_223336_ef();
                    }
                }
            } else if (iattributeinstance.func_180374_a(ATTACK_SPEED_BOOST_MODIFIER)) {
                iattributeinstance.func_111124_b(ATTACK_SPEED_BOOST_MODIFIER);
            }
            if (this.randomSoundDelay > 0 && --this.randomSoundDelay == 0) {
                this.func_184185_a(UndergardenSoundEvents.BRUTE_ANGRY, this.func_70599_aP() * 2.0f, 1.0f);
            }
            if (this.isAngry() && this.angerTargetUUID != null && livingentity == null) {
                PlayerEntity playerentity = this.field_70170_p.func_217371_b(this.angerTargetUUID);
                this.func_70604_c((LivingEntity)playerentity);
                this.field_70717_bb = playerentity;
                this.field_70718_bc = this.func_142015_aE();
            }
            super.func_70619_bc();
        }
        super.func_70619_bc();
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74777_a("Anger", (short)this.angerLevel);
        if (this.angerTargetUUID != null) {
            compound.func_74778_a("HurtBy", this.angerTargetUUID.toString());
        } else {
            compound.func_74778_a("HurtBy", "");
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.angerLevel = compound.func_74765_d("Anger");
        String s = compound.func_74779_i("HurtBy");
        if (!s.isEmpty()) {
            this.angerTargetUUID = UUID.fromString(s);
            PlayerEntity playerentity = this.field_70170_p.func_217371_b(this.angerTargetUUID);
            this.func_70604_c((LivingEntity)playerentity);
            if (playerentity != null) {
                this.field_70717_bb = playerentity;
                this.field_70718_bc = this.func_142015_aE();
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (entity instanceof PlayerEntity && !((PlayerEntity)entity).func_184812_l_() && this.func_70685_l(entity) && this.field_70170_p.func_175659_aa() != Difficulty.PEACEFUL) {
            this.func_226547_i_((LivingEntity)entity);
        }
        return super.func_70097_a(source, amount);
    }

    private boolean func_226547_i_(LivingEntity p_226547_1_) {
        this.angerLevel = this.func_223336_ef();
        this.randomSoundDelay = this.field_70146_Z.nextInt(40);
        this.func_70604_c(p_226547_1_);
        return true;
    }

    private int func_223336_ef() {
        return 400 + this.field_70146_Z.nextInt(400);
    }

    private boolean isAngry() {
        return this.angerLevel > 0;
    }

    protected SoundEvent func_184639_G() {
        return UndergardenSoundEvents.BRUTE_LIVING;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return UndergardenSoundEvents.BRUTE_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return UndergardenSoundEvents.BRUTE_DEATH;
    }

    static class TargetAggressorGoal
    extends NearestAttackableTargetGoal<PlayerEntity> {
        public TargetAggressorGoal(BruteEntity brute) {
            super((MobEntity)brute, PlayerEntity.class, true);
        }

        public boolean func_75250_a() {
            return ((BruteEntity)this.field_75299_d).isAngry() && super.func_75250_a();
        }
    }

    static class HurtByAggressorGoal
    extends HurtByTargetGoal {
        public HurtByAggressorGoal(BruteEntity brute) {
            super((CreatureEntity)brute, new Class[0]);
            this.func_220794_a(new Class[]{BruteEntity.class});
        }

        protected void func_220793_a(MobEntity mobIn, LivingEntity targetIn) {
            if (targetIn.field_70170_p.func_175659_aa() != Difficulty.PEACEFUL && mobIn instanceof BruteEntity && this.field_75299_d.func_70685_l((Entity)targetIn) && ((BruteEntity)mobIn).func_226547_i_(targetIn)) {
                mobIn.func_70624_b(targetIn);
            }
        }
    }
}

