/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity;

import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import quek.undergarden.registry.UndergardenEntities;
import quek.undergarden.registry.UndergardenSoundEvents;

public class RotDwellerEntity
extends MonsterEntity {
    private static final DataParameter<Boolean> IS_CHILD = EntityDataManager.func_187226_a(RotDwellerEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final UUID BABY_SPEED_BOOST_ID = UUID.fromString("B9766B59-9566-4402-BC1F-2EE2A276D836");
    private static final AttributeModifier BABY_SPEED_BOOST = new AttributeModifier(BABY_SPEED_BOOST_ID, "Baby speed boost", 0.5, AttributeModifier.Operation.MULTIPLY_BASE);

    public RotDwellerEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    public void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(15.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
    }

    public CreatureAttribute func_70668_bt() {
        return UndergardenEntities.ROTSPAWN;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(IS_CHILD, (Object)false);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74767_n("IsBaby")) {
            this.setChild(true);
        }
    }

    public boolean func_70631_g_() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_CHILD);
    }

    public void setChild(boolean childZombie) {
        this.func_184212_Q().func_187227_b(IS_CHILD, (Object)childZombie);
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
            iattributeinstance.func_111124_b(BABY_SPEED_BOOST);
            if (childZombie) {
                iattributeinstance.func_111121_a(BABY_SPEED_BOOST);
            }
        }
    }

    public void func_184206_a(DataParameter<?> key) {
        if (IS_CHILD.equals(key)) {
            this.func_213323_x_();
        }
        super.func_184206_a(key);
    }

    protected SoundEvent func_184639_G() {
        return UndergardenSoundEvents.DWELLER_LIVING;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return UndergardenSoundEvents.DWELLER_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return UndergardenSoundEvents.DWELLER_DEATH;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187566_ao, 0.15f, 0.5f);
    }

    public static class GroupData
    implements ILivingEntityData {
        public final boolean isChild;

        public GroupData(boolean isChildIn) {
            this.isChild = isChildIn;
        }
    }
}

