/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import quek.undergarden.entity.DwellerEntity;
import quek.undergarden.entity.RotDwellerEntity;
import quek.undergarden.registry.UndergardenEntities;
import quek.undergarden.registry.UndergardenSoundEvents;

public class RotbeastEntity
extends MonsterEntity {
    private int attackTimer;

    public RotbeastEntity(EntityType<? extends MonsterEntity> type, World world) {
        super(type, world);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 16.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, DwellerEntity.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(80.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.22);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    public CreatureAttribute func_70668_bt() {
        return UndergardenEntities.ROTSPAWN;
    }

    public static boolean canRotbeastSpawn(EntityType<? extends MonsterEntity> type, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return worldIn.func_175659_aa() != Difficulty.PEACEFUL && randomIn.nextInt(20) == 0 && RotbeastEntity.func_223315_a(type, (IWorld)worldIn, (SpawnReason)reason, (BlockPos)pos, (Random)randomIn);
    }

    public int func_70641_bl() {
        return 1;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        this.attackTimer = 10;
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        float f = this.func_226511_et_();
        float f1 = f > 0.0f ? f / 2.0f + (float)this.field_70146_Z.nextInt((int)f) : 0.0f;
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), f1);
        if (flag) {
            entityIn.func_213317_d(entityIn.func_213322_ci().func_72441_c(0.0, (double)0.4f, 0.0));
            this.func_174815_a((LivingEntity)this, entityIn);
        }
        this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 0.5f);
        return flag;
    }

    private float func_226511_et_() {
        return (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
    }

    public void func_70074_a(LivingEntity entityLivingIn) {
        super.func_70074_a(entityLivingIn);
        if ((this.field_70170_p.func_175659_aa() == Difficulty.NORMAL || this.field_70170_p.func_175659_aa() == Difficulty.HARD) && entityLivingIn instanceof DwellerEntity) {
            if (this.field_70170_p.func_175659_aa() != Difficulty.HARD && this.field_70146_Z.nextBoolean()) {
                return;
            }
            DwellerEntity dweller = (DwellerEntity)entityLivingIn;
            RotDwellerEntity rotDweller = (RotDwellerEntity)((EntityType)UndergardenEntities.ROTDWELLER.get()).func_200721_a(this.field_70170_p);
            rotDweller.func_82149_j((Entity)dweller);
            dweller.func_70106_y();
            rotDweller.func_213386_a((IWorld)this.field_70170_p, this.field_70170_p.func_175649_E(new BlockPos((Entity)rotDweller)), SpawnReason.CONVERSION, new RotDwellerEntity.GroupData(false), null);
            if (dweller.func_145818_k_()) {
                rotDweller.func_200203_b(dweller.func_200201_e());
                rotDweller.func_174805_g(dweller.func_174833_aM());
            }
            if (this.func_104002_bU()) {
                rotDweller.func_110163_bv();
            }
            rotDweller.func_184224_h(this.func_190530_aW());
            this.field_70170_p.func_217376_c((Entity)rotDweller);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    protected SoundEvent func_184639_G() {
        return UndergardenSoundEvents.ROTBEAST_LIVING;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return UndergardenSoundEvents.ROTBEAST_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return UndergardenSoundEvents.ROTBEAST_DEATH;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187939_hm, 0.15f, 0.5f);
    }
}

