/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.item.armor;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import quek.undergarden.registry.UndergardenArmorMaterials;
import quek.undergarden.registry.UndergardenItemGroups;
import quek.undergarden.registry.UndergardenItems;

public class UndergardenArmorItem
extends ArmorItem {
    private static final UUID[] ARMOR_MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};

    public UndergardenArmorItem(IArmorMaterial materialIn, EquipmentSlotType slot) {
        super(materialIn, slot, new Item.Properties().func_200916_a(UndergardenItemGroups.UNDERGARDEN_GEAR));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77973_b() == UndergardenItems.cloggrum_boots.get()) {
            tooltip.add(new TranslationTextComponent("tooltip.cloggrum_boots", new Object[0]).func_211708_a(TextFormatting.GRAY));
        }
    }

    public Multimap<String, AttributeModifier> func_111205_h(EquipmentSlotType equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (this.func_200880_d() == UndergardenArmorMaterials.FROSTSTEEL && equipmentSlot == this.field_77881_a) {
            multimap.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(ARMOR_MODIFIERS[equipmentSlot.func_188454_b()], "froststeel_slowness", -0.05, AttributeModifier.Operation.MULTIPLY_BASE));
        }
        if (this.func_200880_d() == UndergardenArmorMaterials.UTHERIC && equipmentSlot == this.field_77881_a) {
            multimap.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)new AttributeModifier(ARMOR_MODIFIERS[equipmentSlot.func_188454_b()], "utheric_resistance", 0.01, AttributeModifier.Operation.MULTIPLY_BASE));
        }
        return multimap;
    }

    public String getArmorTexture(ItemStack itemstack, Entity entity, EquipmentSlotType slot, String layer) {
        if (slot == EquipmentSlotType.LEGS) {
            return "undergarden:textures/models/armor/" + this.field_200882_e.func_200897_d() + "_layer_2.png";
        }
        return "undergarden:textures/models/armor/" + this.field_200882_e.func_200897_d() + "_layer_1.png";
    }
}

