/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.item.tool;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.HoeItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import quek.undergarden.registry.UndergardenBlocks;
import quek.undergarden.registry.UndergardenItemGroups;

public class UndergardenHoeItem
extends HoeItem {
    protected static final Map<Block, BlockState> HOE_LOOKUP = Maps.newHashMap((Map)ImmutableMap.of((Object)UndergardenBlocks.deepturf_block.get(), (Object)((Block)UndergardenBlocks.deepsoil_farmland.get()).func_176223_P(), (Object)UndergardenBlocks.deepsoil.get(), (Object)((Block)UndergardenBlocks.deepsoil_farmland.get()).func_176223_P()));

    public UndergardenHoeItem(IItemTier tier, float attackSpeedIn) {
        super(tier, attackSpeedIn, new Item.Properties().func_200917_a(1).func_200915_b(tier.func_200926_a()).func_200916_a(UndergardenItemGroups.UNDERGARDEN_GEAR));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockState blockstate;
        World world = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        int hook = ForgeEventFactory.onHoeUse((ItemUseContext)context);
        if (hook != 0) {
            return hook > 0 ? ActionResultType.SUCCESS : ActionResultType.FAIL;
        }
        if (context.func_196000_l() != Direction.DOWN && world.func_175623_d(blockpos.func_177984_a()) && (blockstate = HOE_LOOKUP.get(world.func_180495_p(blockpos).func_177230_c())) != null) {
            PlayerEntity playerentity = context.func_195999_j();
            world.func_184133_a(playerentity, blockpos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!world.field_72995_K) {
                world.func_180501_a(blockpos, blockstate, 11);
                if (playerentity != null) {
                    context.func_195996_i().func_222118_a(1, (LivingEntity)playerentity, p_220043_1_ -> p_220043_1_.func_213334_d(context.func_221531_n()));
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }
}

