/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.registry;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.LogBlock;
import net.minecraft.block.StemGrownBlock;
import net.minecraft.block.pattern.BlockMatcher;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.DoublePlantBlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.carver.ICarverConfig;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.BlockWithContextConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.LiquidsConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.feature.SphereReplaceConfig;
import net.minecraft.world.gen.feature.TreeFeatureConfig;
import net.minecraft.world.gen.foliageplacer.BlobFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.foliageplacer.PineFoliagePlacer;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.HeightWithChanceConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.IPlantable;
import quek.undergarden.registry.UndergardenBlocks;
import quek.undergarden.registry.UndergardenFeatures;
import quek.undergarden.registry.UndergardenFluids;
import quek.undergarden.registry.UndergardenWorldCarvers;

public class UndergardenBiomeFeatures {
    public static final OreFeatureConfig.FillerBlockType DEPTHROCK = OreFeatureConfig.FillerBlockType.create((String)"DEPTHROCK", (String)"depthrock", (Predicate)new BlockMatcher((Block)UndergardenBlocks.depthrock.get()));
    public static final OreFeatureConfig.FillerBlockType TREMBLECRUST = OreFeatureConfig.FillerBlockType.create((String)"TREMBLECRUST", (String)"tremblecrust", (Predicate)new BlockMatcher((Block)UndergardenBlocks.tremblecrust.get()));
    public static final OreFeatureConfig.FillerBlockType L_TREMBLECRUST = OreFeatureConfig.FillerBlockType.create((String)"L_TREMBLECRUST", (String)"loose_tremblecrust", (Predicate)new BlockMatcher((Block)UndergardenBlocks.loose_tremblecrust.get()));
    private static final BlockState DEPTHROCK_BLOCK = ((Block)UndergardenBlocks.depthrock.get()).func_176223_P();
    private static final BlockState DEEPSOIL = ((Block)UndergardenBlocks.deepsoil.get()).func_176223_P();
    private static final BlockState DEEPTURF = ((Block)UndergardenBlocks.deepturf_block.get()).func_176223_P();
    private static final BlockState SHIVERSTONE = ((Block)UndergardenBlocks.shiverstone.get()).func_176223_P();
    private static final BlockState SMOGSTEM_LOG = ((LogBlock)UndergardenBlocks.smogstem_log.get()).func_176223_P();
    private static final BlockState SMOGSTEM_LEAVES = ((Block)UndergardenBlocks.smogstem_leaves.get()).func_176223_P();
    private static final BlockState WIGGLEWOOD_LOG = ((LogBlock)UndergardenBlocks.wigglewood_log.get()).func_176223_P();
    private static final BlockState WIGGLEWOOD_LEAVES = ((Block)UndergardenBlocks.wigglewood_leaves.get()).func_176223_P();
    private static final BlockState TALL_DEEPTURF = ((Block)UndergardenBlocks.tall_deepturf.get()).func_176223_P();
    private static final BlockState TALL_ASHEN_DEEPTURF = ((Block)UndergardenBlocks.ashen_tall_deepturf.get()).func_176223_P();
    private static final BlockState DOUBLE_DEEPTURF = ((Block)UndergardenBlocks.double_deepturf.get()).func_176223_P();
    private static final BlockState SHIMMERWEED = ((Block)UndergardenBlocks.shimmerweed.get()).func_176223_P();
    private static final BlockState DOUBLE_SHIMMERWEED = ((Block)UndergardenBlocks.double_shimmerweed.get()).func_176223_P();
    private static final BlockState DITCHBULB_PLANT = ((Block)UndergardenBlocks.ditchbulb_plant.get()).func_176223_P();
    private static final BlockState DEPTHROCK_PEBBLES = ((Block)UndergardenBlocks.depthrock_pebbles.get()).func_176223_P();
    private static final BlockState BEAN_BUSH = ((Block)UndergardenBlocks.underbean_bush.get()).func_176223_P();
    private static final BlockState BLISTERBERRY_BUSH = ((Block)UndergardenBlocks.blisterberry_bush.get()).func_176223_P();
    private static final BlockState INDIGO_SHROOM = ((Block)UndergardenBlocks.indigo_mushroom.get()).func_176223_P();
    private static final BlockState VEIL_SHROOM = ((Block)UndergardenBlocks.veil_mushroom.get()).func_176223_P();
    private static final BlockState INK_SHROOM = ((Block)UndergardenBlocks.ink_mushroom.get()).func_176223_P();
    private static final BlockState BLOOD_SHROOM = ((Block)UndergardenBlocks.blood_mushroom.get()).func_176223_P();
    private static final BlockState GLOOMGOURD = ((StemGrownBlock)UndergardenBlocks.gloomgourd.get()).func_176223_P();
    private static final BlockState UG_COAL_ORE = ((Block)UndergardenBlocks.coal_ore.get()).func_176223_P();
    private static final BlockState CLOGGRUM_ORE = ((Block)UndergardenBlocks.cloggrum_ore.get()).func_176223_P();
    private static final BlockState FROSTSTEEL_ORE = ((Block)UndergardenBlocks.froststeel_ore.get()).func_176223_P();
    private static final BlockState UTHERIUM_ORE = ((Block)UndergardenBlocks.utherium_ore.get()).func_176223_P();
    private static final BlockState OTHERSIDE_UTHERIUM_ORE = ((Block)UndergardenBlocks.otherside_utherium_ore.get()).func_176223_P();
    private static final BlockState REGALIUM_ORE = ((Block)UndergardenBlocks.regalium_ore.get()).func_176223_P();
    private static final BlockState GLOWING_SEAGRASS = ((Block)UndergardenBlocks.glowing_sea_grass.get()).func_176223_P();
    private static final BlockState WATER = Blocks.field_150355_j.func_176223_P();
    private static final BlockState VIRULENT = ((FlowingFluidBlock)UndergardenBlocks.virulent_mix.get()).func_176223_P();
    public static final TreeFeatureConfig SMOGSTEM_TREE_CONFIG = new TreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(SMOGSTEM_LOG), (BlockStateProvider)new SimpleBlockStateProvider(SMOGSTEM_LEAVES), (FoliagePlacer)new BlobFoliagePlacer(2, 0)).func_225569_d_(9).func_227354_b_(3).func_227360_i_(2).func_227352_a_().setSapling((IPlantable)UndergardenBlocks.smogstem_sapling.get()).func_225568_b_();
    public static final TreeFeatureConfig WIGGLEWOOD_TREE_CONFIG = new TreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(WIGGLEWOOD_LOG), (BlockStateProvider)new SimpleBlockStateProvider(WIGGLEWOOD_LEAVES), (FoliagePlacer)new PineFoliagePlacer(2, 0)).func_225569_d_(3).func_227354_b_(0).func_227355_c_(0).func_227356_e_(1).func_227352_a_().setSapling((IPlantable)UndergardenBlocks.wigglewood_sapling.get()).func_225568_b_();
    public static final BlockClusterFeatureConfig INDIGO_MUSHROOM_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(INDIGO_SHROOM), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227317_b_().func_227322_d_();
    public static final BlockClusterFeatureConfig VEIL_MUSHROOM_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(VEIL_SHROOM), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227317_b_().func_227322_d_();
    public static final BlockClusterFeatureConfig INK_MUSHROOM_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(INK_SHROOM), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227317_b_().func_227322_d_();
    public static final BlockClusterFeatureConfig BLOOD_MUSHROOM_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(BLOOD_SHROOM), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227317_b_().func_227322_d_();
    public static final BlockClusterFeatureConfig TALL_DEEPTURF_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(TALL_DEEPTURF), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(512).func_227316_a_((Set)ImmutableSet.of((Object)UndergardenBlocks.deepturf_block.get())).func_227317_b_().func_227322_d_();
    public static final BlockClusterFeatureConfig TALL_ASHEN_DEEPTURF_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(TALL_ASHEN_DEEPTURF), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(512).func_227316_a_((Set)ImmutableSet.of((Object)UndergardenBlocks.ashen_deepturf.get())).func_227317_b_().func_227322_d_();
    public static final BlockClusterFeatureConfig DOUBLE_DEEPTURF_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(DOUBLE_DEEPTURF), (BlockPlacer)new DoublePlantBlockPlacer()).func_227315_a_(256).func_227316_a_((Set)ImmutableSet.of((Object)UndergardenBlocks.deepturf_block.get())).func_227317_b_().func_227322_d_();
    public static final BlockClusterFeatureConfig SHIMMERWEED_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(SHIMMERWEED), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(256).func_227316_a_((Set)ImmutableSet.of((Object)UndergardenBlocks.deepturf_block.get())).func_227317_b_().func_227322_d_();
    public static final BlockClusterFeatureConfig DOUBLE_SHIMMERWEED_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(DOUBLE_SHIMMERWEED), (BlockPlacer)new DoublePlantBlockPlacer()).func_227315_a_(128).func_227316_a_((Set)ImmutableSet.of((Object)UndergardenBlocks.deepturf_block.get())).func_227317_b_().func_227322_d_();
    public static final BlockClusterFeatureConfig DITCHBULB_PLANT_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(DITCHBULB_PLANT), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227316_a_((Set)ImmutableSet.of((Object)UndergardenBlocks.depthrock.get())).func_227317_b_().func_227322_d_();
    public static final BlockClusterFeatureConfig PEBBLE_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(DEPTHROCK_PEBBLES), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(256).func_227316_a_((Set)ImmutableSet.of((Object)UndergardenBlocks.deepturf_block.get(), (Object)UndergardenBlocks.deepsoil.get(), (Object)UndergardenBlocks.ashen_deepturf.get(), (Object)UndergardenBlocks.depthrock.get())).func_227317_b_().func_227322_d_();
    public static final BlockClusterFeatureConfig BEAN_BUSH_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(BEAN_BUSH), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(128).func_227316_a_((Set)ImmutableSet.of((Object)UndergardenBlocks.deepturf_block.get())).func_227317_b_().func_227322_d_();
    public static final BlockClusterFeatureConfig BLISTERBERRY_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(BLISTERBERRY_BUSH), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(128).func_227316_a_((Set)ImmutableSet.of((Object)UndergardenBlocks.ashen_deepturf.get())).func_227317_b_().func_227322_d_();
    public static final BlockClusterFeatureConfig GLOOMGOURD_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(GLOOMGOURD), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(128).func_227316_a_((Set)ImmutableSet.of((Object)UndergardenBlocks.deepturf_block.get())).func_227317_b_().func_227322_d_();
    public static final LiquidsConfig UNDERGARDEN_SPRING_CONFIG = new LiquidsConfig(Fluids.field_204546_a.func_207188_f(), false, 4, 1, (Set)ImmutableSet.of((Object)UndergardenBlocks.depthrock.get(), (Object)UndergardenBlocks.deepsoil.get(), (Object)UndergardenBlocks.tremblecrust.get()));
    public static final LiquidsConfig VIRULENT_SPRING_CONFIG = new LiquidsConfig(((FlowingFluid)UndergardenFluids.virulent_mix_source.get()).func_207188_f(), false, 4, 1, (Set)ImmutableSet.of((Object)UndergardenBlocks.depthrock.get(), (Object)UndergardenBlocks.tremblecrust.get()));

    public static void addNormalStuff(Biome biome) {
        biome.func_203609_a(GenerationStage.Carving.AIR, Biome.func_203606_a((WorldCarver)((WorldCarver)UndergardenWorldCarvers.UNDERGARDEN_CAVE.get()), (ICarverConfig)new ProbabilityConfig(0.5f)));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202295_ao.func_225566_b_((IFeatureConfig)UNDERGARDEN_SPRING_CONFIG).func_227228_a_(Placement.field_215030_p.func_227446_a_((IPlacementConfig)new CountRangeConfig(20, 8, 16, 255))));
        UndergardenBiomeFeatures.addOres(biome);
        UndergardenBiomeFeatures.addBlockVariants(biome);
        UndergardenBiomeFeatures.addSediment(biome);
        UndergardenBiomeFeatures.addPlants(biome);
        UndergardenBiomeFeatures.addUnderwaterPlants(biome);
        UndergardenBiomeFeatures.addShrooms(biome);
    }

    public static void addPlants(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)TALL_DEEPTURF_CONFIG).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(80))));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)SHIMMERWEED_CONFIG).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(40))));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)BEAN_BUSH_CONFIG).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(10))));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)GLOOMGOURD_CONFIG).func_227228_a_(Placement.field_215024_j.func_227446_a_((IPlacementConfig)new ChanceConfig(32))));
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DITCHBULB_PLANT_CONFIG).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(10))));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)PEBBLE_CONFIG).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(10))));
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)PEBBLE_CONFIG).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(80))));
    }

    public static void addSmogVents(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((Feature)UndergardenFeatures.SMOG_VENT.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(20))));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)TALL_ASHEN_DEEPTURF_CONFIG).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(80))));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)PEBBLE_CONFIG).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(10))));
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)PEBBLE_CONFIG).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(80))));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)BLISTERBERRY_CONFIG).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(20))));
    }

    public static void addUnderwaterPlants(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((Feature)UndergardenFeatures.GLOWING_KELP.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(1000))));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_206922_aF.func_225566_b_((IFeatureConfig)new BlockWithContextConfig(GLOWING_SEAGRASS, new BlockState[]{((Block)UndergardenBlocks.depthrock.get()).func_176223_P(), ((Block)UndergardenBlocks.deepsoil.get()).func_176223_P()}, new BlockState[]{Blocks.field_150355_j.func_176223_P()}, new BlockState[]{Blocks.field_150355_j.func_176223_P()})).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(1000))));
    }

    public static void addDoubleDeepturf(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DOUBLE_DEEPTURF_CONFIG).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(20))));
    }

    public static void addDoubleShimmerweed(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DOUBLE_SHIMMERWEED_CONFIG).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(20))));
    }

    public static void addShrooms(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)INDIGO_MUSHROOM_CONFIG).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(4))));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)VEIL_MUSHROOM_CONFIG).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(3))));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)INK_MUSHROOM_CONFIG).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(2))));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)BLOOD_MUSHROOM_CONFIG).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
    }

    public static void addTrees(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((Feature)UndergardenFeatures.SMOGSTEM_TREE.get()).func_225566_b_((IFeatureConfig)SMOGSTEM_TREE_CONFIG).func_227228_a_(Placement.field_215034_t.func_227446_a_((IPlacementConfig)new HeightWithChanceConfig(5, 100.0f))));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((Feature)UndergardenFeatures.WIGGLEWOOD_TREE.get()).func_225566_b_((IFeatureConfig)WIGGLEWOOD_TREE_CONFIG).func_227228_a_(Placement.field_215034_t.func_227446_a_((IPlacementConfig)new HeightWithChanceConfig(10, 50.0f))));
    }

    public static void addForestSmogstemTrees(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((Feature)UndergardenFeatures.SMOGSTEM_TREE.get()).func_225566_b_((IFeatureConfig)SMOGSTEM_TREE_CONFIG).func_227228_a_(Placement.field_215034_t.func_227446_a_((IPlacementConfig)new HeightWithChanceConfig(1000, 1000.0f))));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((Feature)UndergardenFeatures.FANCY_SMOGSTEM_TREE.get()).func_225566_b_((IFeatureConfig)SMOGSTEM_TREE_CONFIG).func_227228_a_(Placement.field_215034_t.func_227446_a_((IPlacementConfig)new HeightWithChanceConfig(1000, 1000.0f))));
    }

    public static void addForestWigglewoodTrees(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((Feature)UndergardenFeatures.WIGGLEWOOD_TREE.get()).func_225566_b_((IFeatureConfig)WIGGLEWOOD_TREE_CONFIG).func_227228_a_(Placement.field_215034_t.func_227446_a_((IPlacementConfig)new HeightWithChanceConfig(1000, 1000.0f))));
    }

    public static void addDenseForestTrees(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((Feature)UndergardenFeatures.SMOGSTEM_TREE.get()).func_225566_b_((IFeatureConfig)SMOGSTEM_TREE_CONFIG).func_227228_a_(Placement.field_215034_t.func_227446_a_((IPlacementConfig)new HeightWithChanceConfig(3000, 3000.0f))));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((Feature)UndergardenFeatures.FANCY_SMOGSTEM_TREE.get()).func_225566_b_((IFeatureConfig)SMOGSTEM_TREE_CONFIG).func_227228_a_(Placement.field_215034_t.func_227446_a_((IPlacementConfig)new HeightWithChanceConfig(5, 500.0f))));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((Feature)UndergardenFeatures.WIGGLEWOOD_TREE.get()).func_225566_b_((IFeatureConfig)WIGGLEWOOD_TREE_CONFIG).func_227228_a_(Placement.field_215034_t.func_227446_a_((IPlacementConfig)new HeightWithChanceConfig(3000, 3000.0f))));
    }

    public static void addOres(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(DEPTHROCK, UG_COAL_ORE, 17)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(20, 0, 0, 256))));
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(DEPTHROCK, CLOGGRUM_ORE, 5)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(15, 0, 0, 128))));
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(DEPTHROCK, FROSTSTEEL_ORE, 4)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(3, 0, 0, 64))));
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(DEPTHROCK, UTHERIUM_ORE, 8)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(1, 0, 0, 32))));
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(DEPTHROCK, REGALIUM_ORE, 4)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(2, 0, 0, 11))));
    }

    public static void addOthersideOres(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(TREMBLECRUST, OTHERSIDE_UTHERIUM_ORE, 16)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(4, 0, 0, 256))));
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(L_TREMBLECRUST, ((Block)UndergardenBlocks.tremblecrust.get()).func_176223_P(), 32)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(8, 0, 0, 256))));
    }

    public static void addBlockVariants(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(DEPTHROCK, DEEPSOIL, 33)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(10, 0, 0, 256))));
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(DEPTHROCK, SHIVERSTONE, 33)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(10, 0, 0, 256))));
    }

    public static void addSediment(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202285_ae.func_225566_b_((IFeatureConfig)new SphereReplaceConfig(DEEPSOIL, 7, 2, (List)Lists.newArrayList((Object[])new BlockState[]{DEPTHROCK_BLOCK, DEEPTURF}))).func_227228_a_(Placement.field_215016_b.func_227446_a_((IPlacementConfig)new FrequencyConfig(3))));
    }
}

