/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.world;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.biome.provider.SingleBiomeProvider;
import net.minecraft.world.biome.provider.SingleBiomeProviderSettings;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import quek.undergarden.UndergardenConfig;
import quek.undergarden.client.render.OthersideSkyRender;
import quek.undergarden.registry.UndergardenBiomes;
import quek.undergarden.registry.UndergardenDimensions;
import quek.undergarden.world.gen.OthersideChunkGenerator;
import quek.undergarden.world.gen.OthersideGenerationSettings;

@Mod.EventBusSubscriber
public class OthersideDimension
extends Dimension {
    public OthersideDimension(World world, DimensionType dimensionType) {
        super(world, dimensionType, 0.0f);
    }

    public static boolean isTheOtherside(@Nullable World world) {
        if (world == null) {
            return false;
        }
        return world.field_73011_w.func_186058_p().getModType() == UndergardenDimensions.OTHERSIDE.get();
    }

    public ChunkGenerator<?> func_186060_c() {
        OthersideGenerationSettings othersideGen = new OthersideGenerationSettings();
        SingleBiomeProviderSettings providerSettings = new SingleBiomeProviderSettings(this.field_76579_a.func_72912_H()).func_205436_a((Biome)UndergardenBiomes.OTHERSIDE.get());
        SingleBiomeProvider provider = new SingleBiomeProvider(providerSettings);
        return new OthersideChunkGenerator((IWorld)this.field_76579_a, (BiomeProvider)provider, othersideGen);
    }

    @SubscribeEvent
    public static void teleportEntityEvent(EntityEvent event) {
        Entity entity;
        if (!((Boolean)UndergardenConfig.disableOthersideTeleport.get()).booleanValue() && (entity = event.getEntity()) != null && entity.field_71093_bK == UndergardenDimensions.otherside_dimension && entity.func_226278_cu_() < 0.0) {
            entity.func_70107_b(entity.func_226277_ct_(), 256.0, entity.func_226281_cx_());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public IRenderHandler getSkyRenderer() {
        Object skyRenderer = super.getSkyRenderer();
        if (skyRenderer == null) {
            skyRenderer = new OthersideSkyRender();
            this.setSkyRenderer((IRenderHandler)skyRenderer);
        }
        return skyRenderer;
    }

    @Nullable
    public BlockPos func_206920_a(ChunkPos chunkPosIn, boolean checkValid) {
        return null;
    }

    @Nullable
    public BlockPos func_206921_a(int posX, int posZ, boolean checkValid) {
        return null;
    }

    public float func_76563_a(long worldTime, float partialTicks) {
        return 0.0f;
    }

    public boolean func_76569_d() {
        return true;
    }

    public Vec3d func_76562_b(float celestialAngle, float partialTicks) {
        return new Vec3d(0.66, 0.53, 0.53);
    }

    public boolean func_76567_e() {
        return false;
    }

    public boolean func_76568_b(int x, int z) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_76571_f() {
        return 150.0f;
    }
}

