/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.world.gen;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.NoiseChunkGenerator;
import net.minecraft.world.gen.OctavesNoiseGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import quek.undergarden.UndergardenConfig;
import quek.undergarden.world.gen.UndergardenGenerationSettings;

public class UndergardenChunkGenerator
extends NoiseChunkGenerator<UndergardenGenerationSettings> {
    private final double[] field_222573_h = this.func_222572_j();
    private static final float[] field_222576_h = (float[])Util.func_200696_a((Object)new float[25], p_222575_0_ -> {
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                float f;
                p_222575_0_[i + 2 + (j + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(i * i + j * j) + 0.2f));
            }
        }
    });
    private final OctavesNoiseGenerator depthNoise = new OctavesNoiseGenerator(this.field_222558_e, 15, 0);

    public UndergardenChunkGenerator(IWorld world, BiomeProvider provider, UndergardenGenerationSettings generationSettings) {
        super(world, provider, 8, 8, 256, (GenerationSettings)generationSettings, false);
    }

    protected void func_222548_a(double[] noiseColumn, int noiseX, int noiseZ) {
        this.func_222546_a(noiseColumn, noiseX, noiseZ, 684.412f, 684.412f, 8.555149841308594, 4.277574920654297, 3, -10);
    }

    protected double[] func_222549_a(int noiseX, int noiseZ) {
        double[] adouble = new double[2];
        float f = 0.0f;
        float f1 = 0.0f;
        float f2 = 0.0f;
        int j = this.func_222530_f();
        float f3 = this.field_222542_c.func_225526_b_(noiseX, j, noiseZ).func_185355_j();
        for (int k = -2; k <= 2; ++k) {
            for (int l = -2; l <= 2; ++l) {
                Biome biome = this.field_222542_c.func_225526_b_(noiseX + k, j, noiseZ + l);
                float depth = biome.func_185355_j();
                float scale = biome.func_185360_m();
                float f6 = field_222576_h[k + 2 + (l + 2) * 5] / (depth + 2.0f);
                if (biome.func_185355_j() > f3) {
                    f6 /= 2.0f;
                }
                f += scale * f6;
                f1 += depth * f6;
                f2 += f6;
            }
        }
        f /= f2;
        f1 /= f2;
        f = f * 0.9f + 0.1f;
        f1 = (f1 * 4.0f - 1.0f) / 8.0f;
        adouble[0] = (double)f1 + this.getNoiseDepthAt(noiseX, noiseZ);
        adouble[1] = f;
        return adouble;
    }

    private double getNoiseDepthAt(int noiseX, int noiseZ) {
        double d0 = this.depthNoise.func_215462_a((double)(noiseX * 200), 10.0, (double)(noiseZ * 200), 1.0, 0.0, true) * 65535.0 / 8000.0;
        if (d0 < 0.0) {
            d0 = -d0 * 0.3;
        }
        if ((d0 = d0 * 3.0 - 2.0) < 0.0) {
            d0 /= 28.0;
        } else {
            if (d0 > 1.0) {
                d0 = 1.0;
            }
            d0 /= 40.0;
        }
        return d0;
    }

    protected double func_222545_a(double p_222545_1_, double p_222545_3_, int p_222545_5_) {
        return this.field_222573_h[p_222545_5_];
    }

    private double[] func_222572_j() {
        double[] adouble = new double[this.func_222550_i()];
        for (int i = 0; i < this.func_222550_i(); ++i) {
            adouble[i] = Math.cos((double)i * Math.PI * 6.0 / (double)this.func_222550_i()) * 2.0;
            double d0 = i;
            if (i > this.func_222550_i() / 2) {
                d0 = this.func_222550_i() - 1 - i;
            }
            if (!(d0 < 4.0)) continue;
            d0 = 4.0 - d0;
            int n = i;
            adouble[n] = adouble[n] - d0 * d0 * d0 * 10.0;
        }
        return adouble;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EntityClassification creatureType, BlockPos pos) {
        return super.func_177458_a(creatureType, pos);
    }

    public int func_205470_d() {
        return 33;
    }

    public int func_207511_e() {
        return 256;
    }

    public int func_222530_f() {
        return 32;
    }

    public void func_225551_a_(WorldGenRegion p_225551_1_, IChunk p_225551_2_) {
        ChunkPos chunkpos = p_225551_2_.func_76632_l();
        int i = chunkpos.field_77276_a;
        int j = chunkpos.field_77275_b;
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
        sharedseedrandom.func_202422_a(i, j);
        ChunkPos chunkpos1 = p_225551_2_.func_76632_l();
        int k = chunkpos1.func_180334_c();
        int l = chunkpos1.func_180333_d();
        double d0 = 0.0625;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int i1 = 0; i1 < 16; ++i1) {
            for (int j1 = 0; j1 < 16; ++j1) {
                int k1 = k + i1;
                int l1 = l + j1;
                int i2 = p_225551_2_.func_201576_a(Heightmap.Type.WORLD_SURFACE_WG, i1, j1) + 1;
                double d1 = this.field_222571_r.func_215460_a((double)k1 * 0.0625, (double)l1 * 0.0625, 0.0625, (double)i1 * 0.0625) * 15.0;
                p_225551_1_.func_226691_t_((BlockPos)blockpos$mutable.func_181079_c(k + i1, i2, l + j1)).func_206854_a((Random)sharedseedrandom, p_225551_2_, k1, l1, i2, d1, ((UndergardenGenerationSettings)this.func_201496_a_()).func_205532_l(), ((UndergardenGenerationSettings)this.func_201496_a_()).func_205533_m(), this.func_222530_f(), this.field_222540_a.func_72905_C());
            }
        }
        this.func_222555_a(p_225551_2_, (Random)sharedseedrandom);
    }

    protected void func_222555_a(IChunk chunkIn, Random rand) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        int i = chunkIn.func_76632_l().func_180334_c();
        int j = chunkIn.func_76632_l().func_180333_d();
        UndergardenGenerationSettings t = (UndergardenGenerationSettings)this.func_201496_a_();
        int k = t.func_214968_u();
        int l = t.func_214967_t();
        for (BlockPos blockpos : BlockPos.func_191531_b((int)i, (int)0, (int)j, (int)(i + 15), (int)0, (int)(j + 15))) {
            if (l > 0) {
                for (int i1 = l; i1 >= l - 4; --i1) {
                    if (i1 < l - rand.nextInt(5)) continue;
                    if (((Boolean)UndergardenConfig.genObsidianRoof.get()).booleanValue()) {
                        chunkIn.func_177436_a((BlockPos)blockpos$mutable.func_181079_c(blockpos.func_177958_n(), i1, blockpos.func_177952_p()), Blocks.field_150343_Z.func_176223_P(), false);
                        continue;
                    }
                    if (((Boolean)UndergardenConfig.genObsidianRoof.get()).booleanValue()) continue;
                    chunkIn.func_177436_a((BlockPos)blockpos$mutable.func_181079_c(blockpos.func_177958_n(), i1, blockpos.func_177952_p()), Blocks.field_150357_h.func_176223_P(), false);
                }
            }
            if (k >= 256) continue;
            for (int j1 = k + 4; j1 >= k; --j1) {
                if (j1 > k + rand.nextInt(5)) continue;
                if (((Boolean)UndergardenConfig.genObsidianFloor.get()).booleanValue()) {
                    chunkIn.func_177436_a((BlockPos)blockpos$mutable.func_181079_c(blockpos.func_177958_n(), j1, blockpos.func_177952_p()), Blocks.field_150343_Z.func_176223_P(), false);
                    continue;
                }
                if (((Boolean)UndergardenConfig.genObsidianFloor.get()).booleanValue()) continue;
                chunkIn.func_177436_a((BlockPos)blockpos$mutable.func_181079_c(blockpos.func_177958_n(), j1, blockpos.func_177952_p()), Blocks.field_150357_h.func_176223_P(), false);
            }
        }
    }
}

