/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.world.gen.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.IntegrityProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ServerWorld;
import quek.undergarden.registry.UndergardenBlocks;

public class EnigmaticStatueFeature
extends Feature<NoFeatureConfig> {
    private static final ResourceLocation statue1 = new ResourceLocation("undergarden", "enigmatic_statue/enigmatic_statue_1");
    private static final ResourceLocation statue2 = new ResourceLocation("undergarden", "enigmatic_statue/enigmatic_statue_2");
    private static final ResourceLocation statue3 = new ResourceLocation("undergarden", "enigmatic_statue/enigmatic_statue_3");
    private static final ResourceLocation[] statues = new ResourceLocation[]{statue1, statue2, statue3};

    public EnigmaticStatueFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        if (worldIn.func_175623_d(pos.func_177984_a()) && worldIn.func_180495_p(pos).func_177230_c() == UndergardenBlocks.deepturf_block.get()) {
            Random random = worldIn.func_201674_k();
            Rotation[] arotation = Rotation.values();
            Rotation rotation = arotation[random.nextInt(arotation.length)];
            int statue = random.nextInt(statues.length);
            TemplateManager templatemanager = ((ServerWorld)worldIn.func_201672_e()).func_217485_w().func_186340_h();
            Template template = templatemanager.func_200220_a(statues[statue]);
            ChunkPos chunkpos = new ChunkPos(pos);
            MutableBoundingBox mutableboundingbox = new MutableBoundingBox(chunkpos.func_180334_c(), 0, chunkpos.func_180333_d(), chunkpos.func_180332_e(), 256, chunkpos.func_180330_f());
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(rotation).func_186223_a(mutableboundingbox).func_189950_a(random).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215206_c);
            BlockPos size = template.func_186257_a(rotation);
            int x = random.nextInt(16);
            int z = random.nextInt(16);
            int deepturfY = 0;
            for (int y = 256; y > 0; --y) {
                if (worldIn.func_180495_p(pos).func_177230_c() != UndergardenBlocks.deepturf_block.get()) {
                    pos.func_177979_c(1);
                    continue;
                }
                deepturfY = y - 1;
            }
            BlockPos blockpos1 = template.func_189961_a(pos.func_177982_a(x, deepturfY, z), Mirror.NONE, rotation);
            IntegrityProcessor integrityprocessor = new IntegrityProcessor(0.9f);
            placementsettings.func_215219_b().func_215222_a((StructureProcessor)integrityprocessor);
            template.func_189962_a(worldIn, blockpos1, placementsettings, 4);
            placementsettings.func_215220_b((StructureProcessor)integrityprocessor);
            return true;
        }
        return false;
    }
}

