/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.world.layer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.LongFunction;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.IExtendedNoiseRandom;
import net.minecraft.world.gen.LazyAreaLayerContext;
import net.minecraft.world.gen.area.IArea;
import net.minecraft.world.gen.area.IAreaFactory;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.layer.Layer;
import net.minecraft.world.gen.layer.LayerUtil;
import net.minecraft.world.gen.layer.ZoomLayer;
import net.minecraft.world.gen.layer.traits.IAreaTransformer1;
import quek.undergarden.registry.UndergardenBiomes;
import quek.undergarden.utils.VoroniZoomLayer;
import quek.undergarden.world.layer.UndergardenBiomeLayer;
import quek.undergarden.world.layer.UndergardenBiomeProviderSettings;

public class UndergardenBiomeProvider
extends BiomeProvider {
    private final Layer genBiomes;
    private final Layer biomeFactoryLayer;
    private static final Set<Biome> biomes = ImmutableSet.of((Object)UndergardenBiomes.FORGOTTEN_FIELD.get(), (Object)UndergardenBiomes.SMOGSTEM_FOREST.get(), (Object)UndergardenBiomes.WIGGLEWOOD_FOREST.get(), (Object)UndergardenBiomes.DENSE_FOREST.get(), (Object)UndergardenBiomes.SMOG_SPIRES.get(), (Object)UndergardenBiomes.BARREN_ABYSS.get(), (Object[])new Biome[0]);

    public UndergardenBiomeProvider(UndergardenBiomeProviderSettings settings) {
        super(biomes);
        Layer[] agenlayer = UndergardenBiomeProvider.buildOverworldProcedure(settings.getSeed(), settings.getWorldInfo().func_76067_t());
        this.genBiomes = agenlayer[0];
        this.biomeFactoryLayer = agenlayer[1];
    }

    public Biome func_225526_b_(int i, int i1, int i2) {
        return this.getBiomeForNoiseGen(i, i1, i2);
    }

    public static <T extends IArea, C extends IExtendedNoiseRandom<T>> IAreaFactory<T> repeat(long seed, IAreaTransformer1 parent, IAreaFactory<T> p_202829_3_, int count, LongFunction<C> contextFactory) {
        IAreaFactory iareafactory = p_202829_3_;
        for (int i = 0; i < count; ++i) {
            iareafactory = parent.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(seed + (long)i), iareafactory);
        }
        return iareafactory;
    }

    public static Layer[] buildOverworldProcedure(long seed, WorldType typeIn) {
        ImmutableList immutablelist = UndergardenBiomeProvider.buildOverworldProcedure(typeIn, (long p_215737_2_) -> new LazyAreaLayerContext(25, seed, p_215737_2_));
        Layer genlayer = new Layer((IAreaFactory)immutablelist.get(0));
        Layer genlayer1 = new Layer((IAreaFactory)immutablelist.get(1));
        Layer genlayer2 = new Layer((IAreaFactory)immutablelist.get(2));
        return new Layer[]{genlayer, genlayer1, genlayer2};
    }

    public static <T extends IArea, C extends IExtendedNoiseRandom<T>> ImmutableList<IAreaFactory<T>> buildOverworldProcedure(WorldType worldTypeIn, LongFunction<C> contextFactory) {
        IAreaFactory biomes = new UndergardenBiomeLayer().func_202823_a((IExtendedNoiseRandom)contextFactory.apply(1L));
        biomes = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1000L), biomes);
        biomes = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1001L), biomes);
        biomes = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1002L), biomes);
        biomes = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1003L), biomes);
        biomes = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1004L), biomes);
        biomes = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1005L), biomes);
        biomes = LayerUtil.func_202829_a((long)1000L, (IAreaTransformer1)ZoomLayer.NORMAL, (IAreaFactory)biomes, (int)1, contextFactory);
        IAreaFactory genlayervoronoizoom = VoroniZoomLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(10L), biomes);
        return ImmutableList.of((Object)biomes, (Object)genlayervoronoizoom, (Object)biomes);
    }

    public Set<Biome> func_225530_a_(int centerX, int centerY, int centerZ, int sideLength) {
        int i = centerX - sideLength >> 2;
        int j = centerY - sideLength >> 2;
        int k = centerZ - sideLength >> 2;
        int l = centerX + sideLength >> 2;
        int i1 = centerY + sideLength >> 2;
        int j1 = centerZ + sideLength >> 2;
        int k1 = l - i + 1;
        int l1 = i1 - j + 1;
        int i2 = j1 - k + 1;
        HashSet set = Sets.newHashSet();
        for (int j2 = 0; j2 < i2; ++j2) {
            for (int k2 = 0; k2 < k1; ++k2) {
                for (int l2 = 0; l2 < l1; ++l2) {
                    int i3 = i + k2;
                    int j3 = j + l2;
                    int k3 = k + j2;
                    set.add(this.getBiomeForNoiseGen(i3, j3, k3));
                }
            }
        }
        return set;
    }

    @Nullable
    public BlockPos locateBiome(int x, int z, int range, List<Biome> biomes, Random random) {
        int i = x - range >> 2;
        int j = z - range >> 2;
        int k = x + range >> 2;
        int l = z + range >> 2;
        int i1 = k - i + 1;
        int j1 = l - j + 1;
        BlockPos blockpos = null;
        int k1 = 0;
        for (int l1 = 0; l1 < i1 * j1; ++l1) {
            int i2 = i + l1 % i1 << 2;
            int j2 = j + l1 / i1 << 2;
            if (!biomes.contains(this.getBiomeForNoiseGen(i2, k1, j2))) continue;
            if (blockpos == null || random.nextInt(k1 + 1) == 0) {
                blockpos = new BlockPos(i2, 0, j2);
            }
            ++k1;
        }
        return blockpos;
    }

    public boolean func_205004_a(Structure<?> structureIn) {
        return this.field_205005_a.computeIfAbsent(structureIn, p_205006_1_ -> {
            for (Biome biome : biomes) {
                if (!biome.func_201858_a(p_205006_1_)) continue;
                return true;
            }
            return false;
        });
    }

    public Set<BlockState> func_205706_b() {
        if (this.field_205707_b.isEmpty()) {
            for (Biome biome : biomes) {
                this.field_205707_b.add(biome.func_203944_q().func_204108_a());
            }
        }
        return this.field_205707_b;
    }

    public Biome getBiomeForNoiseGen(int x, int y, int z) {
        return this.genBiomes.func_215738_a(x, z);
    }
}

