/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.world.layer;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.LongFunction;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.IExtendedNoiseRandom;
import net.minecraft.world.gen.LazyAreaLayerContext;
import net.minecraft.world.gen.area.IArea;
import net.minecraft.world.gen.area.IAreaFactory;
import net.minecraft.world.gen.layer.Layer;
import net.minecraft.world.gen.layer.LayerUtil;
import net.minecraft.world.gen.layer.ZoomLayer;
import net.minecraft.world.gen.layer.traits.IAreaTransformer1;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.event.lifecycle.FMLModIdMappingEvent;
import quek.undergarden.utils.LazyInt;
import quek.undergarden.utils.VoroniZoomLayer;
import quek.undergarden.world.layer.UndergardenBiomeLayer;

public class UndergardenLayerUtil {
    private static final List<LazyInt> CACHES = new ArrayList<LazyInt>();

    public static LazyInt lazyId(RegistryObject<Biome> biome) {
        LazyInt lazyInt = new LazyInt(biome.lazyMap(arg_0 -> ((Registry)Registry.field_212624_m).func_148757_b(arg_0)));
        CACHES.add(lazyInt);
        return lazyInt;
    }

    public static <T extends IArea, C extends IExtendedNoiseRandom<T>> ImmutableList<IAreaFactory<T>> makeLayers(LongFunction<C> contextFactory) {
        IAreaFactory biomes = new UndergardenBiomeLayer().func_202823_a((IExtendedNoiseRandom)contextFactory.apply(1L));
        biomes = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1000L), biomes);
        biomes = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1001L), biomes);
        biomes = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1002L), biomes);
        biomes = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1003L), biomes);
        biomes = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1004L), biomes);
        biomes = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1005L), biomes);
        biomes = LayerUtil.func_202829_a((long)1000L, (IAreaTransformer1)ZoomLayer.NORMAL, (IAreaFactory)biomes, (int)1, contextFactory);
        IAreaFactory genlayervoronoizoom = VoroniZoomLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(10L), biomes);
        return ImmutableList.of((Object)biomes, (Object)genlayervoronoizoom, (Object)biomes);
    }

    public static Layer[] makeLayers(long seed) {
        ImmutableList immutablelist = UndergardenLayerUtil.makeLayers(context -> new LazyAreaLayerContext(25, seed, context));
        Layer layer = new Layer((IAreaFactory)immutablelist.get(0));
        Layer layer1 = new Layer((IAreaFactory)immutablelist.get(1));
        Layer layer2 = new Layer((IAreaFactory)immutablelist.get(2));
        return new Layer[]{layer, layer1, layer2};
    }

    @SubscribeEvent
    public static void onModIdMapped(FMLModIdMappingEvent e) {
        CACHES.forEach(LazyInt::invalidate);
    }
}

