/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.api.client;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.RendererModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class UAEntityModel<E extends LivingEntity>
extends EntityModel<E> {
    private Map<RendererModel, float[]> defaultBoxValues = Maps.newHashMap();

    public void setDefaultBoxValues() {
        for (int i = 0; i < this.field_78092_r.size(); ++i) {
            this.defaultBoxValues.put((RendererModel)this.field_78092_r.get(i), new float[]{((RendererModel)this.field_78092_r.get((int)i)).field_78795_f, ((RendererModel)this.field_78092_r.get((int)i)).field_78796_g, ((RendererModel)this.field_78092_r.get((int)i)).field_78808_h, ((RendererModel)this.field_78092_r.get((int)i)).field_82906_o, ((RendererModel)this.field_78092_r.get((int)i)).field_82908_p, ((RendererModel)this.field_78092_r.get((int)i)).field_82907_q, ((RendererModel)this.field_78092_r.get((int)i)).field_78800_c, ((RendererModel)this.field_78092_r.get((int)i)).field_78797_d, ((RendererModel)this.field_78092_r.get((int)i)).field_78798_e});
        }
    }

    public void resetBoxesToDefaultValues() {
        for (int i = 0; i < this.field_78092_r.size(); ++i) {
            float[] boxValues = this.defaultBoxValues.get(this.field_78092_r.get(i));
            RendererModel curBox = (RendererModel)this.field_78092_r.get(i);
            curBox.field_78795_f = boxValues[0];
            curBox.field_78796_g = boxValues[1];
            curBox.field_78808_h = boxValues[2];
            curBox.field_82906_o = boxValues[3];
            curBox.field_82908_p = boxValues[4];
            curBox.field_82907_q = boxValues[5];
            curBox.field_78800_c = boxValues[6];
            curBox.field_78797_d = boxValues[7];
            curBox.field_78798_e = boxValues[8];
        }
    }

    public void advancedRotateAngle(RendererModel box, boolean[] doAxis, boolean reverse, float scale, float speed, float degree, float offset, float weight, float distance, float distanceSpeed) {
        int neg = reverse ? -1 : 1;
        box.field_78795_f = doAxis[0] ? box.field_78795_f + (float)neg * MathHelper.func_76134_b((float)(distance * (speed * scale) + offset)) * (degree * scale) * distanceSpeed : box.field_78795_f;
        box.field_78796_g = doAxis[1] ? box.field_78796_g + (float)neg * MathHelper.func_76134_b((float)(distance * (speed * scale) + offset)) * (degree * scale) * distanceSpeed : box.field_78796_g;
        box.field_78808_h = doAxis[2] ? box.field_78808_h + (float)neg * MathHelper.func_76134_b((float)(distance * (speed * scale) + offset)) * (degree * scale) * distanceSpeed : box.field_78808_h;
    }

    public void chainAdvancedRotateAngle(RendererModel[] boxes, boolean[] doAxis, boolean reverse, float scale, float chainOffset, float speed, float degree, float distance, float distanceSpeed) {
        int neg = reverse ? -1 : 1;
        int length = boxes.length;
        for (int i = 0; i < length; ++i) {
            boxes[i].field_78795_f = doAxis[0] ? boxes[i].field_78795_f + (float)neg * MathHelper.func_76134_b((float)(distance * (speed * scale) + (float)((double)chainOffset * Math.PI / (double)(length * 2) * (double)i))) * (degree * scale) * distanceSpeed : boxes[i].field_78795_f;
            boxes[i].field_78796_g = doAxis[0] ? boxes[i].field_78796_g + (float)neg * MathHelper.func_76134_b((float)(distance * (speed * scale) + (float)((double)chainOffset * Math.PI / (double)(length * 2) * (double)i))) * (degree * scale) * distanceSpeed : boxes[i].field_78796_g;
            boxes[i].field_78808_h = doAxis[0] ? boxes[i].field_78808_h + (float)neg * MathHelper.func_76134_b((float)(distance * (speed * scale) + (float)((double)chainOffset * Math.PI / (double)(length * 2) * (double)i))) * (degree * scale) * distanceSpeed : boxes[i].field_78808_h;
        }
    }
}

