/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.api.endimator;

import com.google.common.collect.Maps;
import com.teamabnormals.upgrade_aquatic.api.UpgradeAquaticAPI;
import com.teamabnormals.upgrade_aquatic.api.endimator.EndimatedEntity;
import com.teamabnormals.upgrade_aquatic.api.endimator.Endimation;
import com.teamabnormals.upgrade_aquatic.api.endimator.EndimatorRendererModel;
import java.util.Map;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class Endimator {
    private int tempTick = 0;
    private int prevTempTick = 0;
    private boolean correctAnimation = false;
    public EndimatedEntity endimatedEntity;
    private Map<EndimatorRendererModel, float[]> boxValues = Maps.newHashMap();
    private Map<EndimatorRendererModel, float[]> prevBoxValues = Maps.newHashMap();

    public boolean setAnimationToPlay(Endimation animationToPlay) {
        this.prevTempTick = 0;
        this.tempTick = 0;
        this.correctAnimation = this.endimatedEntity.getPlayingAnimation() == animationToPlay;
        this.prevBoxValues.clear();
        this.prevBoxValues.putAll(this.boxValues);
        this.boxValues.clear();
        return this.correctAnimation;
    }

    public void updateAnimations(EndimatedEntity endimatedEntity) {
        this.endimatedEntity = endimatedEntity;
    }

    public void startKeyframe(int tickDuration) {
        if (!this.correctAnimation) {
            return;
        }
        this.prevTempTick = this.tempTick;
        this.tempTick += tickDuration;
    }

    public void endKeyframe() {
        this.endKeyframe(false);
    }

    public void setStaticKeyframe(int tickDuration) {
        this.startKeyframe(tickDuration);
        this.endKeyframe(true);
    }

    public void resetKeyframe(int tickDuration) {
        this.startKeyframe(tickDuration);
        this.endKeyframe();
    }

    public float[] getBoxValues(EndimatorRendererModel model) {
        float[] empty = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        return this.boxValues.computeIfAbsent(model, a -> empty);
    }

    public void move(EndimatorRendererModel model, float x, float y, float z) {
        if (!this.correctAnimation) {
            return;
        }
        this.getBoxValues((EndimatorRendererModel)model)[0] = x;
        this.getBoxValues((EndimatorRendererModel)model)[1] = y;
        this.getBoxValues((EndimatorRendererModel)model)[2] = z;
    }

    public void rotate(EndimatorRendererModel model, float x, float y, float z) {
        if (!this.correctAnimation) {
            return;
        }
        this.getBoxValues((EndimatorRendererModel)model)[3] = x;
        this.getBoxValues((EndimatorRendererModel)model)[4] = y;
        this.getBoxValues((EndimatorRendererModel)model)[5] = z;
    }

    private void endKeyframe(boolean stationary) {
        if (!this.correctAnimation) {
            return;
        }
        int animationTick = this.endimatedEntity.getAnimationTick();
        if (animationTick >= this.prevTempTick && animationTick < this.tempTick) {
            if (stationary) {
                for (EndimatorRendererModel box : this.prevBoxValues.keySet()) {
                    float[] transform = this.prevBoxValues.get((Object)box);
                    box.field_78800_c += transform[0];
                    box.field_78797_d += transform[1];
                    box.field_78798_e += transform[2];
                    box.field_78795_f += transform[3];
                    box.field_78796_g += transform[4];
                    box.field_78808_h += transform[5];
                }
            } else {
                float[] transform;
                float tick = ((float)(animationTick - this.prevTempTick) + UpgradeAquaticAPI.ClientInfo.getPartialTicks()) / (float)(this.tempTick - this.prevTempTick);
                float increment = MathHelper.func_76126_a((float)((float)((double)tick * Math.PI / 2.0)));
                float decrement = 1.0f - increment;
                for (EndimatorRendererModel box : this.prevBoxValues.keySet()) {
                    transform = this.prevBoxValues.get((Object)box);
                    box.field_78800_c += decrement * transform[0];
                    box.field_78797_d += decrement * transform[1];
                    box.field_78798_e += decrement * transform[2];
                    box.field_78795_f += decrement * transform[3];
                    box.field_78796_g += decrement * transform[4];
                    box.field_78808_h += decrement * transform[5];
                }
                for (EndimatorRendererModel box : this.boxValues.keySet()) {
                    transform = this.boxValues.get((Object)box);
                    box.field_78800_c += increment * transform[0];
                    box.field_78797_d += increment * transform[1];
                    box.field_78798_e += increment * transform[2];
                    box.field_78795_f += increment * transform[3];
                    box.field_78796_g += increment * transform[4];
                    box.field_78808_h += increment * transform[5];
                }
            }
        }
        if (!stationary) {
            this.prevBoxValues.clear();
            this.prevBoxValues.putAll(this.boxValues);
            this.boxValues.clear();
        }
    }
}

