/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.api.endimator;

import com.mojang.blaze3d.platform.GlStateManager;
import com.teamabnormals.upgrade_aquatic.api.endimator.EndimatorEntityModel;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.model.RendererModel;
import net.minecraft.client.renderer.model.ModelBox;
import net.minecraft.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EndimatorRendererModel
extends RendererModel {
    public float defaultRotationPointX;
    public float defaultRotationPointY;
    public float defaultRotationPointZ;
    public float defaultRotateAngleX;
    public float defaultRotateAngleY;
    public float defaultRotateAngleZ;
    public float defaultOffsetX;
    public float defaultOffsetY;
    public float defaultOffsetZ;
    public int field_78803_o;
    public int field_78813_p;
    public boolean scaleChildren = true;
    public float[] scales = new float[]{1.0f, 1.0f, 1.0f};
    public float opacity = 1.0f;
    private boolean compiled;
    private int displayList;
    @Nullable
    private EndimatorRendererModel parentRendererModel;

    public EndimatorRendererModel(EndimatorEntityModel<? extends Entity> entityModel) {
        super(entityModel);
    }

    public EndimatorRendererModel(EndimatorEntityModel<? extends Entity> entityModel, String name) {
        super(entityModel, name);
    }

    public EndimatorRendererModel(EndimatorEntityModel<? extends Entity> entityModel, int textureOffsetX, int textureOffsetY) {
        this(entityModel);
        this.setTextureOffset(textureOffsetX, textureOffsetY);
    }

    public RendererModel func_217178_a(String boxName, float offsetX, float offsetY, float offsetZ, int width, int height, int depth, float delta, int textureOffsetX, int textureOffsetY) {
        boxName = this.field_78802_n + "." + boxName;
        this.setTextureOffset(textureOffsetX, textureOffsetY);
        this.field_78804_l.add(new ModelBox((RendererModel)this, this.field_78803_o, this.field_78813_p, offsetX, offsetY, offsetZ, width, height, depth, 0.0f).func_78244_a(boxName));
        return this;
    }

    public RendererModel func_78789_a(float offsetX, float offsetY, float offsetZ, int width, int height, int depth) {
        this.field_78804_l.add(new ModelBox((RendererModel)this, this.field_78803_o, this.field_78813_p, offsetX, offsetY, offsetZ, width, height, depth, 0.0f));
        return this;
    }

    public RendererModel func_178769_a(float offsetX, float offsetY, float offsetZ, int width, int height, int depth, boolean mirrored) {
        this.field_78804_l.add(new ModelBox((RendererModel)this, this.field_78803_o, this.field_78813_p, offsetX, offsetY, offsetZ, width, height, depth, 0.0f, mirrored));
        return this;
    }

    public void func_78790_a(float offsetX, float offsetY, float offsetZ, int width, int height, int depth, float scaleFactor) {
        this.field_78804_l.add(new ModelBox((RendererModel)this, this.field_78803_o, this.field_78813_p, offsetX, offsetY, offsetZ, width, height, depth, scaleFactor));
    }

    public void setDefaultBoxValues() {
        this.defaultRotationPointX = this.field_78800_c;
        this.defaultRotationPointY = this.field_78797_d;
        this.defaultRotationPointZ = this.field_78798_e;
        this.defaultRotateAngleX = this.field_78795_f;
        this.defaultRotateAngleY = this.field_78796_g;
        this.defaultRotateAngleZ = this.field_78808_h;
        this.defaultOffsetX = this.field_82906_o;
        this.defaultOffsetY = this.field_82908_p;
        this.defaultOffsetZ = this.field_82907_q;
    }

    public void revertToDefaultBoxValues() {
        this.field_78800_c = this.defaultRotationPointX;
        this.field_78797_d = this.defaultRotationPointY;
        this.field_78798_e = this.defaultRotationPointZ;
        this.field_78795_f = this.defaultRotateAngleX;
        this.field_78796_g = this.defaultRotateAngleY;
        this.field_78808_h = this.defaultRotateAngleZ;
        this.field_82906_o = this.defaultOffsetX;
        this.field_82908_p = this.defaultOffsetY;
        this.field_82907_q = this.defaultOffsetZ;
    }

    public void setScale(float x, float y, float z) {
        this.scales[0] = x;
        this.scales[1] = y;
        this.scales[2] = z;
    }

    public void setScaleX(float scaleX) {
        this.scales[0] = scaleX;
    }

    public void setScaleY(float scaleY) {
        this.scales[1] = scaleY;
    }

    public void setScaleZ(float scaleZ) {
        this.scales[2] = scaleZ;
    }

    public void setOpacity(float opacity) {
        this.opacity = opacity;
    }

    public void setParentRendererModel(@Nullable EndimatorRendererModel parentRendererModel) {
        this.parentRendererModel = parentRendererModel;
    }

    public void setShouldScaleChildren(boolean scaleChildren) {
        this.scaleChildren = scaleChildren;
    }

    public EndimatorRendererModel setTextureOffset(int x, int y) {
        this.field_78803_o = x;
        this.field_78813_p = y;
        return this;
    }

    public void func_78792_a(RendererModel rendererModel) {
        super.func_78792_a(rendererModel);
        EndimatorRendererModel rendererModelChild = (EndimatorRendererModel)rendererModel;
        rendererModelChild.setParentRendererModel(this);
    }

    public void func_78785_a(float scale) {
        if (!this.field_78807_k && this.field_78806_j) {
            GlStateManager.pushMatrix();
            if (!this.compiled) {
                this.compileDisplayList(scale);
            }
            GlStateManager.translatef((float)this.field_82906_o, (float)this.field_82908_p, (float)this.field_82907_q);
            GlStateManager.translatef((float)(this.field_78800_c * scale), (float)(this.field_78797_d * scale), (float)(this.field_78798_e * scale));
            if (this.field_78808_h != 0.0f) {
                GlStateManager.rotatef((float)((float)Math.toDegrees(this.field_78808_h)), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (this.field_78796_g != 0.0f) {
                GlStateManager.rotatef((float)((float)Math.toDegrees(this.field_78796_g)), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (this.field_78795_f != 0.0f) {
                GlStateManager.rotatef((float)((float)Math.toDegrees(this.field_78795_f)), (float)1.0f, (float)0.0f, (float)0.0f);
            }
            if (this.scales[0] != 1.0f || this.scales[1] != 1.0f || this.scales[2] != 1.0f) {
                GlStateManager.scalef((float)this.scales[0], (float)this.scales[1], (float)this.scales[2]);
            }
            if (this.opacity < 1.0f) {
                GlStateManager.enableBlend();
                GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.opacity);
            }
            GlStateManager.callList((int)this.displayList);
            if (this.opacity < 1.0f) {
                GlStateManager.disableBlend();
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            if (!(this.scaleChildren || this.scales[0] == 1.0f && this.scales[1] == 1.0f && this.scales[2] == 1.0f)) {
                GlStateManager.popMatrix();
                GlStateManager.pushMatrix();
                GlStateManager.translatef((float)this.field_82906_o, (float)this.field_82908_p, (float)this.field_82907_q);
                GlStateManager.translatef((float)(this.field_78800_c * scale), (float)(this.field_78797_d * scale), (float)(this.field_78798_e * scale));
                if (this.field_78808_h != 0.0f) {
                    GlStateManager.rotatef((float)((float)Math.toDegrees(this.field_78808_h)), (float)0.0f, (float)0.0f, (float)1.0f);
                }
                if (this.field_78796_g != 0.0f) {
                    GlStateManager.rotatef((float)((float)Math.toDegrees(this.field_78796_g)), (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (this.field_78795_f != 0.0f) {
                    GlStateManager.rotatef((float)((float)Math.toDegrees(this.field_78795_f)), (float)1.0f, (float)0.0f, (float)0.0f);
                }
            }
            if (this.field_78805_m != null) {
                for (RendererModel childModel : this.field_78805_m) {
                    childModel.func_78785_a(scale);
                }
            }
            GlStateManager.popMatrix();
        }
    }

    private void compileDisplayList(float scale) {
        this.displayList = GLAllocation.func_74526_a((int)1);
        GlStateManager.newList((int)this.displayList, (int)4864);
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        for (int i = 0; i < this.field_78804_l.size(); ++i) {
            ((ModelBox)this.field_78804_l.get(i)).func_178780_a(bufferbuilder, scale);
        }
        GlStateManager.endList();
        this.compiled = true;
    }
}

