/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.client.particle;

import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ParticlePrismarineShower
extends SpriteTexturedParticle {
    protected final IAnimatedSprite animatedSprite;
    private final float rotSpeed;
    private float angle;
    private final float scale;
    private final int MAX_FRAME_ID = 5;
    protected int currentFrame = 0;
    private boolean directionRight = true;
    private int lastTick = 0;

    public ParticlePrismarineShower(IAnimatedSprite animatedSprite, World world, double posX, double posY, double posZ, double motionX, double motionY, double motionZ) {
        super(world, posX, posY, posZ, motionX, motionY, motionZ);
        this.field_187129_i = this.field_187129_i * (double)0.01f + motionX;
        this.field_187130_j = this.field_187130_j * (double)0.01f + motionY;
        this.field_187131_k = this.field_187131_k * (double)0.01f + motionZ;
        this.field_70544_f = 0.5f;
        this.scale = 0.5f;
        this.rotSpeed = ((float)Math.random() - 0.5f) * 0.1f;
        this.field_190014_F = (float)Math.random() * ((float)Math.PI * 2);
        this.angle = (float)Math.random() * ((float)Math.PI * 2);
        this.field_70545_g = 0.035f;
        this.field_70552_h = 1.0f;
        this.field_70553_i = 1.0f;
        this.field_70551_j = 1.0f;
        this.field_70547_e = (int)(15.0 / (Math.random() * 0.8 + 0.2)) + 4;
        this.animatedSprite = animatedSprite;
        this.func_217566_b(animatedSprite);
    }

    public void func_180434_a(BufferBuilder buffer, ActiveRenderInfo activeInfo, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        Entity entity = activeInfo.func_216773_g();
        if (entity.field_70173_aa >= this.lastTick + 5) {
            if (this.currentFrame == 5) {
                this.directionRight = false;
            } else if (this.currentFrame == 0) {
                this.directionRight = true;
            }
            this.currentFrame += this.directionRight ? 1 : -1;
            this.lastTick = entity.field_70173_aa;
        }
        float f = ((float)this.field_70546_d + partialTicks) / (float)this.field_70547_e;
        this.field_70544_f = this.scale * (1.0f - f * f * 0.5f);
        super.func_180434_a(buffer, activeInfo, partialTicks, rotationX, rotationZ, rotationYZ, rotationXY, rotationXZ);
    }

    public void func_189213_a() {
        super.func_189213_a();
        this.field_190015_G = this.field_190014_F;
        this.field_190014_F += (float)Math.PI * this.rotSpeed * 2.0f;
        if (this.field_187132_l) {
            this.field_190014_F = 0.0f;
            this.field_190015_G = 0.0f;
        }
        this.field_187129_i += Math.cos(this.angle) * 0.0025;
        this.field_187130_j *= 1.06;
        this.field_187131_k += Math.sin(this.angle) * 0.0025;
        if (this.func_187113_k()) {
            this.func_217566_b(this.animatedSprite);
        }
    }

    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217602_b;
    }

    public int func_189214_a(float partialTick) {
        float f = ((float)this.field_70546_d + partialTick) / (float)this.field_70547_e;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        int i = super.func_189214_a(partialTick);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(f * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    public static class Factory
    implements IParticleFactory<BasicParticleType> {
        private IAnimatedSprite animatedSprite;

        public Factory(IAnimatedSprite animatedSprite) {
            this.animatedSprite = animatedSprite;
        }

        public Particle makeParticle(BasicParticleType type, World world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new ParticlePrismarineShower(this.animatedSprite, world, x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }
}

