/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.teamabnormals.upgrade_aquatic.client.model.ModelPike;
import com.teamabnormals.upgrade_aquatic.client.render.overlay.RenderLayerGlowingPike;
import com.teamabnormals.upgrade_aquatic.client.render.overlay.RenderLayerPikeCarriedItem;
import com.teamabnormals.upgrade_aquatic.common.entities.EntityPike;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderPike
extends MobRenderer<EntityPike, ModelPike<EntityPike>> {
    public RenderPike(EntityRendererManager manager) {
        super(manager, new ModelPike(), 0.6f);
        this.func_177094_a(new RenderLayerGlowingPike(this));
        this.func_177094_a(new RenderLayerPikeCarriedItem((IEntityRenderer<EntityPike, ModelPike<EntityPike>>)this));
    }

    protected ResourceLocation getEntityTexture(EntityPike entity) {
        return new ResourceLocation("upgrade_aquatic", "textures/entity/pike/pike_" + entity.getPikeType() + ".png");
    }

    protected void applyRotations(EntityPike entityLiving, float ageInTicks, float rotationYaw, float partialTicks) {
        super.func_77043_a((LivingEntity)entityLiving, ageInTicks, rotationYaw, partialTicks);
        float f = 4.3f * MathHelper.func_76126_a((float)(0.6f * ageInTicks));
        GlStateManager.rotatef((float)f, (float)0.0f, (float)1.0f, (float)0.0f);
        if (!entityLiving.func_70090_H()) {
            GlStateManager.translatef((float)0.1f, (float)0.1f, (float)-0.1f);
            GlStateManager.rotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    protected void preRenderCallback(EntityPike pike, float partialTickTime) {
        GlStateManager.scalef((float)1.0f, (float)1.0f, (float)1.0f);
        float scale = pike.getPikeType() < 12 ? (pike.getPikeType() < 3 ? 1.2f : 1.5f) : (pike.getPikeType() == 12 ? 1.5f : (pike.getPikeType() == 13 ? 1.7f : (pike.getPikeType() == 14 ? 2.25f : (pike.getPikeType() == 15 || pike.getPikeType() == 16 ? 1.2f : 1.35f))));
        GlStateManager.scalef((float)scale, (float)scale, (float)scale);
    }
}

