/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.blocks.coralstone;

import com.teamabnormals.upgrade_aquatic.common.blocks.BlockVerticalSlab;
import com.teamabnormals.upgrade_aquatic.core.registry.UABlocks;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CoralWallFanBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;

public class BlockCoralstoneVerticalSlab
extends BlockVerticalSlab {
    @Nullable
    private Block[] growableCoralBlocks;
    public static final BooleanProperty POWERED = BooleanProperty.func_177716_a((String)"powered");

    public BlockCoralstoneVerticalSlab(Block.Properties properties, @Nullable Block[] growableCoralBlocks) {
        super(properties);
        this.growableCoralBlocks = growableCoralBlocks;
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)TYPE, (Comparable)((Object)BlockVerticalSlab.VerticalSlabType.NORTH))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public void func_196267_b(BlockState state, World worldIn, BlockPos pos, Random random) {
        if (!worldIn.isAreaLoaded(pos, 3)) {
            return;
        }
        Block block = state.func_177230_c();
        BlockVerticalSlab.VerticalSlabType type = (BlockVerticalSlab.VerticalSlabType)((Object)state.func_177229_b((IProperty)TYPE));
        if (this.growableCoralBlocks == null && block != UABlocks.DEAD_CORALSTONE_SLAB) {
            for (int i = 0; i < 4; ++i) {
                BlockPos blockpos = pos.func_177982_a(random.nextInt(3) - 1, random.nextInt(5) - 3, random.nextInt(3) - 1);
                if (!UABlocks.CORALSTONE_VERTICAL_SLAB_CONVERSION_MAP.containsKey(worldIn.func_180495_p(blockpos).func_177230_c())) continue;
                BlockState newState = (BlockState)((BlockState)UABlocks.CORALSTONE_VERTICAL_SLAB_CONVERSION_MAP.get(worldIn.func_180495_p(blockpos).func_177230_c()).func_176223_P().func_206870_a((IProperty)TYPE, (Comparable)((Object)type))).func_206870_a((IProperty)WATERLOGGED, state.func_177229_b((IProperty)WATERLOGGED));
                worldIn.func_175656_a(pos, newState);
            }
        }
        if (this.growableCoralBlocks != null && random.nextFloat() < 0.12f && ((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            Direction randDirection = this.growableCoralBlocks.length > 3 ? Direction.func_176741_a((Random)random) : Direction.func_82600_a((int)(random.nextInt(5) + 1));
            BlockPos growPos = type.slabDirection != null ? pos.func_177972_a(type.slabDirection.func_176734_d()) : pos.func_177972_a(randDirection);
            IFluidState fluidState = worldIn.func_180495_p(growPos).func_204520_s();
            boolean validGrowPos = this.isValidPosToGrow(worldIn, growPos, fluidState);
            if (state.func_177229_b((IProperty)TYPE) != BlockVerticalSlab.VerticalSlabType.DOUBLE) {
                if (validGrowPos) {
                    worldIn.func_180501_a(growPos, (BlockState)this.growableCoralBlocks[2].func_176223_P().func_206870_a((IProperty)CoralWallFanBlock.field_211884_b, (Comparable)type.slabDirection.func_176734_d()), 2);
                }
            } else if (validGrowPos) {
                if (randDirection.func_176745_a() > 1) {
                    worldIn.func_180501_a(growPos, (BlockState)this.growableCoralBlocks[2].func_176223_P().func_206870_a((IProperty)CoralWallFanBlock.field_211884_b, (Comparable)randDirection), 2);
                } else if (randDirection.func_176745_a() == 1) {
                    if (random.nextBoolean()) {
                        worldIn.func_180501_a(growPos, this.growableCoralBlocks[1].func_176223_P(), 2);
                    } else {
                        worldIn.func_180501_a(growPos, this.growableCoralBlocks[0].func_176223_P(), 2);
                    }
                } else {
                    worldIn.func_180501_a(growPos, this.growableCoralBlocks[3].func_176223_P(), 2);
                }
            }
        }
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean flag;
        if (!worldIn.field_72995_K && (flag = ((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) != worldIn.func_175640_z(pos)) {
            worldIn.func_180501_a(pos, (BlockState)state.func_177231_a((IProperty)POWERED), 2);
        }
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)super.func_196258_a(context).func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(context.func_195991_k().func_175640_z(context.func_195995_a())));
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == Items.field_151097_aZ && state.func_177230_c() != UABlocks.CORALSTONE_VERTICAL_SLAB) {
            BlockState newState = UABlocks.CORALSTONE_VERTICAL_SLAB.func_176223_P();
            world.func_184133_a(null, pos, SoundEvents.field_187784_dt, SoundCategory.PLAYERS, 1.0f, 0.8f);
            stack.func_222118_a(1, (LivingEntity)player, entity -> entity.func_213334_d(hand));
            world.func_180501_a(pos, (BlockState)((BlockState)newState.func_206870_a((IProperty)TYPE, state.func_177229_b((IProperty)TYPE))).func_206870_a((IProperty)WATERLOGGED, state.func_177229_b((IProperty)WATERLOGGED)), 2);
            return true;
        }
        return false;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{TYPE, WATERLOGGED, POWERED});
    }

    private boolean isValidPosToGrow(World world, BlockPos pos, IFluidState fluidState) {
        return world.func_180495_p(pos).func_185904_a().func_76222_j() && fluidState.func_206882_g() >= 8 && fluidState.func_206884_a(FluidTags.field_206959_a);
    }
}

