/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.entities;

import com.teamabnormals.upgrade_aquatic.core.registry.UAItems;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.controller.BodyController;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.stats.ServerStatisticsManager;
import net.minecraft.stats.Stats;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityFlare
extends FlyingEntity {
    private static final DataParameter<Integer> SIZE = EntityDataManager.func_187226_a(EntityFlare.class, (IDataSerializer)DataSerializers.field_187192_b);
    private Vec3d orbitOffset = Vec3d.field_186680_a;
    private BlockPos orbitPosition = BlockPos.field_177992_a;
    private AttackPhase attackPhase = AttackPhase.CIRCLE;

    public EntityFlare(EntityType<? extends EntityFlare> type, World world) {
        super(type, world);
        this.field_70728_aV = 5;
        this.field_70765_h = new MoveHelperController((MobEntity)this);
        this.field_70749_g = new LookHelperController((MobEntity)this);
    }

    protected BodyController func_184650_s() {
        return new BodyHelperController((MobEntity)this);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new PickAttackGoal());
        this.field_70714_bg.func_75776_a(2, (Goal)new SweepAttackGoal());
        this.field_70714_bg.func_75776_a(3, (Goal)new OrbitPointGoal());
        this.field_70715_bh.func_75776_a(1, (Goal)new AttackLivingEntityGoal());
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a((double)(8 + this.getPhantomSize()));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SIZE, (Object)0);
    }

    public void setPhantomSize(int sizeIn) {
        this.field_70180_af.func_187227_b(SIZE, (Object)MathHelper.func_76125_a((int)sizeIn, (int)0, (int)64));
    }

    private void updatePhantomSize() {
        this.func_213323_x_();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)(12 + this.getPhantomSize()));
    }

    public int getPhantomSize() {
        return (Integer)this.field_70180_af.func_187225_a(SIZE);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.35f;
    }

    public void func_184206_a(DataParameter<?> key) {
        if (SIZE.equals(key)) {
            this.updatePhantomSize();
        }
        super.func_184206_a(key);
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223222_a_;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            float f = MathHelper.func_76134_b((float)((float)(this.func_145782_y() * 3 + this.field_70173_aa) * 0.13f + (float)Math.PI));
            float f1 = MathHelper.func_76134_b((float)((float)(this.func_145782_y() * 3 + this.field_70173_aa + 1) * 0.13f + (float)Math.PI));
            if (f > 0.0f && f1 <= 0.0f) {
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_206944_gn, this.func_184176_by(), 0.95f + this.field_70146_Z.nextFloat() * 0.05f, 0.95f + this.field_70146_Z.nextFloat() * 0.05f, false);
            }
            int i = this.getPhantomSize();
            float f2 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * (1.3f + 0.21f * (float)i);
            float f3 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * (1.3f + 0.21f * (float)i);
            float f4 = (0.3f + f * 0.45f) * ((float)i * 0.2f + 1.0f);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, this.field_70165_t + (double)f2, this.field_70163_u + (double)f4, this.field_70161_v + (double)f3, 0.0, 0.0, 0.0);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, this.field_70165_t - (double)f2, this.field_70163_u + (double)f4, this.field_70161_v - (double)f3, 0.0, 0.0, 0.0);
        }
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL) {
            this.func_70106_y();
        }
    }

    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.orbitPosition = new BlockPos((Entity)this).func_177981_b(5);
        this.setPhantomSize(0);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("AX")) {
            this.orbitPosition = new BlockPos(compound.func_74762_e("AX"), compound.func_74762_e("AY"), compound.func_74762_e("AZ"));
        }
        this.setPhantomSize(compound.func_74762_e("Size"));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("AX", this.orbitPosition.func_177958_n());
        compound.func_74768_a("AY", this.orbitPosition.func_177956_o());
        compound.func_74768_a("AZ", this.orbitPosition.func_177952_p());
        compound.func_74768_a("Size", this.getPhantomSize());
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        return true;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)UAItems.FLARE_SPAWN_EGG.get());
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_203256_ft;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_203259_fw;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_203258_fv;
    }

    protected float func_70599_aP() {
        return 1.0f;
    }

    public boolean func_213358_a(EntityType<?> typeIn) {
        return true;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        int i = this.getPhantomSize();
        EntitySize entitysize = super.func_213305_a(poseIn);
        float f = (entitysize.field_220315_a + 0.2f * (float)i) / entitysize.field_220315_a;
        return entitysize.func_220313_a(f);
    }

    class SweepAttackGoal
    extends MoveGoal {
        private SweepAttackGoal() {
        }

        public boolean func_75250_a() {
            return EntityFlare.this.func_70638_az() != null && EntityFlare.this.attackPhase == AttackPhase.SWOOP;
        }

        public boolean func_75253_b() {
            LivingEntity livingentity = EntityFlare.this.func_70638_az();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.func_70089_S()) {
                return false;
            }
            if (!(livingentity instanceof PlayerEntity) || !((PlayerEntity)livingentity).func_175149_v() && !((PlayerEntity)livingentity).func_184812_l_()) {
                List list;
                if (!this.func_75250_a()) {
                    return false;
                }
                if (EntityFlare.this.field_70173_aa % 20 == 0 && !(list = EntityFlare.this.field_70170_p.func_175647_a(CatEntity.class, EntityFlare.this.func_174813_aQ().func_186662_g(16.0), EntityPredicates.field_94557_a)).isEmpty()) {
                    for (CatEntity catentity : list) {
                        catentity.func_213420_ej();
                    }
                    return false;
                }
                return true;
            }
            return false;
        }

        public void func_75249_e() {
        }

        public void func_75251_c() {
            if (EntityFlare.this.func_70638_az() instanceof PlayerEntity) {
                EntityFlare.this.func_70624_b(null);
            }
            EntityFlare.this.attackPhase = AttackPhase.CIRCLE;
        }

        public void func_75246_d() {
            LivingEntity livingentity = EntityFlare.this.func_70638_az();
            EntityFlare.this.orbitOffset = new Vec3d(livingentity.field_70165_t, livingentity.field_70163_u + (double)livingentity.func_213302_cg() * 0.5, livingentity.field_70161_v);
            if (EntityFlare.this.func_174813_aQ().func_186662_g((double)0.2f).func_72326_a(livingentity.func_174813_aQ())) {
                EntityFlare.this.func_70652_k((Entity)livingentity);
                EntityFlare.this.attackPhase = AttackPhase.CIRCLE;
                EntityFlare.this.field_70170_p.func_217379_c(1039, new BlockPos((Entity)EntityFlare.this), 0);
            } else if (EntityFlare.this.field_70123_F || EntityFlare.this.field_70737_aN > 0) {
                EntityFlare.this.attackPhase = AttackPhase.CIRCLE;
            }
        }
    }

    class PickAttackGoal
    extends Goal {
        private int tickDelay;

        private PickAttackGoal() {
        }

        public boolean func_75250_a() {
            LivingEntity livingentity = EntityFlare.this.func_70638_az();
            return livingentity != null ? EntityFlare.this.func_213344_a(EntityFlare.this.func_70638_az(), EntityPredicate.field_221016_a) : false;
        }

        public void func_75249_e() {
            this.tickDelay = 10;
            EntityFlare.this.attackPhase = AttackPhase.CIRCLE;
            this.func_203143_f();
        }

        public void func_75251_c() {
            EntityFlare.this.orbitPosition = EntityFlare.this.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING, EntityFlare.this.orbitPosition).func_177981_b(10 + EntityFlare.this.field_70146_Z.nextInt(20));
        }

        public void func_75246_d() {
            if (EntityFlare.this.attackPhase == AttackPhase.CIRCLE) {
                --this.tickDelay;
                if (this.tickDelay <= 0) {
                    EntityFlare.this.attackPhase = AttackPhase.SWOOP;
                    this.func_203143_f();
                    this.tickDelay = (8 + EntityFlare.this.field_70146_Z.nextInt(4)) * 20;
                    EntityFlare.this.func_184185_a(SoundEvents.field_203260_fx, 10.0f, 0.95f + EntityFlare.this.field_70146_Z.nextFloat() * 0.1f);
                }
            }
        }

        private void func_203143_f() {
            EntityFlare.this.orbitPosition = new BlockPos((Entity)EntityFlare.this.func_70638_az()).func_177981_b(20 + EntityFlare.this.field_70146_Z.nextInt(20));
            if (EntityFlare.this.orbitPosition.func_177956_o() < EntityFlare.this.field_70170_p.func_181545_F()) {
                EntityFlare.this.orbitPosition = new BlockPos(EntityFlare.this.orbitPosition.func_177958_n(), EntityFlare.this.field_70170_p.func_181545_F() + 1, EntityFlare.this.orbitPosition.func_177952_p());
            }
        }
    }

    class OrbitPointGoal
    extends MoveGoal {
        private float field_203150_c;
        private float field_203151_d;
        private float field_203152_e;
        private float field_203153_f;

        private OrbitPointGoal() {
        }

        public boolean func_75250_a() {
            return EntityFlare.this.func_70638_az() == null || EntityFlare.this.attackPhase == AttackPhase.CIRCLE;
        }

        public void func_75249_e() {
            this.field_203151_d = 5.0f + EntityFlare.this.field_70146_Z.nextFloat() * 10.0f;
            this.field_203152_e = -4.0f + EntityFlare.this.field_70146_Z.nextFloat() * 9.0f;
            this.field_203153_f = EntityFlare.this.field_70146_Z.nextBoolean() ? 1.0f : -1.0f;
            this.func_203148_i();
        }

        public void func_75246_d() {
            if (EntityFlare.this.field_70146_Z.nextInt(350) == 0) {
                this.field_203152_e = -4.0f + EntityFlare.this.field_70146_Z.nextFloat() * 9.0f;
            }
            if (EntityFlare.this.field_70146_Z.nextInt(250) == 0) {
                this.field_203151_d += 1.0f;
                if (this.field_203151_d > 15.0f) {
                    this.field_203151_d = 5.0f;
                    this.field_203153_f = -this.field_203153_f;
                }
            }
            if (EntityFlare.this.field_70146_Z.nextInt(450) == 0) {
                this.field_203150_c = EntityFlare.this.field_70146_Z.nextFloat() * 2.0f * (float)Math.PI;
                this.func_203148_i();
            }
            if (this.func_203146_f()) {
                this.func_203148_i();
            }
            if (((EntityFlare)EntityFlare.this).orbitOffset.field_72448_b < EntityFlare.this.field_70163_u && !EntityFlare.this.field_70170_p.func_175623_d(new BlockPos((Entity)EntityFlare.this).func_177979_c(1))) {
                this.field_203152_e = Math.max(1.0f, this.field_203152_e);
                this.func_203148_i();
            }
            if (((EntityFlare)EntityFlare.this).orbitOffset.field_72448_b > EntityFlare.this.field_70163_u && !EntityFlare.this.field_70170_p.func_175623_d(new BlockPos((Entity)EntityFlare.this).func_177981_b(1))) {
                this.field_203152_e = Math.min(-1.0f, this.field_203152_e);
                this.func_203148_i();
            }
        }

        private void func_203148_i() {
            if (BlockPos.field_177992_a.equals((Object)EntityFlare.this.orbitPosition)) {
                EntityFlare.this.orbitPosition = new BlockPos((Entity)EntityFlare.this);
            }
            this.field_203150_c += this.field_203153_f * 15.0f * ((float)Math.PI / 180);
            EntityFlare.this.orbitOffset = new Vec3d((Vec3i)EntityFlare.this.orbitPosition).func_72441_c((double)(this.field_203151_d * MathHelper.func_76134_b((float)this.field_203150_c)), (double)(-4.0f + this.field_203152_e), (double)(this.field_203151_d * MathHelper.func_76126_a((float)this.field_203150_c)));
        }
    }

    class MoveHelperController
    extends MovementController {
        private float speedFactor;

        public MoveHelperController(MobEntity entityIn) {
            super(entityIn);
            this.speedFactor = 0.1f;
        }

        public void func_75641_c() {
            float f7;
            if (EntityFlare.this.field_70123_F) {
                EntityFlare.this.field_70177_z += 180.0f;
                this.speedFactor = 0.1f;
            }
            float f = (float)(((EntityFlare)EntityFlare.this).orbitOffset.field_72450_a - EntityFlare.this.field_70165_t);
            float f1 = (float)(((EntityFlare)EntityFlare.this).orbitOffset.field_72448_b - EntityFlare.this.field_70163_u);
            float f2 = (float)(((EntityFlare)EntityFlare.this).orbitOffset.field_72449_c - EntityFlare.this.field_70161_v);
            double d0 = MathHelper.func_76129_c((float)(f * f + f2 * f2));
            double d1 = 1.0 - (double)MathHelper.func_76135_e((float)(f1 * 0.7f)) / d0;
            f = (float)((double)f * d1);
            f2 = (float)((double)f2 * d1);
            d0 = MathHelper.func_76129_c((float)(f * f + f2 * f2));
            double d2 = MathHelper.func_76129_c((float)(f * f + f2 * f2 + f1 * f1));
            float f3 = EntityFlare.this.field_70177_z;
            float f4 = (float)MathHelper.func_181159_b((double)f2, (double)f);
            float f5 = MathHelper.func_76142_g((float)(EntityFlare.this.field_70177_z + 90.0f));
            float f6 = MathHelper.func_76142_g((float)(f4 * 57.295776f));
            EntityFlare.this.field_70761_aq = EntityFlare.this.field_70177_z = MathHelper.func_203303_c((float)f5, (float)f6, (float)4.0f) - 90.0f;
            this.speedFactor = MathHelper.func_203301_d((float)f3, (float)EntityFlare.this.field_70177_z) < 3.0f ? MathHelper.func_203300_b((float)this.speedFactor, (float)1.8f, (float)(0.005f * (1.8f / this.speedFactor))) : MathHelper.func_203300_b((float)this.speedFactor, (float)0.2f, (float)0.025f);
            EntityFlare.this.field_70125_A = f7 = (float)(-(MathHelper.func_181159_b((double)(-f1), (double)d0) * 57.2957763671875));
            float f8 = EntityFlare.this.field_70177_z + 90.0f;
            double d3 = (double)(this.speedFactor * MathHelper.func_76134_b((float)(f8 * ((float)Math.PI / 180)))) * Math.abs((double)f / d2);
            double d4 = (double)(this.speedFactor * MathHelper.func_76126_a((float)(f8 * ((float)Math.PI / 180)))) * Math.abs((double)f2 / d2);
            double d5 = (double)(this.speedFactor * MathHelper.func_76126_a((float)(f7 * ((float)Math.PI / 180)))) * Math.abs((double)f1 / d2);
            Vec3d vec3d = EntityFlare.this.func_213322_ci();
            EntityFlare.this.func_213317_d(vec3d.func_178787_e(new Vec3d(d3, d5, d4).func_178788_d(vec3d).func_186678_a(0.2)));
        }
    }

    abstract class MoveGoal
    extends Goal {
        public MoveGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        protected boolean func_203146_f() {
            return EntityFlare.this.orbitOffset.func_186679_c(EntityFlare.this.field_70165_t, EntityFlare.this.field_70163_u, EntityFlare.this.field_70161_v) < 4.0;
        }
    }

    class LookHelperController
    extends LookController {
        public LookHelperController(MobEntity entityIn) {
            super(entityIn);
        }

        public void func_75649_a() {
        }
    }

    class BodyHelperController
    extends BodyController {
        public BodyHelperController(MobEntity p_i49925_2_) {
            super(p_i49925_2_);
        }

        public void func_75664_a() {
            EntityFlare.this.field_70759_as = EntityFlare.this.field_70761_aq;
            EntityFlare.this.field_70761_aq = EntityFlare.this.field_70177_z;
        }
    }

    public class AttackLivingEntityGoal
    extends Goal {
        private final EntityPredicate field_220842_b = new EntityPredicate().func_221013_a(64.0);
        private int tickDelay = 20;

        private AttackLivingEntityGoal() {
        }

        public boolean func_75250_a() {
            if (this.tickDelay > 0) {
                --this.tickDelay;
                return false;
            }
            this.tickDelay = 60;
            List list = EntityFlare.this.field_70170_p.func_217374_a(LivingEntity.class, this.field_220842_b, (LivingEntity)EntityFlare.this, EntityFlare.this.func_174813_aQ().func_72314_b(16.0, 64.0, 16.0));
            if (!list.isEmpty()) {
                for (LivingEntity mob : list) {
                    if (!EntityFlare.this.func_213344_a(mob, EntityPredicate.field_221016_a)) continue;
                    if (mob instanceof ServerPlayerEntity) {
                        ServerStatisticsManager statisticsManager = ((ServerPlayerEntity)mob).func_147099_x();
                        if (statisticsManager.func_77444_a(Stats.field_199092_j.func_199076_b((Object)Stats.field_203284_n)) >= 72000) continue;
                        EntityFlare.this.func_70624_b(mob);
                        return true;
                    }
                    if (mob instanceof EntityFlare) continue;
                    EntityFlare.this.func_70624_b(mob);
                    return true;
                }
            }
            return false;
        }

        public boolean func_75253_b() {
            ServerStatisticsManager statisticsManager;
            LivingEntity livingentity = EntityFlare.this.func_70638_az();
            if (livingentity instanceof ServerPlayerEntity && (statisticsManager = ((ServerPlayerEntity)livingentity).func_147099_x()).func_77444_a(Stats.field_199092_j.func_199076_b((Object)Stats.field_203284_n)) < 72000) {
                return EntityFlare.this.func_213344_a(livingentity, EntityPredicate.field_221016_a);
            }
            return livingentity != null;
        }
    }

    static enum AttackPhase {
        CIRCLE,
        SWOOP;

    }
}

