/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.entities;

import com.teamabnormals.upgrade_aquatic.api.entity.EntityBucketableWaterMob;
import com.teamabnormals.upgrade_aquatic.core.registry.UAEntities;
import com.teamabnormals.upgrade_aquatic.core.registry.UAItems;
import java.util.function.Predicate;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.entity.passive.fish.TropicalFishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;

public class EntityLionfish
extends EntityBucketableWaterMob {
    private static final Predicate<LivingEntity> ENEMY_MATCHER = entity -> {
        if (entity == null) {
            return false;
        }
        return !(entity instanceof EntityLionfish) && !(entity instanceof AbstractFishEntity);
    };
    private static final DataParameter<Boolean> HUNGY = EntityDataManager.func_187226_a(EntityLionfish.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> TIME_TILL_HUNGRY = EntityDataManager.func_187226_a(EntityLionfish.class, (IDataSerializer)DataSerializers.field_187192_b);
    int lastTimeSinceHungry;

    public EntityLionfish(EntityType<? extends EntityLionfish> type, World world) {
        super((EntityType<? extends EntityBucketableWaterMob>)((EntityType)UAEntities.LIONFISH.get()), world);
        this.field_70765_h = new MoveHelperController(this);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(4, (Goal)new RandomSwimmingGoal((CreatureEntity)this, 1.35, 30){

            public boolean func_75250_a() {
                Vec3d vec3d;
                if (this.field_75457_a.func_184207_aI()) {
                    return false;
                }
                if (!this.field_179482_g) {
                    if (this.field_75457_a.func_70654_ax() >= 100) {
                        return false;
                    }
                    if (((EntityLionfish)this.field_75457_a).isHungry() ? this.field_75457_a.func_70681_au().nextInt(60) != 0 : this.field_75457_a.func_70681_au().nextInt(30) != 0) {
                        return false;
                    }
                }
                if ((vec3d = this.func_190864_f()) == null) {
                    return false;
                }
                this.field_75455_b = vec3d.field_72450_a;
                this.field_75456_c = vec3d.field_72448_b;
                this.field_75453_d = vec3d.field_72449_c;
                this.field_179482_g = false;
                return true;
            }
        });
        this.field_70714_bg.func_75776_a(4, (Goal)new LionfishAttackGoal((CreatureEntity)this, 12.0, true));
        this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal<TropicalFishEntity>((MobEntity)this, TropicalFishEntity.class, true){

            public boolean func_75250_a() {
                return ((EntityLionfish)this.field_75299_d).isHungry() && super.func_75250_a();
            }
        });
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HUNGY, (Object)true);
        this.field_70180_af.func_187214_a(TIME_TILL_HUNGRY, (Object)0);
    }

    public boolean isHungry() {
        return (Boolean)this.field_70180_af.func_187225_a(HUNGY);
    }

    public void setHungry(boolean hungry) {
        this.field_70180_af.func_187227_b(HUNGY, (Object)hungry);
    }

    public int getTimeTillHungry() {
        return (Integer)this.field_70180_af.func_187225_a(TIME_TILL_HUNGRY);
    }

    public void setTimeTillHungry(int ticks) {
        this.field_70180_af.func_187227_b(TIME_TILL_HUNGRY, (Object)ticks);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("IsHungry", this.isHungry());
        compound.func_74768_a("TimeTillHungry", this.getTimeTillHungry());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setHungry(compound.func_74767_n("IsHungry"));
        this.setTimeTillHungry(compound.func_74762_e("TimeTillHungry"));
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.85f;
    }

    public int func_70641_bl() {
        return 3;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)UAItems.LIONFISH_SPAWN_EGG.get());
    }

    @Override
    public ItemStack getBucket() {
        return new ItemStack((IItemProvider)UAItems.LIONFISH_BUCKET.get());
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new SwimmerPathNavigator((MobEntity)this, worldIn);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.func_70090_H() && this.field_70122_E && this.field_70124_G) {
            this.func_213317_d(this.func_213322_ci().func_72441_c((double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.035f), (double)0.4f, (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.035f)));
            this.field_70122_E = false;
            this.field_70160_al = true;
            this.func_184185_a(this.getFlopSound(), this.func_70599_aP(), this.func_70647_i());
        }
        if (this.func_70089_S()) {
            for (LivingEntity entity : this.field_70170_p.func_175647_a(LivingEntity.class, this.func_174813_aQ().func_186662_g(0.3), ENEMY_MATCHER)) {
                if (!entity.func_70089_S()) continue;
                this.attack(entity);
            }
        }
        if (!this.isHungry() && this.lastTimeSinceHungry < this.getTimeTillHungry()) {
            ++this.lastTimeSinceHungry;
        }
        if (this.lastTimeSinceHungry >= this.getTimeTillHungry()) {
            this.setHungry(true);
            this.lastTimeSinceHungry = 0;
        }
    }

    private void attack(LivingEntity entity) {
        if (entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 2.0f) && entity.func_70090_H()) {
            entity.func_195064_c(new EffectInstance(Effects.field_76436_u, 70, 1));
            this.func_184185_a(SoundEvents.field_203830_gs, 1.0f, 1.0f);
            if (entity instanceof PlayerEntity) {
                this.func_70624_b(entity);
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        Entity entitySource = source.func_76346_g();
        if (!(!(entitySource instanceof LivingEntity) || entitySource instanceof PlayerEntity && ((PlayerEntity)entitySource).field_71075_bZ.field_75098_d)) {
            if (entitySource instanceof PlayerEntity) {
                this.func_70624_b((LivingEntity)entitySource);
            }
            return super.func_70097_a(source, amount);
        }
        return super.func_70097_a(source, amount);
    }

    public void func_213352_e(Vec3d p_213352_1_) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_213309_a(0.01f, p_213352_1_);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
            if (this.func_70638_az() == null) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.005, 0.0));
            }
        } else {
            super.func_213352_e(p_213352_1_);
        }
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_203824_gm;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_203827_gp;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_203829_gr;
    }

    protected SoundEvent getFlopSound() {
        return SoundEvents.field_203828_gq;
    }

    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_203817_bZ;
    }

    public static void addSpawn() {
        ForgeRegistries.BIOMES.getValues().stream().forEach(EntityLionfish::processSpawning);
    }

    private static void processSpawning(Biome biome) {
        if (biome.func_201856_r() == Biome.Category.OCEAN && biome.func_201851_b() != Biome.RainType.SNOW) {
            biome.func_76747_a(EntityClassification.WATER_CREATURE).add(new Biome.SpawnListEntry((EntityType)UAEntities.LIONFISH.get(), 15, 1, 1));
        }
    }

    static class LionfishAttackGoal
    extends MeleeAttackGoal {
        public LionfishAttackGoal(CreatureEntity creature, double speedIn, boolean useLongMemory) {
            super(creature, speedIn, useLongMemory);
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && this.field_75441_b.func_70090_H();
        }

        protected void func_190102_a(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.func_179512_a(enemy);
            if (distToEnemySqr <= d0 && this.field_75439_d <= 0) {
                this.field_75439_d = 20;
                ((EntityLionfish)this.field_75441_b).attack(enemy);
                ((EntityLionfish)this.field_75441_b).setHungry(false);
                ((EntityLionfish)this.field_75441_b).setTimeTillHungry(this.field_75441_b.func_70681_au().nextInt(300) + 300);
                if (enemy instanceof PlayerEntity) {
                    this.field_75441_b.func_70624_b(null);
                    this.func_75251_c();
                }
            }
        }
    }

    static class MoveHelperController
    extends MovementController {
        private final EntityLionfish lionfish;

        MoveHelperController(EntityLionfish lionfish) {
            super((MobEntity)lionfish);
            this.lionfish = lionfish;
        }

        public void func_75641_c() {
            if (this.lionfish.func_208600_a(FluidTags.field_206959_a)) {
                this.lionfish.func_213317_d(this.lionfish.func_213322_ci().func_72441_c(0.0, 0.005, 0.0));
            }
            if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.lionfish.func_70661_as().func_75500_f()) {
                double d0 = this.field_75646_b - this.lionfish.field_70165_t;
                double d1 = this.field_75647_c - this.lionfish.field_70163_u;
                double d2 = this.field_75644_d - this.lionfish.field_70161_v;
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.lionfish.field_70761_aq = this.lionfish.field_70177_z = this.func_75639_a(this.lionfish.field_70177_z, f, 90.0f);
                float f1 = (float)(this.field_75645_e * this.lionfish.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                this.lionfish.func_70659_e(MathHelper.func_219799_g((float)0.125f, (float)this.lionfish.func_70689_ay(), (float)f1));
                this.lionfish.func_213317_d(this.lionfish.func_213322_ci().func_72441_c(0.0, (double)this.lionfish.func_70689_ay() * (d1 /= d3) * 0.03, 0.0));
            }
        }
    }
}

