/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.entities;

import com.google.common.collect.Lists;
import com.teamabnormals.upgrade_aquatic.api.entity.EntityBucketableWaterMob;
import com.teamabnormals.upgrade_aquatic.api.util.UAEntityPredicates;
import com.teamabnormals.upgrade_aquatic.client.particle.UAParticles;
import com.teamabnormals.upgrade_aquatic.common.blocks.BlockPickerelweed;
import com.teamabnormals.upgrade_aquatic.common.blocks.BlockPickerelweedBlock;
import com.teamabnormals.upgrade_aquatic.common.blocks.BlockPickerelweedDouble;
import com.teamabnormals.upgrade_aquatic.core.registry.UAEntities;
import com.teamabnormals.upgrade_aquatic.core.registry.UAItems;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.vecmath.Vector3f;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.entity.passive.fish.PufferfishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTables;
import net.minecraftforge.registries.ForgeRegistries;

public class EntityPike
extends EntityBucketableWaterMob {
    private static final DataParameter<Integer> PIKE_TYPE = EntityDataManager.func_187226_a(EntityPike.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> CAUGHT_ENTITY = EntityDataManager.func_187226_a(EntityPike.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> DROP_ITEM = EntityDataManager.func_187226_a(EntityPike.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> MOVING = EntityDataManager.func_187226_a(EntityPike.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> LIT = EntityDataManager.func_187226_a(EntityPike.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> ATTACK_COOLDOWN = EntityDataManager.func_187226_a(EntityPike.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final Predicate<ItemEntity> ITEM_SELECTOR = entity -> !entity.func_174874_s() && entity.func_70089_S() && entity.func_70090_H() && entity.func_92059_d().func_77973_b().func_206844_a(ItemTags.field_206964_G);
    private int eatTicks;
    private int dropEatingLootCooldown;

    public EntityPike(EntityType<? extends EntityPike> type, World world) {
        super(type, world);
        this.field_70765_h = new MoveHelperController(this);
        this.func_184598_c(Hand.MAIN_HAND);
        this.func_98053_h(true);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.9);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        if (this.getPikeType() != 7) {
            this.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal<EntityPike>((CreatureEntity)this, EntityPike.class, 8.0f, 1.6, 1.4, UAEntityPredicates.IS_SPECTRAL::test){

                public boolean func_75250_a() {
                    return super.func_75250_a() && this.field_75380_a != null && ((EntityPike)this.field_75380_a).getPikeType() != 7;
                }
            });
        }
        this.field_70714_bg.func_75776_a(3, (Goal)new PlayerTemptGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new RandomSwimmingGoal((CreatureEntity)this, 1.1, 40){

            public boolean func_75250_a() {
                return ((EntityPike)this.field_75457_a).isHidingInPickerelweed() ? super.func_75250_a() && this.field_75457_a.func_70681_au().nextInt(6) == 0 : super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(4, (Goal)new HideInPickerelweedGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new SwimToItemsGoal());
        this.field_70714_bg.func_75776_a(4, (Goal)new PikeAttackGoal((CreatureEntity)this, 12.0, true));
        this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal<AbstractFishEntity>((MobEntity)this, AbstractFishEntity.class, true){

            public boolean func_75250_a() {
                return ((EntityPike)this.field_75299_d).getAttackCooldown() <= 0 && super.func_75250_a();
            }
        });
        this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal<TurtleEntity>((MobEntity)this, TurtleEntity.class, 10, true, false, UAEntityPredicates.IS_CHILD::test){

            public boolean func_75250_a() {
                return ((EntityPike)this.field_75299_d).getAttackCooldown() <= 0 && super.func_75250_a();
            }
        });
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PIKE_TYPE, (Object)0);
        this.field_70180_af.func_187214_a(CAUGHT_ENTITY, (Object)0);
        this.field_70180_af.func_187214_a(DROP_ITEM, (Object)true);
        this.field_70180_af.func_187214_a(MOVING, (Object)false);
        this.field_70180_af.func_187214_a(LIT, (Object)false);
        this.field_70180_af.func_187214_a(ATTACK_COOLDOWN, (Object)0);
    }

    @Override
    public ItemStack getBucket() {
        return new ItemStack((IItemProvider)UAItems.PIKE_BUCKET.get());
    }

    @Override
    protected void setBucketData(ItemStack bucket) {
        if (this.func_145818_k_()) {
            bucket.func_200302_a(this.func_200201_e());
        }
        CompoundNBT compoundnbt = bucket.func_196082_o();
        CompoundNBT compoundnbt1 = new CompoundNBT();
        compoundnbt.func_74768_a("BucketVariantTag", this.getPikeType());
        compoundnbt.func_74768_a("EatingLootDropCooldown", this.dropEatingLootCooldown);
        if (!this.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b()) {
            this.func_184582_a(EquipmentSlotType.MAINHAND).func_77955_b(compoundnbt1);
        }
        compoundnbt.func_218657_a("PikeHeldItem", (INBT)compoundnbt1);
        compoundnbt.func_74757_a("ShouldDropItem", this.shouldDropItem());
        compoundnbt.func_74757_a("IsLit", this.isLit());
    }

    @Nullable
    public LivingEntity getCaughtEntity() {
        if (!this.hasCaughtEntity()) {
            return null;
        }
        Entity entity = this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(CAUGHT_ENTITY)).intValue());
        if (entity == null) {
            return null;
        }
        if (entity != null && entity instanceof AbstractFishEntity || entity != null && entity instanceof AnimalEntity) {
            return (LivingEntity)entity;
        }
        return null;
    }

    public int func_70641_bl() {
        return 3;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.6f;
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new SwimmerPathNavigator((MobEntity)this, worldIn){

            protected boolean func_75485_k() {
                return super.func_75485_k() || this.field_75515_a.func_213339_cH().func_177230_c() instanceof BlockPickerelweedBlock;
            }

            public boolean func_188555_b(BlockPos pos) {
                return super.func_188555_b(pos) || this.field_75515_a.func_213339_cH().func_177230_c() instanceof BlockPickerelweedBlock;
            }
        };
    }

    public void func_70636_d() {
        ++this.eatTicks;
        if (this.dropEatingLootCooldown > 0) {
            --this.dropEatingLootCooldown;
        }
        if (!this.func_70090_H() && this.field_70122_E && this.field_70124_G) {
            this.func_213317_d(this.func_213322_ci().func_72441_c((double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.05f), (double)0.4f, (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.05f)));
            this.field_70122_E = false;
            this.field_70160_al = true;
            this.func_184185_a(this.getFlopSound(), this.func_70599_aP(), this.func_70647_i());
        }
        if (this.field_70170_p.func_82737_E() % 20L == 0L && this.getCaughtEntity() != null) {
            int i;
            if (this.isPickerelweedNearby()) {
                if (this.isHidingInPickerelweed()) {
                    this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundEvents.field_219632_dv, SoundCategory.HOSTILE, 0.8f, 0.9f);
                    if (this.getCaughtEntity().func_110143_aJ() <= 1.0f && this.getPikeType() == 7 && this.field_70170_p.field_72995_K) {
                        for (i = 0; i < 3; ++i) {
                            this.field_70170_p.func_195594_a((IParticleData)UAParticles.SPECTRAL_CONSUME, this.getCaughtEntity().field_70165_t + (this.getCaughtEntity().func_70681_au().nextDouble() - 0.5) * (double)this.getCaughtEntity().func_213311_cf(), this.getCaughtEntity().field_70163_u + this.getCaughtEntity().func_70681_au().nextDouble() * (double)this.getCaughtEntity().func_213302_cg() - 0.25, this.getCaughtEntity().field_70161_v + (this.getCaughtEntity().func_70681_au().nextDouble() - 0.5) * (double)this.getCaughtEntity().func_213311_cf(), (this.getCaughtEntity().func_70681_au().nextDouble() - 0.5) * 2.0, -this.getCaughtEntity().func_70681_au().nextDouble(), (this.getCaughtEntity().func_70681_au().nextDouble() - 0.5) * 2.0);
                        }
                    }
                    this.getCaughtEntity().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 1.0f);
                }
            } else {
                this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundEvents.field_219632_dv, SoundCategory.HOSTILE, 0.8f, 0.9f);
                if (this.getCaughtEntity().func_110143_aJ() <= 1.0f && this.getPikeType() == 7 && this.field_70170_p.field_72995_K) {
                    for (i = 0; i < 3; ++i) {
                        this.field_70170_p.func_195594_a((IParticleData)UAParticles.SPECTRAL_CONSUME, this.getCaughtEntity().field_70165_t + (this.getCaughtEntity().func_70681_au().nextDouble() - 0.5) * (double)this.getCaughtEntity().func_213311_cf(), this.getCaughtEntity().field_70163_u + this.getCaughtEntity().func_70681_au().nextDouble() * (double)this.getCaughtEntity().func_213302_cg() - 0.25, this.getCaughtEntity().field_70161_v + (this.getCaughtEntity().func_70681_au().nextDouble() - 0.5) * (double)this.getCaughtEntity().func_213311_cf(), (this.getCaughtEntity().func_70681_au().nextDouble() - 0.5) * 2.0, -this.getCaughtEntity().func_70681_au().nextDouble(), (this.getCaughtEntity().func_70681_au().nextDouble() - 0.5) * 2.0);
                    }
                }
                this.getCaughtEntity().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 1.0f);
            }
        }
        if (this.getAttackCooldown() > 0) {
            this.setAttackCooldown(this.getAttackCooldown() - 1);
        }
        if (this.getCaughtEntity() != null) {
            this.getCaughtEntity().func_184220_m((Entity)this);
        }
        ItemStack itemstack = this.func_184582_a(EquipmentSlotType.MAINHAND);
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && this.func_70613_aW() && !itemstack.func_190926_b() && this.canEatItem(itemstack) && this.func_70090_H()) {
            if (this.eatTicks > 600) {
                ItemStack itemstackFood = itemstack.func_77950_b(this.field_70170_p, (LivingEntity)this);
                if (!itemstack.func_190926_b()) {
                    this.func_184201_a(EquipmentSlotType.MAINHAND, itemstackFood);
                }
                if (this.dropEatingLootCooldown <= 0) {
                    if (this.func_70681_au().nextFloat() < 0.2f) {
                        for (ItemStack stacks : this.generateFishingLoot((ServerWorld)this.field_70170_p)) {
                            if (stacks.func_190916_E() > 0) {
                                stacks.func_190918_g(stacks.func_190916_E() - 1);
                            }
                            this.spitOutItem(stacks);
                        }
                    } else {
                        this.spitOutItem(new ItemStack((IItemProvider)Items.field_196106_bc));
                    }
                    this.dropEatingLootCooldown = 3600 + this.func_70681_au().nextInt(400);
                }
                this.func_70691_i(6.0f);
                this.eatTicks = 0;
            } else if (this.eatTicks > 560 && this.field_70146_Z.nextFloat() < 0.1f) {
                this.func_184185_a(this.func_213353_d(itemstack), 1.0f, 1.0f);
                this.field_70170_p.func_72960_a((Entity)this, (byte)45);
            }
        }
        if (this.isMoving() && this.func_70090_H() && this.getPikeType() == 12) {
            Vec3d vec3d1 = this.func_70676_i(0.0f);
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf() - vec3d1.field_72450_a * 1.5, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg() - vec3d1.field_72448_b * 1.5, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf() - vec3d1.field_72449_c * 1.5, 0.0, 0.0, 0.0);
            }
        }
        if (this.getPikeType() == 13 && this.isLit() && this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg() - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
            }
        }
        super.func_70636_d();
    }

    public void func_213352_e(Vec3d p_213352_1_) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            float speed = this.getPikeType() == 12 ? 0.05f : 0.01f;
            this.func_213309_a(speed, p_213352_1_);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
            if (this.func_70638_az() == null) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.005, 0.0));
            }
        } else {
            super.func_213352_e(p_213352_1_);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        Entity entitySource = source.func_76346_g();
        if (!(this.hasCaughtEntity() || !(entitySource instanceof LivingEntity) || entitySource instanceof PlayerEntity && ((PlayerEntity)entitySource).field_71075_bZ.field_75098_d)) {
            this.func_70624_b((LivingEntity)source.func_76346_g());
            return super.func_70097_a(source, amount);
        }
        return super.func_70097_a(source, amount);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        int type = this.getRandomTypeForBiome(worldIn);
        if (dataTag != null && dataTag.func_150297_b("BucketVariantTag", 3)) {
            this.setPikeType(dataTag.func_74762_e("BucketVariantTag"));
            this.dropEatingLootCooldown = dataTag.func_74762_e("EatingLootDropCooldown");
            if (dataTag.func_74764_b("PikeHeldItem")) {
                this.func_184598_c(Hand.MAIN_HAND);
                this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.func_199557_a((CompoundNBT)dataTag.func_74775_l("PikeHeldItem")));
            }
            if (dataTag.func_74764_b("ShouldDropItem")) {
                this.setToDropItem(dataTag.func_74767_n("ShouldDropItem"));
            }
            if (dataTag.func_74764_b("IsLit")) {
                this.setLit(dataTag.func_74767_n("IsLit"));
            }
            return spawnDataIn;
        }
        if (spawnDataIn instanceof PikeData) {
            type = ((PikeData)spawnDataIn).typeData;
        } else if (!this.isFromBucket()) {
            spawnDataIn = new PikeData(type);
        }
        this.setPikeType(type);
        if (this.func_70681_au().nextFloat() <= 0.1f && this.func_70613_aW()) {
            for (ItemStack itemstack : this.generateFishingLoot((ServerWorld)this.field_70170_p)) {
                this.func_184201_a(EquipmentSlotType.MAINHAND, itemstack);
            }
            this.setToDropItem(false);
        }
        return spawnDataIn;
    }

    @Override
    protected boolean func_184645_a(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77973_b() == Items.field_151033_d) {
            itemstack.func_222118_a(1, (LivingEntity)player, onBroken -> onBroken.func_213334_d(hand));
            this.func_184185_a(SoundEvents.field_187649_bu, 1.0f, 1.0f);
            this.setLit(true);
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    private void spitOutItem(ItemStack stackIn) {
        if (!stackIn.func_190926_b() && !this.field_70170_p.field_72995_K) {
            ItemEntity itementity = new ItemEntity(this.field_70170_p, this.field_70165_t + this.func_70040_Z().field_72450_a, this.field_70163_u + 1.0, this.field_70161_v + this.func_70040_Z().field_72449_c, stackIn);
            itementity.func_174867_a(40);
            itementity.func_200216_c(this.func_110124_au());
            this.func_184185_a(SoundEvents.field_219629_dC, 1.0f, 1.0f);
            this.field_70170_p.func_217376_c((Entity)itementity);
            this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
        }
    }

    private boolean canEatItem(ItemStack itemstack) {
        return itemstack.func_77973_b().func_206844_a(ItemTags.field_206964_G);
    }

    private boolean isPickerelweedNearby() {
        return this.getNearbyPickerelweeds().size() > 0;
    }

    private List<BlockPos> getNearbyPickerelweeds() {
        ArrayList pickerelweeds = Lists.newArrayList();
        for (int yy = this.func_180425_c().func_177956_o() - 6; yy <= this.func_180425_c().func_177956_o() + 6; ++yy) {
            for (int xx = this.func_180425_c().func_177958_n() - 12; xx <= this.func_180425_c().func_177958_n() + 12; ++xx) {
                for (int zz = this.func_180425_c().func_177952_p() - 12; zz <= this.func_180425_c().func_177952_p() + 12; ++zz) {
                    if (!(this.field_70170_p.func_180495_p(new BlockPos(xx, yy, zz)).func_177230_c() instanceof BlockPickerelweed) && !(this.field_70170_p.func_180495_p(new BlockPos(xx, yy, zz)).func_177230_c() instanceof BlockPickerelweedDouble)) continue;
                    pickerelweeds.add(new BlockPos(xx, yy, zz));
                }
            }
        }
        return pickerelweeds;
    }

    private List<ItemStack> generateFishingLoot(ServerWorld world) {
        LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerWorld)this.field_70170_p).func_216015_a(LootParameters.field_216286_f, (Object)new BlockPos((Entity)this)).func_216015_a(LootParameters.field_216289_i, (Object)new ItemStack((IItemProvider)Items.field_151112_aM)).func_216023_a(this.field_70146_Z).func_186469_a(2.0f);
        lootcontext$builder.func_216015_a(LootParameters.field_216284_d, (Object)this).func_216015_a(LootParameters.field_216281_a, (Object)this);
        LootTable loottable = this.func_70681_au().nextFloat() >= 0.1f ? this.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(LootTables.field_186388_am) : this.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(LootTables.field_186389_an);
        return loottable.func_216113_a(lootcontext$builder.func_216022_a(LootParameterSets.field_216262_c));
    }

    public boolean func_98052_bS() {
        return this.func_70090_H() && super.func_98052_bS();
    }

    protected float func_205712_c(EquipmentSlotType p_205712_1_) {
        return this.shouldDropItem() ? 100.0f : 0.0f;
    }

    public boolean func_213365_e(ItemStack p_213365_1_) {
        EquipmentSlotType equipmentslottype = MobEntity.func_184640_d((ItemStack)p_213365_1_);
        if (!this.func_184582_a(equipmentslottype).func_190926_b()) {
            return false;
        }
        return equipmentslottype == EquipmentSlotType.MAINHAND && super.func_213365_e(p_213365_1_);
    }

    protected void func_175445_a(ItemEntity itemEntity) {
        ItemStack itemstack = itemEntity.func_92059_d();
        if (this.func_175448_a(itemstack) && !this.func_184582_a(EquipmentSlotType.MAINHAND).func_77973_b().func_206844_a(ItemTags.field_206964_G)) {
            int i = itemstack.func_190916_E();
            if (i > 1) {
                this.spawnItem(itemstack.func_77979_a(i - 1));
            }
            this.spitOutItem(this.func_184582_a(EquipmentSlotType.MAINHAND));
            this.func_184201_a(EquipmentSlotType.MAINHAND, itemstack.func_77979_a(1));
            this.func_71001_a((Entity)itemEntity, itemstack.func_190916_E());
            itemEntity.func_70106_y();
            this.eatTicks = 0;
        }
    }

    private void spawnItem(ItemStack stackIn) {
        ItemEntity itementity = new ItemEntity(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stackIn);
        this.field_70170_p.func_217376_c((Entity)itementity);
    }

    public void func_71001_a(Entity entityIn, int quantity) {
        super.func_71001_a(entityIn, quantity);
        this.setToDropItem(true);
    }

    public void func_184232_k(Entity passenger) {
        if (!this.func_184188_bt().isEmpty() && passenger instanceof AbstractFishEntity || !this.func_184188_bt().isEmpty() && passenger instanceof AnimalEntity) {
            float distance = 0.7f;
            double dx = Math.cos((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0) * (double)distance;
            double dz = Math.sin((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0) * (double)distance;
            Vec3d riderPos = new Vec3d(this.field_70165_t + dx, this.field_70163_u + this.func_70042_X() + ((Entity)this.func_184188_bt().get(0)).func_70033_W(), this.field_70161_v + dz);
            ((Entity)this.func_184188_bt().get(0)).func_70107_b(riderPos.field_72450_a, riderPos.field_72448_b, riderPos.field_72449_c);
        } else {
            super.func_184232_k(passenger);
        }
    }

    public double func_70042_X() {
        return (double)this.func_213305_a((Pose)this.func_213283_Z()).field_220316_b * 0.075;
    }

    public boolean func_205710_ba() {
        return true;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)UAItems.PIKE_SPAWN_EGG.get());
    }

    public EntitySize func_213305_a(Pose poseIn) {
        float scale = 0.0f;
        scale = this.getPikeType() < 12 ? (this.getPikeType() < 3 ? 8.0f : 10.0f) : (this.getPikeType() == 12 ? 10.0f : (this.getPikeType() == 13 ? 11.0f : (this.getPikeType() == 14 ? 15.0f : (this.getPikeType() == 15 || this.getPikeType() == 16 ? 8.0f : 9.0f))));
        return super.func_213305_a(poseIn).func_220313_a(0.225f * scale);
    }

    public static String getNameById(int id) {
        switch (id) {
            case 1: {
                return "amur_pike";
            }
            case 2: {
                return "redfin_pickerel";
            }
            case 3: {
                return "brown_northern_pike";
            }
            case 4: {
                return "mahogany_northern_pike";
            }
            case 5: {
                return "jade_northern_pike";
            }
            case 6: {
                return "olive_northern_pike";
            }
            case 7: {
                return "spectral_pike";
            }
            case 8: {
                return "spotted_brown_northern_pike";
            }
            case 9: {
                return "spotted_mahogany_northern_pike";
            }
            case 10: {
                return "spotted_jade_northern_pike";
            }
            case 11: {
                return "spotted_olive_northern_pike";
            }
            case 12: {
                return "supercharged_pike";
            }
            case 13: {
                return "obsidian_pike";
            }
            case 14: {
                return "muskellunge";
            }
            case 15: {
                return "chain_pickerel";
            }
            case 16: {
                return "grass_pickerel";
            }
            case 17: {
                return "black_southern_pike";
            }
            case 18: {
                return "ebony_southern_pike";
            }
            case 19: {
                return "mustard_southern_pike";
            }
            case 20: {
                return "lemon_southern_pike";
            }
            case 21: {
                return "golden_southern_pike";
            }
        }
        return "";
    }

    public boolean isLit() {
        return (Boolean)this.field_70180_af.func_187225_a(LIT);
    }

    private void setLit(boolean lit) {
        this.field_70180_af.func_187227_b(LIT, (Object)lit);
    }

    public boolean isMoving() {
        return (Boolean)this.field_70180_af.func_187225_a(MOVING);
    }

    private void setMoving(boolean moving) {
        this.field_70180_af.func_187227_b(MOVING, (Object)moving);
    }

    private void setCaughtEntity(int entityId) {
        this.field_70180_af.func_187227_b(CAUGHT_ENTITY, (Object)entityId);
    }

    public boolean hasCaughtEntity() {
        return (Integer)this.field_70180_af.func_187225_a(CAUGHT_ENTITY) != 0;
    }

    public int getAttackCooldown() {
        return (Integer)this.field_70180_af.func_187225_a(ATTACK_COOLDOWN);
    }

    public void setAttackCooldown(int ticks) {
        this.field_70180_af.func_187227_b(ATTACK_COOLDOWN, (Object)ticks);
    }

    public boolean shouldDropItem() {
        return (Boolean)this.field_70180_af.func_187225_a(DROP_ITEM);
    }

    public void setToDropItem(boolean bool) {
        this.field_70180_af.func_187227_b(DROP_ITEM, (Object)bool);
    }

    public int getPikeType() {
        return (Integer)this.field_70180_af.func_187225_a(PIKE_TYPE);
    }

    public void setPikeType(int typeId) {
        this.field_70180_af.func_187227_b(PIKE_TYPE, (Object)typeId);
    }

    private int getRandomTypeForBiome(IWorld world) {
        Biome biome = world.func_180494_b(new BlockPos((Entity)this));
        float rarity = this.field_70146_Z.nextFloat();
        if (rarity < 1.0f && this.field_70146_Z.nextFloat() > 0.35f) {
            if (biome.func_201856_r() == Biome.Category.SWAMP || biome.func_201856_r() == Biome.Category.RIVER || this.isFromBucket()) {
                int pickedVariant = this.field_70146_Z.nextInt(4);
                if (pickedVariant == 0) {
                    return 17;
                }
                if (pickedVariant == 1) {
                    if (this.field_70146_Z.nextInt(5) == 0) {
                        return 8;
                    }
                    return 3;
                }
                if (pickedVariant == 2) {
                    if (biome.func_201856_r() == Biome.Category.RIVER) {
                        return 15;
                    }
                    if (biome.func_201856_r() == Biome.Category.SWAMP) {
                        return 16;
                    }
                    return 3;
                }
                if (pickedVariant == 3) {
                    return 2;
                }
            } else {
                int pickedVariant = this.field_70146_Z.nextInt(3);
                if (pickedVariant == 0) {
                    return 17;
                }
                if (pickedVariant == 1) {
                    if (this.field_70146_Z.nextInt(5) == 0) {
                        return 8;
                    }
                    return 3;
                }
                if (pickedVariant == 2) {
                    return 2;
                }
            }
        } else if (rarity < 0.35f && rarity > 0.15f) {
            if (biome.func_201856_r() == Biome.Category.SWAMP || this.isFromBucket()) {
                int pickedVariant = this.field_70146_Z.nextInt(3);
                if (pickedVariant == 0) {
                    return 18;
                }
                if (pickedVariant == 1) {
                    if (this.field_70146_Z.nextInt(5) == 0) {
                        return 4;
                    }
                    return 9;
                }
                if (pickedVariant == 2) {
                    return 1;
                }
            } else {
                int pickedVariant = this.field_70146_Z.nextInt(2);
                if (pickedVariant == 0) {
                    return 18;
                }
                if (pickedVariant == 1) {
                    if (this.field_70146_Z.nextInt(5) == 0) {
                        return 4;
                    }
                    return 9;
                }
            }
        } else if (rarity < 0.15f && rarity > 0.05f) {
            int pickedVariant = this.field_70146_Z.nextInt(3);
            if (pickedVariant == 0) {
                return 20;
            }
            if (pickedVariant == 1) {
                return 19;
            }
            if (pickedVariant == 2) {
                if (this.field_70146_Z.nextInt(5) == 0) {
                    return 10;
                }
                return 5;
            }
        } else if (rarity < 0.05f && rarity > 0.005f) {
            if (biome.func_201856_r() == Biome.Category.RIVER || this.isFromBucket()) {
                int pickedVariant = this.field_70146_Z.nextInt(3);
                if (pickedVariant == 0) {
                    return 14;
                }
                if (pickedVariant == 1) {
                    return 21;
                }
                if (pickedVariant == 2) {
                    if (this.field_70146_Z.nextInt(5) == 0) {
                        return 11;
                    }
                    return 6;
                }
            } else {
                int pickedVariant = this.field_70146_Z.nextInt(2);
                if (pickedVariant == 0) {
                    return 21;
                }
                if (pickedVariant == 1) {
                    if (this.field_70146_Z.nextInt(5) == 0) {
                        return 11;
                    }
                    return 6;
                }
            }
        } else if (rarity < 0.005f) {
            int pickedVariant = this.field_70146_Z.nextInt(3);
            if (pickedVariant == 0) {
                return 7;
            }
            if (pickedVariant == 1) {
                return 13;
            }
            if (pickedVariant == 2) {
                return 12;
            }
        }
        return 3;
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("PikeType", this.getPikeType());
        compound.func_74768_a("AttackCooldown", this.getAttackCooldown());
        compound.func_74768_a("EatingLootDropCooldown", this.dropEatingLootCooldown);
        compound.func_74757_a("DoesDropItem", this.shouldDropItem());
        compound.func_74757_a("Lit", this.isLit());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setPikeType(compound.func_74762_e("PikeType"));
        this.dropEatingLootCooldown = compound.func_74762_e("EatingLootDropCooldown");
        this.setAttackCooldown(compound.func_74762_e("AttackCooldown"));
        this.setToDropItem(compound.func_74767_n("DoesDropItem"));
        this.setLit(compound.func_74767_n("Lit"));
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_203820_gM;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_203821_gN;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_203823_gP;
    }

    protected SoundEvent getFlopSound() {
        return SoundEvents.field_203822_gO;
    }

    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_203817_bZ;
    }

    public boolean isHidingInPickerelweed() {
        return this.func_130014_f_().func_180495_p(this.func_180425_c()).func_177230_c() instanceof BlockPickerelweed || this.func_130014_f_().func_180495_p(this.func_180425_c()).func_177230_c() instanceof BlockPickerelweedDouble;
    }

    public static void addSpawn() {
        ForgeRegistries.BIOMES.getValues().stream().forEach(EntityPike::processSpawning);
    }

    private static void processSpawning(Biome biome) {
        if (biome.func_201856_r() == Biome.Category.SWAMP || biome.func_201856_r() == Biome.Category.RIVER) {
            if (biome.func_201856_r() == Biome.Category.SWAMP) {
                biome.func_76747_a(EntityClassification.WATER_CREATURE).add(new Biome.SpawnListEntry((EntityType)UAEntities.PIKE.get(), 5, 1, 2));
                biome.func_76747_a(EntityClassification.WATER_CREATURE).add(new Biome.SpawnListEntry(EntityType.field_200749_ao, 5, 1, 2));
                biome.func_76747_a(EntityClassification.WATER_CREATURE).add(new Biome.SpawnListEntry(EntityType.field_203778_ae, 5, 1, 5));
            } else {
                biome.func_76747_a(EntityClassification.WATER_CREATURE).add(new Biome.SpawnListEntry((EntityType)UAEntities.PIKE.get(), 11, 1, 2));
            }
        }
    }

    public static class PikeData
    implements ILivingEntityData {
        public final int typeData;

        public PikeData(int type) {
            this.typeData = type;
        }
    }

    static class PlayerTemptGoal
    extends Goal {
        private static final EntityPredicate CAN_FOLLOW = new EntityPredicate().func_221013_a(10.0).func_221011_b().func_221008_a();
        private final EntityPike pike;
        private PlayerEntity tempter;
        private int cooldown;

        PlayerTemptGoal(EntityPike pike) {
            this.pike = pike;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            if (this.cooldown > 0) {
                --this.cooldown;
                return false;
            }
            this.tempter = this.pike.field_70170_p.func_217370_a(CAN_FOLLOW, (LivingEntity)this.pike);
            if (this.tempter == null) {
                return false;
            }
            return this.isTemptedBy(this.tempter.func_184614_ca()) || this.isTemptedBy(this.tempter.func_184592_cb());
        }

        public void func_75251_c() {
            this.tempter = null;
            this.pike.func_70661_as().func_75499_g();
            this.cooldown = 100;
        }

        public void func_75246_d() {
            this.pike.func_70671_ap().func_75651_a((Entity)this.tempter, (float)this.pike.func_184649_cE() + 20.0f, (float)this.pike.func_70646_bf());
            if (this.pike.func_70068_e((Entity)this.tempter) < 6.25) {
                this.pike.func_70661_as().func_75499_g();
            } else {
                this.pike.func_70661_as().func_75497_a((Entity)this.tempter, 1.0);
            }
        }

        private boolean isTemptedBy(ItemStack stack) {
            return stack.func_77973_b().func_206844_a(ItemTags.field_206964_G);
        }
    }

    class SwimToItemsGoal
    extends Goal {
        private int delay;

        private SwimToItemsGoal() {
        }

        public boolean func_75250_a() {
            if (this.delay > EntityPike.this.field_70173_aa) {
                return false;
            }
            List list = EntityPike.this.field_70170_p.func_175647_a(ItemEntity.class, EntityPike.this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0), ITEM_SELECTOR);
            return !list.isEmpty() || !EntityPike.this.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b();
        }

        public void func_75249_e() {
            List list = EntityPike.this.field_70170_p.func_175647_a(ItemEntity.class, EntityPike.this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0), ITEM_SELECTOR);
            if (!list.isEmpty()) {
                EntityPike.this.func_70661_as().func_75497_a((Entity)list.get(0), (double)1.2f);
            }
            this.delay = 0;
        }

        public void func_75246_d() {
            List list = EntityPike.this.field_70170_p.func_175647_a(ItemEntity.class, EntityPike.this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0), ITEM_SELECTOR);
            ItemStack itemstack = EntityPike.this.func_184582_a(EquipmentSlotType.MAINHAND);
            if (!list.isEmpty() && itemstack.func_190926_b()) {
                EntityPike.this.func_70661_as().func_75497_a((Entity)list.get(0), (double)1.2f);
            }
        }
    }

    static class PikeAttackGoal
    extends MeleeAttackGoal {
        public PikeAttackGoal(CreatureEntity creature, double speedIn, boolean useLongMemory) {
            super(creature, speedIn, useLongMemory);
        }

        public boolean func_75250_a() {
            return ((EntityPike)this.field_75441_b).getAttackCooldown() <= 0 && this.field_75441_b.func_70638_az() != null && !this.field_75441_b.func_70638_az().func_184215_y((Entity)this.field_75441_b) && !this.field_75441_b.func_184582_a(EquipmentSlotType.MAINHAND).func_77973_b().func_206844_a(ItemTags.field_206964_G) && this.field_75441_b.func_70090_H() && ((EntityPike)this.field_75441_b).getCaughtEntity() == null && !(this.field_75441_b.func_70638_az() instanceof PufferfishEntity) && super.func_75250_a();
        }

        public boolean func_75253_b() {
            return !this.field_75441_b.func_184582_a(EquipmentSlotType.MAINHAND).func_77973_b().func_206844_a(ItemTags.field_206964_G) && this.field_75441_b.func_70090_H() && super.func_75253_b();
        }

        protected void func_190102_a(LivingEntity enemy, double distToEnemySqr) {
            boolean isCloseToEntity;
            double d = this.func_179512_a(enemy);
            Vector3f difference = new Vector3f((float)(enemy.func_180425_c().func_177958_n() - this.field_75441_b.func_180425_c().func_177958_n()), (float)(enemy.func_180425_c().func_177956_o() - this.field_75441_b.func_180425_c().func_177956_o()), (float)(enemy.func_180425_c().func_177952_p() - this.field_75441_b.func_180425_c().func_177952_p()));
            boolean bl = isCloseToEntity = difference.length() <= 2.0f;
            if (isCloseToEntity && distToEnemySqr <= d && this.field_75439_d <= 0) {
                this.field_75439_d = 20;
                if (this.field_75441_b.func_70638_az() != null) {
                    if (enemy instanceof AbstractFishEntity || enemy instanceof AnimalEntity) {
                        ((EntityPike)this.field_75441_b).setAttackCooldown(this.field_75441_b.func_70681_au().nextInt(551) + 50);
                    }
                    AxisAlignedBB bb = new AxisAlignedBB(this.field_75441_b.func_180425_c()).func_186662_g(16.0);
                    List entities = this.field_75441_b.field_70170_p.func_217357_a(Entity.class, bb);
                    for (int i = 0; i < entities.size(); ++i) {
                        Entity entity = (Entity)entities.get(i);
                        if (!(entity instanceof EntityPike) || ((EntityPike)entity).getCaughtEntity() == null || ((EntityPike)entity).getCaughtEntity().func_145782_y() != enemy.func_145782_y()) continue;
                        ((EntityPike)entity).setCaughtEntity(0);
                    }
                    ((EntityPike)this.field_75441_b).setCaughtEntity(enemy.func_145782_y());
                    if (!(enemy instanceof AbstractFishEntity) && !(enemy instanceof AnimalEntity)) {
                        if (enemy instanceof TurtleEntity) {
                            enemy.func_70606_j(enemy.func_110143_aJ() - 10.0f);
                        } else {
                            enemy.func_70097_a(DamageSource.func_76358_a((LivingEntity)this.field_75441_b), 1.5f);
                        }
                    }
                }
                if (enemy instanceof AbstractFishEntity || enemy instanceof AnimalEntity) {
                    this.field_75441_b.func_70624_b(null);
                }
            }
        }

        public void func_75249_e() {
            if (this.field_75441_b.func_184582_a(EquipmentSlotType.MAINHAND) != null && this.field_75441_b.func_70638_az() instanceof AbstractFishEntity || this.field_75441_b.func_184582_a(EquipmentSlotType.MAINHAND) != null && this.field_75441_b.func_70638_az() instanceof TurtleEntity) {
                ((EntityPike)this.field_75441_b).spitOutItem(this.field_75441_b.func_184582_a(EquipmentSlotType.MAINHAND));
            }
            super.func_75249_e();
        }
    }

    static class HideInPickerelweedGoal
    extends RandomWalkingGoal {
        public HideInPickerelweedGoal(EntityPike pike) {
            super((CreatureEntity)pike, 1.1, 25);
        }

        public boolean func_75250_a() {
            Vec3d vec3d;
            if (!this.field_179482_g) {
                if (this.field_75457_a.func_70654_ax() >= 100) {
                    return false;
                }
                if (this.field_75457_a.func_70681_au().nextInt(this.field_179481_f) != 0) {
                    return false;
                }
            }
            if ((vec3d = this.func_190864_f()) == null) {
                return false;
            }
            if (((EntityPike)this.field_75457_a).isPickerelweedNearby()) {
                this.field_75455_b = vec3d.field_72450_a;
                this.field_75456_c = vec3d.field_72448_b;
                this.field_75453_d = vec3d.field_72449_c;
                this.field_179482_g = false;
                return true;
            }
            return false;
        }

        public boolean func_75253_b() {
            return ((EntityPike)this.field_75457_a).isPickerelweedNearby() && super.func_75253_b();
        }

        @Nullable
        protected Vec3d func_190864_f() {
            if (((EntityPike)this.field_75457_a).isPickerelweedNearby()) {
                int pickedWeed = this.field_75457_a.func_70681_au().nextInt(((EntityPike)this.field_75457_a).getNearbyPickerelweeds().size());
                return new Vec3d((Vec3i)((EntityPike)this.field_75457_a).getNearbyPickerelweeds().get(pickedWeed));
            }
            return null;
        }
    }

    static class MoveHelperController
    extends MovementController {
        private final EntityPike pike;

        MoveHelperController(EntityPike pike) {
            super((MobEntity)pike);
            this.pike = pike;
        }

        public void func_75641_c() {
            if (this.pike.func_208600_a(FluidTags.field_206959_a)) {
                this.pike.func_213317_d(this.pike.func_213322_ci().func_72441_c(0.0, 0.001, 0.0));
            }
            if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.pike.func_70661_as().func_75500_f()) {
                double d0 = this.field_75646_b - this.pike.field_70165_t;
                double d1 = this.field_75647_c - this.pike.field_70163_u;
                double d2 = this.field_75644_d - this.pike.field_70161_v;
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.pike.field_70761_aq = this.pike.field_70177_z = this.func_75639_a(this.pike.field_70177_z, f, 90.0f);
                float f1 = (float)(this.field_75645_e * this.pike.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                this.pike.func_70659_e(MathHelper.func_219799_g((float)0.125f, (float)this.pike.func_70689_ay(), (float)f1));
                this.pike.func_213317_d(this.pike.func_213322_ci().func_72441_c(0.0, (double)this.pike.func_70689_ay() * (d1 /= d3) * 0.04, 0.0));
                this.pike.setMoving(true);
            } else {
                if (this.pike.getPikeType() == 12) {
                    this.pike.func_70659_e(0.0f);
                }
                this.pike.setMoving(false);
            }
        }
    }
}

