/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.entities.thrasher;

import com.teamabnormals.upgrade_aquatic.api.UpgradeAquaticAPI;
import com.teamabnormals.upgrade_aquatic.common.entities.thrasher.EntityThrasher;
import com.teamabnormals.upgrade_aquatic.core.registry.UAEntities;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntitySonarWave
extends Entity {
    private static final DataParameter<Integer> OWNER_ID = EntityDataManager.func_187226_a(EntitySonarWave.class, (IDataSerializer)DataSerializers.field_187192_b);
    private float growProgress = 0.0f;
    private float prevGrowProgress = 0.0f;

    public EntitySonarWave(EntityType<? extends EntitySonarWave> type, World worldIn) {
        super(type, worldIn);
        this.field_70156_m = true;
    }

    public EntitySonarWave(World worldIn, double x, double y, double z) {
        this((EntityType<? extends EntitySonarWave>)((EntityType)UAEntities.SONAR_WAVE.get()), worldIn);
        this.func_70107_b(x, y, z);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    public EntitySonarWave(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        this((EntityType<? extends EntitySonarWave>)((EntityType)UAEntities.SONAR_WAVE.get()), world);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(OWNER_ID, (Object)0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        if (this.getThrasherOwner() != null) {
            List entities = this.field_70170_p.func_175674_a((Entity)this.getThrasherOwner(), this.func_174813_aQ().func_186662_g((double)this.growProgress), EntityThrasher.ENEMY_MATCHER);
            for (Entity entity : entities) {
                if (!(entity instanceof LivingEntity) || this.getThrasherOwner().func_70638_az() != null) continue;
                this.getThrasherOwner().func_70624_b((LivingEntity)entity);
            }
        }
        this.prevGrowProgress = this.growProgress;
        this.growProgress = this.growProgress < 0.1f ? (this.growProgress += 0.025f) : (this.growProgress += 0.1f);
        if (this.field_70173_aa > 40) {
            this.func_70106_y();
        }
    }

    protected void func_213282_i(double x, double y, double z) {
    }

    public void fireSonarWave(EntityThrasher thrasher) {
        float xMotion = -MathHelper.func_76126_a((float)(thrasher.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(thrasher.field_70125_A * ((float)Math.PI / 180)));
        float yMotion = -MathHelper.func_76126_a((float)(thrasher.field_70125_A * ((float)Math.PI / 180)));
        float zMotion = MathHelper.func_76134_b((float)(thrasher.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(thrasher.field_70125_A * ((float)Math.PI / 180)));
        Vec3d motion = new Vec3d((double)xMotion, (double)yMotion, (double)zMotion).func_72432_b().func_186678_a(0.75);
        this.func_213317_d(motion);
        this.setOwnerId(thrasher.func_145782_y());
        this.func_70107_b(thrasher.field_70165_t + (double)xMotion, thrasher.field_70163_u, thrasher.field_70161_v + (double)zMotion);
        float motionSqrt = MathHelper.func_76133_a((double)EntitySonarWave.func_213296_b((Vec3d)motion));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)motion.field_72450_a, (double)motion.field_72449_c) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)motion.field_72448_b, (double)motionSqrt) * 57.29577951308232);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    public boolean func_70112_a(double distance) {
        return true;
    }

    public void func_203004_j(boolean downwards) {
    }

    public void func_203002_i(boolean downwards) {
    }

    protected void func_71061_d_() {
    }

    public boolean func_96092_aw() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getGrowProgress() {
        return MathHelper.func_219799_g((float)UpgradeAquaticAPI.ClientInfo.getPartialTicks(), (float)this.prevGrowProgress, (float)this.growProgress);
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.setOwnerId(compound.func_74762_e("OwnerId"));
        this.growProgress = compound.func_74760_g("GrowProgress");
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("OwnerId", this.getOwnerId());
        compound.func_74776_a("GrowProgress", this.growProgress);
    }

    public void setOwnerId(int id) {
        this.func_184212_Q().func_187227_b(OWNER_ID, (Object)id);
    }

    public int getOwnerId() {
        return (Integer)this.func_184212_Q().func_187225_a(OWNER_ID);
    }

    @Nullable
    public EntityThrasher getThrasherOwner() {
        Entity owner = this.field_70170_p.func_73045_a(this.getOwnerId());
        if (owner instanceof EntityThrasher) {
            return (EntityThrasher)owner;
        }
        return null;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

