/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.world.gen.feature;

import com.mojang.datafixers.Dynamic;
import com.teamabnormals.upgrade_aquatic.api.util.BlockUtil;
import com.teamabnormals.upgrade_aquatic.common.world.gen.UAFeatures;
import com.teamabnormals.upgrade_aquatic.core.registry.UABlocks;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.state.IProperty;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.registries.ForgeRegistries;

public class FeatureDriftwood
extends Feature<NoFeatureConfig> {
    protected static final BlockState DRIFTWOOD_LOG = UABlocks.DRIFTWOOD_LOG.func_176223_P();

    public FeatureDriftwood(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        boolean standing = rand.nextFloat() < 0.25f;
        Block downBlock = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        if (standing && world.func_180495_p(pos).func_177230_c() == Blocks.field_150355_j && (downBlock.func_203417_a(BlockTags.field_219750_S) || downBlock.func_203417_a(BlockTags.field_203436_u))) {
            Direction upDirection = Direction.UP;
            if (this.isDirectionOpen(world, pos, upDirection, 3, true)) {
                for (int i = 0; i < 3; ++i) {
                    this.placeDriftwoodLog(world, pos.func_177967_a(upDirection, i), upDirection);
                    if (!rand.nextBoolean()) continue;
                    Direction horizontalDirection = Direction.func_176731_b((int)rand.nextInt(4));
                    if (!world.func_175623_d(pos.func_177967_a(upDirection, i).func_177972_a(horizontalDirection)) || !BlockUtil.isPosNotTouchingBlock(world, pos.func_177967_a(upDirection, i).func_177972_a(horizontalDirection), UABlocks.DRIFTWOOD_LOG, horizontalDirection.func_176734_d())) continue;
                    this.placeDriftwoodLog(world, pos.func_177967_a(upDirection, i).func_177972_a(horizontalDirection), horizontalDirection);
                }
                return true;
            }
            return false;
        }
        Direction direction = Direction.func_82600_a((int)(rand.nextInt(4) + 2));
        int length = rand.nextInt(3) + 3;
        if (world.func_180494_b(pos).func_201856_r() == Biome.Category.OCEAN && this.canFitInOcean(world, pos, direction, length) && world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150355_j && world.func_175623_d(pos.func_177984_a()) && rand.nextFloat() < 0.25f || world.func_180494_b(pos).func_201856_r() != Biome.Category.OCEAN && this.isNearWater(world, pos) && downBlock.func_203417_a(BlockTags.field_219750_S) || downBlock.func_203417_a(BlockTags.field_203436_u) && this.isDirectionOpen(world, pos, direction, length, false) && this.isGroundForDirectionMostlySuitable(world, pos, direction, length)) {
            for (int i = 0; i < length; ++i) {
                this.placeDriftwoodLog(world, pos.func_177967_a(direction, i), direction);
                if (rand.nextBoolean()) {
                    this.placeBranch(world, pos.func_177967_a(direction, i), direction, rand, length >= 5);
                }
                if (!rand.nextBoolean()) continue;
                Direction upOrDown = rand.nextBoolean() ? Direction.UP : Direction.DOWN;
                if (!this.isBlockPlaceableAtPos(world, pos.func_177967_a(direction, i).func_177972_a(upOrDown), world.func_180494_b(pos.func_177967_a(direction, i).func_177972_a(upOrDown)).func_201856_r() == Biome.Category.OCEAN) || !BlockUtil.isPosNotTouchingBlock(world, pos.func_177967_a(direction, i).func_177972_a(upOrDown), UABlocks.DRIFTWOOD_LOG, Direction.UP, Direction.DOWN)) continue;
                this.placeDriftwoodLog(world, pos.func_177967_a(direction, i).func_177972_a(upOrDown), upOrDown);
            }
            return true;
        }
        return false;
    }

    protected boolean isDirectionOpen(IWorld world, BlockPos pos, Direction direction, int length, boolean inWater) {
        if (inWater) {
            return world.func_180495_p(pos).func_177230_c() == Blocks.field_150355_j && world.func_175623_d(pos.func_177984_a()) && world.func_175623_d(pos.func_177981_b(2));
        }
        for (int i = 0; i < length; ++i) {
            if (world.func_175623_d(pos.func_177967_a(direction, i))) continue;
            return false;
        }
        return true;
    }

    protected boolean canFitInOcean(IWorld world, BlockPos pos, Direction direction, int length) {
        for (int i = 0; i < length; ++i) {
            if (world.func_180495_p(pos.func_177967_a(direction, i)).func_177230_c() == Blocks.field_150355_j) continue;
            return false;
        }
        return true;
    }

    protected boolean isGroundForDirectionMostlySuitable(IWorld world, BlockPos pos, Direction direction, int length) {
        int foundGaps = 0;
        for (int i = 0; i < length; ++i) {
            if (world.func_180495_p(pos.func_177977_b().func_177967_a(direction, i)).func_177230_c().func_203417_a(BlockTags.field_219750_S) || world.func_180495_p(pos.func_177977_b().func_177967_a(direction, i)).func_177230_c().func_203417_a(BlockTags.field_203436_u)) continue;
            if (world.func_180494_b(pos.func_177977_b().func_177967_a(direction, i)).func_201856_r() != Biome.Category.OCEAN) {
                ++foundGaps;
                continue;
            }
            if (world.func_180495_p(pos.func_177977_b().func_177967_a(direction, i)).func_177230_c() == Blocks.field_150355_j) continue;
            ++foundGaps;
        }
        return (double)foundGaps < Math.ceil(length / 2);
    }

    protected boolean isNearWater(IWorld world, BlockPos pos) {
        Biome biome = world.func_180494_b(pos);
        int foundWaterSpots = 0;
        if (biome.func_201856_r() == Biome.Category.RIVER) {
            for (int y = pos.func_177956_o() - 2; y < pos.func_177956_o(); ++y) {
                for (int x = pos.func_177958_n() - 3; x < pos.func_177958_n() + 3; ++x) {
                    for (int z = pos.func_177952_p() - 3; z < pos.func_177952_p() + 3; ++z) {
                        BlockPos currentPos = new BlockPos(x, y, z);
                        if (!world.func_175710_j(currentPos) || world.func_180495_p(currentPos).func_177230_c() != Blocks.field_150355_j) continue;
                        ++foundWaterSpots;
                    }
                }
            }
        } else {
            for (int y = pos.func_177956_o() - 1; y < pos.func_177956_o(); ++y) {
                for (int x = pos.func_177958_n() - 2; x < pos.func_177958_n() + 2; ++x) {
                    for (int z = pos.func_177952_p() - 2; z < pos.func_177952_p() + 2; ++z) {
                        BlockPos currentPos = new BlockPos(x, y, z);
                        if (!world.func_175710_j(currentPos) || world.func_180495_p(currentPos).func_177230_c() != Blocks.field_150355_j) continue;
                        ++foundWaterSpots;
                    }
                }
            }
        }
        return foundWaterSpots >= 3;
    }

    protected void placeDriftwoodLog(IWorld world, BlockPos pos, Direction direction) {
        world.func_180501_a(pos, (BlockState)DRIFTWOOD_LOG.func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, (Comparable)direction.func_176740_k()), 2);
    }

    protected void placeBranch(IWorld world, BlockPos startPos, Direction direction, Random rand, boolean isLarge) {
        int size = isLarge ? rand.nextInt(2) + 1 : 1;
        Direction branchDirection = rand.nextBoolean() ? direction.func_176746_e() : direction.func_176735_f();
        for (int i = 1; i < size + 1; ++i) {
            Block[] sideBlocks = new Block[]{world.func_180495_p(startPos.func_177967_a(branchDirection, i).func_177972_a(branchDirection.func_176746_e())).func_177230_c(), world.func_180495_p(startPos.func_177967_a(branchDirection, i).func_177972_a(branchDirection.func_176735_f())).func_177230_c()};
            if (!this.isBlockPlaceableAtPos(world, startPos.func_177967_a(branchDirection, i), world.func_180494_b(startPos.func_177967_a(branchDirection, i)).func_201856_r() == Biome.Category.OCEAN) || sideBlocks[0] == DRIFTWOOD_LOG.func_177230_c() || sideBlocks[1] == DRIFTWOOD_LOG.func_177230_c()) break;
            this.placeDriftwoodLog(world, startPos.func_177967_a(branchDirection, i), branchDirection);
        }
    }

    protected boolean isBlockPlaceableAtPos(IWorld world, BlockPos pos, boolean inOcean) {
        Block block = world.func_180495_p(pos).func_177230_c();
        return inOcean ? world.func_175623_d(pos) || block == Blocks.field_150355_j : world.func_175623_d(pos);
    }

    public static void addDriftwood() {
        ForgeRegistries.BIOMES.getValues().stream().forEach(FeatureDriftwood::process);
    }

    private static void process(Biome biome) {
        if (biome.func_201856_r() == Biome.Category.BEACH) {
            biome.func_203607_a(GenerationStage.Decoration.VEGETAL_DECORATION).add(Biome.func_222280_a((Feature)((Feature)UAFeatures.DRIFTWOOD.get()), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(14)));
        } else if (biome.func_201856_r() == Biome.Category.RIVER) {
            biome.func_203607_a(GenerationStage.Decoration.VEGETAL_DECORATION).add(Biome.func_222280_a((Feature)((Feature)UAFeatures.DRIFTWOOD.get()), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(125)));
        } else if (biome.func_201856_r() == Biome.Category.SWAMP) {
            biome.func_203607_a(GenerationStage.Decoration.VEGETAL_DECORATION).add(Biome.func_222280_a((Feature)((Feature)UAFeatures.DRIFTWOOD.get()), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(21)));
        } else if (biome.func_201856_r() == Biome.Category.OCEAN) {
            biome.func_203607_a(GenerationStage.Decoration.VEGETAL_DECORATION).add(Biome.func_222280_a((Feature)((Feature)UAFeatures.DRIFTWOOD.get()), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(1)));
        }
    }
}

