/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.world.gen.feature;

import com.mojang.datafixers.Dynamic;
import com.teamabnormals.upgrade_aquatic.common.blocks.BlockBeachgrassTall;
import com.teamabnormals.upgrade_aquatic.common.world.gen.UAFeatures;
import com.teamabnormals.upgrade_aquatic.core.registry.UABlocks;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.registries.ForgeRegistries;

public class FeatureDunes
extends Feature<NoFeatureConfig> {
    public FeatureDunes(Function<Dynamic<?>, ? extends NoFeatureConfig> config) {
        super(config);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        BlockState blockstate = world.func_180495_p(pos);
        while ((world.func_175623_d(pos) || blockstate.func_203425_a(BlockTags.field_206952_E)) && pos.func_177956_o() > 0) {
            pos = pos.func_177977_b();
            blockstate = world.func_180495_p(pos);
        }
        int grassesPlaced = 0;
        if (pos.func_177956_o() >= world.func_181545_F() + 6) {
            for (int j = 0; j < 128; ++j) {
                BlockPos blockpos = pos.func_177982_a(rand.nextInt(4) - rand.nextInt(4), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(4) - rand.nextInt(4));
                if (!world.func_175623_d(blockpos) || !UABlocks.BEACHGRASS.func_176223_P().func_196955_c((IWorldReader)world, blockpos)) continue;
                this.placeBeachgrass(world, blockpos, rand);
                ++grassesPlaced;
            }
        } else {
            return true;
        }
        return grassesPlaced > 0;
    }

    private void placeBeachgrass(IWorld world, BlockPos pos, Random rand) {
        if (rand.nextFloat() < 0.3f) {
            BlockBeachgrassTall beachGrass = (BlockBeachgrassTall)UABlocks.TALL_BEACHGRASS;
            if (world.func_175623_d(pos) && world.func_175623_d(pos.func_177984_a())) {
                beachGrass.placeAt(world, pos, 2);
            }
        } else if (world.func_175623_d(pos)) {
            world.func_180501_a(pos, UABlocks.BEACHGRASS.func_176223_P(), 2);
        }
    }

    public static void addDunes() {
        ForgeRegistries.BIOMES.getValues().stream().forEach(FeatureDunes::process);
    }

    private static void process(Biome biome) {
        if (biome.func_201856_r() == Biome.Category.BEACH) {
            biome.func_203607_a(GenerationStage.Decoration.VEGETAL_DECORATION).add(Biome.func_222280_a((Feature)((Feature)UAFeatures.DUNES.get()), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(18)));
        }
    }
}

