/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.world.gen.feature;

import com.mojang.datafixers.Dynamic;
import com.teamabnormals.upgrade_aquatic.api.util.MathUtil;
import com.teamabnormals.upgrade_aquatic.common.blocks.BlockPickerelweed;
import com.teamabnormals.upgrade_aquatic.common.blocks.BlockPickerelweedDouble;
import com.teamabnormals.upgrade_aquatic.common.world.gen.UAFeatures;
import com.teamabnormals.upgrade_aquatic.core.registry.UABlocks;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.IFluidState;
import net.minecraft.state.IProperty;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.FlowerForestBiome;
import net.minecraft.world.biome.SwampBiome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class FeaturePickerelweed
extends Feature<NoFeatureConfig> {
    private static final BlockState BLUE_PICKERELWEED = UABlocks.PICKERELWEED_BLUE.func_176223_P();
    private static final BlockState PURPLE_PICKERELWEED = UABlocks.PICKERELWEED_PURPLE.func_176223_P();

    public FeaturePickerelweed(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        Biome biome = worldIn.func_180494_b(pos);
        if (this.isValidBlock(worldIn, pos) && this.shouldPlace(worldIn, pos) && BLUE_PICKERELWEED.func_196955_c((IWorldReader)worldIn, pos.func_177977_b())) {
            if (biome.func_201856_r() == Biome.Category.RIVER || biome.func_201856_r() == Biome.Category.SWAMP || biome instanceof FlowerForestBiome) {
                boolean purpleGen;
                if (biome instanceof SwampBiome) {
                    purpleGen = (double)rand.nextFloat() >= 0.6;
                } else {
                    boolean bl = purpleGen = !((double)rand.nextFloat() >= 0.6);
                }
                if ((double)rand.nextInt() <= 0.9) {
                    this.generatePickerelweedPatch(worldIn, pos, purpleGen, rand.nextInt(8));
                }
            } else {
                boolean purpleGen;
                if (biome.func_150561_m() == Biome.TempCategory.COLD) {
                    purpleGen = (double)rand.nextFloat() >= 0.75;
                } else if (biome.func_150561_m() == Biome.TempCategory.MEDIUM) {
                    purpleGen = rand.nextBoolean();
                } else {
                    boolean bl = purpleGen = !((double)rand.nextFloat() >= 0.75);
                }
                if ((double)rand.nextInt() <= 0.35) {
                    this.generatePickerelweedPatch(worldIn, pos, purpleGen, rand.nextInt(8));
                }
            }
            return true;
        }
        return false;
    }

    public void generatePickerelweedPatch(IWorld world, BlockPos pos, boolean purple, int randomDesign) {
        int[] patterns = new int[3];
        switch (randomDesign) {
            default: {
                patterns[0] = 4;
                patterns[1] = 4;
                patterns[2] = 9;
            }
            case 1: {
                patterns[0] = 3;
                patterns[1] = 4;
                patterns[2] = 9;
            }
            case 2: {
                patterns[0] = 3;
                patterns[1] = 4;
                patterns[2] = 12;
            }
            case 3: {
                patterns[0] = 3;
                patterns[1] = 13;
                patterns[2] = 12;
            }
            case 4: {
                patterns[0] = 4;
                patterns[1] = 3;
                patterns[2] = 6;
            }
            case 5: {
                patterns[0] = 3;
                patterns[1] = 4;
                patterns[2] = 6;
            }
            case 6: {
                patterns[0] = 5;
                patterns[1] = 4;
                patterns[2] = 6;
            }
            case 7: 
        }
        patterns[0] = 5;
        patterns[1] = 4;
        patterns[2] = 6;
        BlockPos startPos = pos;
        BlockPickerelweedDouble doubleplantblock = (BlockPickerelweedDouble)(!purple ? UABlocks.PICKERELWEED_TALL_BLUE : UABlocks.PICKERELWEED_TALL_PURPLE);
        MathUtil.Equation r = theta -> (Math.cos((double)patterns[1] * theta) / (double)patterns[2] + 1.0) * (double)patterns[0];
        if (!(world.func_175623_d(startPos.func_177977_b()) || world.func_175623_d(startPos.func_177979_c(2)) || world.func_175623_d(startPos.func_177979_c(3)))) {
            int repeatsDown = world.func_201674_k().nextInt(2) + 2;
            for (int repeats = 0; repeats < repeatsDown; ++repeats) {
                pos = pos.func_177982_a(0, -repeats, 0);
                for (int i = -(patterns[0] / patterns[2] + patterns[0]); i < patterns[0] / patterns[2] + patterns[0]; ++i) {
                    for (int j = -(patterns[0] / patterns[2] + patterns[0]); j < patterns[0] / patterns[2] + patterns[0]; ++j) {
                        double radius = r.compute(Math.atan2(j, i));
                        BlockPos placingPos = pos.func_177982_a(i, 0, j);
                        if (!world.func_180495_p(placingPos).func_185904_a().func_76222_j() || !((double)(i * i + j * j) < radius * radius)) continue;
                        if ((double)(i * i + j * j) > (radius - 1.0) * (radius - 1.0)) {
                            IFluidState ifluidstate = world.func_204610_c(placingPos);
                            if (PURPLE_PICKERELWEED.func_196955_c((IWorldReader)world, placingPos) && world.func_180495_p(placingPos.func_177984_a()).func_185904_a().func_76222_j() && world.func_201674_k().nextDouble() <= 0.85) {
                                if (purple) {
                                    world.func_180501_a(placingPos, (BlockState)PURPLE_PICKERELWEED.func_206870_a((IProperty)BlockPickerelweed.WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206884_a(FluidTags.field_206959_a))), 2);
                                    continue;
                                }
                                world.func_180501_a(placingPos, (BlockState)BLUE_PICKERELWEED.func_206870_a((IProperty)BlockPickerelweed.WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206884_a(FluidTags.field_206959_a))), 2);
                                continue;
                            }
                            if (!PURPLE_PICKERELWEED.func_196955_c((IWorldReader)world, placingPos)) continue;
                            doubleplantblock.placeAt(world, placingPos, 2);
                            continue;
                        }
                        if (!doubleplantblock.func_176223_P().func_196955_c((IWorldReader)world, placingPos)) continue;
                        doubleplantblock.placeAt(world, placingPos, 2);
                    }
                }
            }
        }
    }

    public boolean isValidBlock(IWorld world, BlockPos pos) {
        return world.func_175623_d(pos) || world.func_180495_p(pos).func_204520_s().func_206884_a(FluidTags.field_206959_a);
    }

    public boolean shouldPlace(IWorld world, BlockPos pos) {
        return world.func_204610_c(pos.func_177977_b().func_177976_e()).func_206884_a(FluidTags.field_206959_a) || world.func_204610_c(pos.func_177977_b().func_177974_f()).func_206884_a(FluidTags.field_206959_a) || world.func_204610_c(pos.func_177977_b().func_177978_c()).func_206884_a(FluidTags.field_206959_a) || world.func_204610_c(pos.func_177977_b().func_177968_d()).func_206884_a(FluidTags.field_206959_a);
    }

    public static void addPickerelweed() {
        ForgeRegistries.BIOMES.getValues().stream().forEach(FeaturePickerelweed::process);
    }

    private static void process(Biome biome) {
        if (biome == Biomes.field_185444_T) {
            biome.func_203607_a(GenerationStage.Decoration.VEGETAL_DECORATION).add(Biome.func_222280_a((Feature)((Feature)UAFeatures.PICKERELWEED.get()), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(90)));
        } else if (biome.func_201856_r() != Biome.Category.OCEAN && biome.func_201856_r() != Biome.Category.BEACH && biome.func_201856_r() != Biome.Category.DESERT && biome.func_201856_r() != Biome.Category.ICY) {
            biome.func_203607_a(GenerationStage.Decoration.VEGETAL_DECORATION).add(Biome.func_222280_a((Feature)((Feature)UAFeatures.PICKERELWEED.get()), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(28)));
            if (ModList.get().isLoaded("bloomful")) {
                ((Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation("bloomful:wisteria_forest"))).func_203607_a(GenerationStage.Decoration.VEGETAL_DECORATION).add(Biome.func_222280_a((Feature)((Feature)UAFeatures.PICKERELWEED.get()), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(90)));
            }
        }
    }
}

