/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.world.gen.feature;

import com.mojang.datafixers.Dynamic;
import com.teamabnormals.upgrade_aquatic.api.util.MathUtil;
import com.teamabnormals.upgrade_aquatic.common.world.gen.UAFeatures;
import com.teamabnormals.upgrade_aquatic.core.registry.UABlocks;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.registries.ForgeRegistries;

public class FeatureSearocket
extends Feature<NoFeatureConfig> {
    private static final BlockState SEAROCKET(boolean pink) {
        return pink ? UABlocks.SEAROCKET_PINK.func_176223_P() : UABlocks.SEAROCKET_WHITE.func_176223_P();
    }

    public FeatureSearocket(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        if (worldIn.func_180494_b(pos).func_150561_m() == Biome.TempCategory.COLD) {
            boolean colorType;
            boolean bl = colorType = rand.nextFloat() <= 0.25f;
            if (FeatureSearocket.SEAROCKET(colorType).func_196955_c((IWorldReader)worldIn, pos)) {
                this.generateSearocketPatch(worldIn, pos, colorType, rand.nextInt(8));
                return true;
            }
        } else {
            boolean colorType;
            boolean bl = colorType = rand.nextFloat() <= 0.75f;
            if (FeatureSearocket.SEAROCKET(colorType).func_196955_c((IWorldReader)worldIn, pos)) {
                this.generateSearocketPatch(worldIn, pos, colorType, rand.nextInt(8));
                return true;
            }
        }
        return false;
    }

    public void generateSearocketPatch(IWorld world, BlockPos pos, boolean pink, int randomDesign) {
        int[] patterns = new int[3];
        switch (randomDesign) {
            default: {
                patterns[0] = 3;
                patterns[1] = 4;
                patterns[2] = 9;
            }
            case 1: {
                patterns[0] = 2;
                patterns[1] = 8;
                patterns[2] = 5;
            }
            case 2: {
                patterns[0] = 3;
                patterns[1] = 4;
                patterns[2] = 7;
            }
            case 3: {
                patterns[0] = 3;
                patterns[1] = 13;
                patterns[2] = 12;
            }
            case 4: {
                patterns[0] = 3;
                patterns[1] = 12;
                patterns[2] = 12;
            }
            case 5: {
                patterns[0] = 2;
                patterns[1] = 12;
                patterns[2] = 12;
            }
            case 6: {
                patterns[0] = 3;
                patterns[1] = 5;
                patterns[2] = 3;
            }
            case 7: 
        }
        patterns[0] = 3;
        patterns[1] = 3;
        patterns[2] = 6;
        BlockPos startPos = pos;
        MathUtil.Equation r = theta -> (Math.cos((double)patterns[1] * theta) / (double)patterns[2] + 1.0) * (double)patterns[0];
        if (!(world.func_175623_d(startPos.func_177977_b()) || world.func_175623_d(startPos.func_177979_c(2)) || world.func_175623_d(startPos.func_177979_c(3)))) {
            int repeatsDown = world.func_201674_k().nextInt(2) + 2;
            for (int repeats = 0; repeats < repeatsDown; ++repeats) {
                pos = pos.func_177982_a(0, -repeats, 0);
                for (int i = -(patterns[0] / patterns[2] + patterns[0]); i < patterns[0] / patterns[2] + patterns[0]; ++i) {
                    for (int j = -(patterns[0] / patterns[2] + patterns[0]); j < patterns[0] / patterns[2] + patterns[0]; ++j) {
                        double radius = r.compute(Math.atan2(j, i));
                        BlockPos placingPos = pos.func_177982_a(i, 0, j);
                        if (!world.func_180495_p(placingPos).func_185904_a().func_76222_j() || !((double)(i * i + j * j) < radius * radius) || !FeatureSearocket.SEAROCKET(pink).func_196955_c((IWorldReader)world, placingPos) || !world.func_204610_c(placingPos).func_206888_e()) continue;
                        world.func_180501_a(placingPos, FeatureSearocket.SEAROCKET(pink), 2);
                    }
                }
            }
        }
    }

    public static void addSearocket() {
        ForgeRegistries.BIOMES.getValues().stream().forEach(FeatureSearocket::process);
    }

    private static void process(Biome biome) {
        if (biome.func_201856_r() == Biome.Category.BEACH) {
            biome.func_203607_a(GenerationStage.Decoration.VEGETAL_DECORATION).add(Biome.func_222280_a((Feature)((Feature)UAFeatures.SEAROCKET.get()), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(15)));
        }
    }
}

