/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.core.registry;

import com.teamabnormals.upgrade_aquatic.common.blocks.BlockPickerelweed;
import com.teamabnormals.upgrade_aquatic.common.blocks.BlockPickerelweedDouble;
import com.teamabnormals.upgrade_aquatic.common.entities.EntityFlare;
import com.teamabnormals.upgrade_aquatic.common.entities.EntityLionfish;
import com.teamabnormals.upgrade_aquatic.common.entities.EntityNautilus;
import com.teamabnormals.upgrade_aquatic.common.entities.EntityPike;
import com.teamabnormals.upgrade_aquatic.common.entities.EntityUABoat;
import com.teamabnormals.upgrade_aquatic.common.entities.thrasher.EntityGreatThrasher;
import com.teamabnormals.upgrade_aquatic.common.entities.thrasher.EntitySonarWave;
import com.teamabnormals.upgrade_aquatic.common.entities.thrasher.EntityThrasher;
import java.util.Random;
import java.util.function.BiFunction;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="upgrade_aquatic", bus=Mod.EventBusSubscriber.Bus.MOD)
public class UAEntities {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = new DeferredRegister(ForgeRegistries.ENTITIES, "upgrade_aquatic");
    public static final RegistryObject<EntityType<EntityUABoat>> BOAT = ENTITY_TYPES.register("boat", () -> UAEntities.createEntity(EntityUABoat::new, EntityUABoat::new, EntityClassification.MISC, "boat", 1.375f, 0.5625f));
    public static final RegistryObject<EntityType<EntitySonarWave>> SONAR_WAVE = ENTITY_TYPES.register("sonar_wave", () -> UAEntities.createEntity(EntitySonarWave::new, EntitySonarWave::new, EntityClassification.AMBIENT, "sonar_wave", 1.0f, 1.0f));
    public static final RegistryObject<EntityType<EntityNautilus>> NAUTILUS = ENTITY_TYPES.register("nautilus", () -> UAEntities.createLivingEntity(EntityNautilus::new, EntityClassification.CREATURE, "nautilus", 0.5f, 0.5f));
    public static final RegistryObject<EntityType<EntityPike>> PIKE = ENTITY_TYPES.register("pike", () -> UAEntities.createLivingEntity(EntityPike::new, EntityClassification.CREATURE, "pike", 0.7f, 0.4f));
    public static final RegistryObject<EntityType<EntityLionfish>> LIONFISH = ENTITY_TYPES.register("lionfish", () -> UAEntities.createLivingEntity(EntityLionfish::new, EntityClassification.CREATURE, "lionfish", 0.6f, 0.5f));
    public static final RegistryObject<EntityType<EntityThrasher>> THRASHER = ENTITY_TYPES.register("thrasher", () -> UAEntities.createLivingEntity(EntityThrasher::new, EntityClassification.MONSTER, "thrasher", 1.6f, 0.9f));
    public static final RegistryObject<EntityType<EntityGreatThrasher>> GREAT_THRASHER = ENTITY_TYPES.register("great_thrasher", () -> UAEntities.createLivingEntity(EntityGreatThrasher::new, EntityClassification.MONSTER, "great_thrasher", 2.8f, 1.575f));
    public static final RegistryObject<EntityType<EntityFlare>> FLARE = ENTITY_TYPES.register("flare", () -> UAEntities.createLivingEntity(EntityFlare::new, EntityClassification.MONSTER, "flare", 0.9f, 0.5f));

    private static <T extends LivingEntity> EntityType<T> createLivingEntity(EntityType.IFactory<T> factory, EntityClassification entityClassification, String name, float width, float height) {
        ResourceLocation location = new ResourceLocation("upgrade_aquatic", name);
        EntityType entity = EntityType.Builder.func_220322_a(factory, (EntityClassification)entityClassification).func_220321_a(width, height).setTrackingRange(64).setShouldReceiveVelocityUpdates(true).setUpdateInterval(3).func_206830_a(location.toString());
        return entity;
    }

    private static <T extends Entity> EntityType<T> createEntity(EntityType.IFactory<T> factory, BiFunction<FMLPlayMessages.SpawnEntity, World, T> clientFactory, EntityClassification entityClassification, String name, float width, float height) {
        ResourceLocation location = new ResourceLocation("upgrade_aquatic", name);
        EntityType entity = EntityType.Builder.func_220322_a(factory, (EntityClassification)entityClassification).func_220321_a(width, height).setTrackingRange(64).setShouldReceiveVelocityUpdates(true).setUpdateInterval(3).setCustomClientFactory(clientFactory).func_206830_a(location.toString());
        return entity;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)NAUTILUS.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, UAEntities::ravineMobCondition);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)PIKE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING, UAEntities::pickerelCondition);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)LIONFISH.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING, UAEntities::coralCondition);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)THRASHER.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING, UAEntities::ravineMobCondition);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)GREAT_THRASHER.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING, UAEntities::ravineMobCondition);
    }

    private static boolean ravineMobCondition(EntityType<? extends CreatureEntity> entityType, IWorld world, SpawnReason spawnReason, BlockPos pos, Random random) {
        if (world.func_201675_m().func_186058_p() != DimensionType.field_223227_a_) {
            return false;
        }
        return pos.func_177956_o() <= 30;
    }

    private static boolean pickerelCondition(EntityType<? extends EntityPike> entityType, IWorld world, SpawnReason spawnReason, BlockPos pos, Random random) {
        if (world.func_201675_m().func_186058_p() != DimensionType.field_223227_a_) {
            return false;
        }
        for (int yy = pos.func_177956_o() - 2; yy <= pos.func_177956_o() + 2; ++yy) {
            for (int xx = pos.func_177958_n() - 6; xx <= pos.func_177958_n() + 6; ++xx) {
                for (int zz = pos.func_177952_p() - 6; zz <= pos.func_177952_p() + 6; ++zz) {
                    if (!(world.func_180495_p(new BlockPos(xx, yy, zz)).func_177230_c() instanceof BlockPickerelweed) && !(world.func_180495_p(new BlockPos(xx, yy, zz)).func_177230_c() instanceof BlockPickerelweedDouble)) continue;
                    if (random.nextFloat() <= 0.125f && world.func_180494_b(pos).func_201856_r() == Biome.Category.SWAMP) {
                        return (double)random.nextFloat() <= 0.25;
                    }
                    return true;
                }
            }
        }
        return random.nextFloat() <= 0.05f;
    }

    private static boolean coralCondition(EntityType<? extends Entity> entityType, IWorld world, SpawnReason spawnReason, BlockPos pos, Random random) {
        if (world.func_201675_m().func_186058_p() != DimensionType.field_223227_a_) {
            return false;
        }
        for (int yy = pos.func_177956_o() - 2; yy <= pos.func_177956_o() + 2; ++yy) {
            for (int xx = pos.func_177958_n() - 6; xx <= pos.func_177958_n() + 6; ++xx) {
                for (int zz = pos.func_177952_p() - 6; zz <= pos.func_177952_p() + 6; ++zz) {
                    if (!world.func_180495_p(new BlockPos(xx, yy, zz)).func_177230_c().func_203417_a(BlockTags.field_205598_B)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

