/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.core.registry.util;

import com.teamabnormals.upgrade_aquatic.common.items.UASpawnEggItem;
import com.teamabnormals.upgrade_aquatic.common.items.itemblocks.ItemBlockUpsideDown;
import com.teamabnormals.upgrade_aquatic.core.registry.UAItems;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.Rarity;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.item.TallBlockItem;
import net.minecraft.item.WallOrFloorItem;
import net.minecraftforge.fml.RegistryObject;

public class RegistryUtils {
    public static String nameWithModIdPrefix(String name) {
        return "upgrade_aquatic:" + name;
    }

    public static BlockItem createWallOrFloorItem(Block floorBlock, Block wallBlock, ItemGroup itemGroup) {
        return (BlockItem)new WallOrFloorItem(floorBlock, wallBlock, new Item.Properties().func_200916_a(itemGroup)).setRegistryName(floorBlock.getRegistryName());
    }

    public static BlockItem createUpsideDownBlockItem(Block block, ItemGroup itemGroup) {
        return (BlockItem)new ItemBlockUpsideDown(block, new Item.Properties().func_200916_a(itemGroup)).setRegistryName(block.getRegistryName());
    }

    public static BlockItem createTallItemBlock(Block block, ItemGroup itemGroup) {
        return (BlockItem)new TallBlockItem(block, new Item.Properties().func_200916_a(itemGroup)).setRegistryName(block.getRegistryName());
    }

    public static Item createSimpleItem(String name, ItemGroup itemGroup) {
        return (Item)new Item(new Item.Properties().func_200916_a(itemGroup)).setRegistryName("upgrade_aquatic", name);
    }

    public static Item createSpawnEggForEntity(EntityType entityType, int eggColor1, int eggColor2, ItemGroup itemGroup) {
        return (Item)new SpawnEggItem(entityType, eggColor1, eggColor2, new Item.Properties().func_200916_a(itemGroup)).setRegistryName(entityType.getRegistryName() + "_spawn_egg");
    }

    public static BlockItem createSimpleItemBlock(Block block, ItemGroup itemGroup) {
        return (BlockItem)new BlockItem(block, new Item.Properties().func_200916_a(itemGroup)).setRegistryName(block.getRegistryName());
    }

    public static Item createItemBlockWithRarity(Block blockForInput, ItemGroup itemGroup, Rarity rarity) {
        return (BlockItem)new BlockItem(blockForInput, new Item.Properties().func_200916_a(itemGroup).func_208103_a(rarity)).setRegistryName(blockForInput.getRegistryName());
    }

    public static <I extends Item> RegistryObject<I> createItem(String name, Supplier<? extends I> supplier) {
        RegistryObject item = UAItems.ITEMS.register(name, supplier);
        return item;
    }

    public static RegistryObject<Item> createSpawnEggItem(String entityName, Supplier<EntityType<?>> supplier, int primaryColor, int secondaryColor) {
        RegistryObject spawnEgg = UAItems.ITEMS.register(entityName + "_spawn_egg", () -> new UASpawnEggItem(supplier, primaryColor, secondaryColor, new Item.Properties().func_200916_a(ItemGroup.field_78026_f)));
        UAItems.SPAWN_EGGS.add((RegistryObject<Item>)spawnEgg);
        return spawnEgg;
    }
}

