/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.entities.jellyfish;

import com.teamabnormals.abnormals_core.core.library.endimator.Endimation;
import com.teamabnormals.upgrade_aquatic.common.blocks.BlockJellyTorch;
import com.teamabnormals.upgrade_aquatic.common.entities.jellyfish.AbstractEntityJellyfish;
import com.teamabnormals.upgrade_aquatic.common.entities.jellyfish.ai.JellyfishBoostGoal;
import com.teamabnormals.upgrade_aquatic.common.entities.jellyfish.ai.JellyfishSwinIntoDirectionGoal;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class EntityImmortalJellyfish
extends AbstractEntityJellyfish {
    private AbstractEntityJellyfish.RotationController rotationController = new AbstractEntityJellyfish.RotationController(this);
    public static final Endimation SWIM_ANIMATION = new Endimation(20);
    public static final Endimation BOOST_ANIMATION = new Endimation(20);
    private int healCooldown;
    private float prevHealth = this.func_110143_aJ();

    public EntityImmortalJellyfish(EntityType<? extends AbstractEntityJellyfish> type, World world) {
        super(type, world);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(7.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(2, (Goal)new JellyfishSwinIntoDirectionGoal(this, SWIM_ANIMATION));
        this.field_70714_bg.func_75776_a(3, (Goal)new JellyfishBoostGoal(this, BOOST_ANIMATION));
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.healCooldown > 0) {
            --this.healCooldown;
        } else if (this.field_70173_aa % 5 == 0) {
            this.func_70691_i(0.5f);
        }
        if (this.prevHealth > this.func_110143_aJ()) {
            this.healCooldown = this.func_70681_au().nextInt(40) + 20;
        }
        this.prevHealth = this.func_110143_aJ();
    }

    public void onEndimationStart(Endimation endimation) {
        if (endimation == SWIM_ANIMATION) {
            this.getRotationController().addVelocityForLookDirection(0.35f, 1.0f);
        } else if (endimation == BOOST_ANIMATION) {
            this.getRotationController().addVelocityForLookDirection(0.2f, 1.0f);
        }
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.healCooldown = compound.func_74762_e("HealCooldown");
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("HealCooldown", this.healCooldown);
    }

    public Endimation[] getEndimations() {
        return new Endimation[]{SWIM_ANIMATION, BOOST_ANIMATION};
    }

    @Override
    public AbstractEntityJellyfish.RotationController getRotationController() {
        return this.rotationController;
    }

    protected void setBucketData(ItemStack bucket) {
        if (this.func_145818_k_()) {
            bucket.func_200302_a(this.func_200201_e());
        }
        AbstractEntityJellyfish.BucketData data = new AbstractEntityJellyfish.BucketData("immortal_jellyfish");
        bucket.func_196082_o().func_218657_a("JellyfishTag", (INBT)AbstractEntityJellyfish.BucketData.write(data));
    }

    @Override
    public void readBucketData(CompoundNBT compound) {
    }

    @Override
    public String getBucketName() {
        return "immortal";
    }

    @Override
    public BlockJellyTorch.JellyTorchType getJellyTorchType() {
        return this.func_70681_au().nextFloat() < 0.75f ? BlockJellyTorch.JellyTorchType.WHITE : BlockJellyTorch.JellyTorchType.RED;
    }

    @Override
    public float getCooldownChance() {
        return 0.8f;
    }

    @Override
    public int getIdSuffix() {
        return 7;
    }

    @Override
    public ITextComponent getYieldingTorchMessage() {
        BlockJellyTorch.JellyTorchType white = BlockJellyTorch.JellyTorchType.WHITE;
        BlockJellyTorch.JellyTorchType red = BlockJellyTorch.JellyTorchType.RED;
        return new TranslationTextComponent("tooltip.upgrade_aquatic.yielding_jellytorch", new Object[0]).func_211708_a(TextFormatting.GRAY).func_150257_a(new TranslationTextComponent("tooltip.upgrade_aquatic.jellytorch_" + white.toString().toLowerCase(), new Object[0]).func_211708_a(white.color)).func_150257_a(new TranslationTextComponent("tooltip.upgrade_aquatic.yielding_jellytorch.or", new Object[0]).func_211708_a(TextFormatting.GRAY)).func_150257_a(new TranslationTextComponent("tooltip.upgrade_aquatic.jellytorch_" + red.toString().toLowerCase(), new Object[0]).func_211708_a(red.color));
    }

    public int func_70641_bl() {
        return 3;
    }
}

