/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.core.registry.other;

import com.teamabnormals.abnormals_core.common.items.AbnormalsSpawnEggItem;
import com.teamabnormals.abnormals_core.core.library.api.IBucketableEntity;
import com.teamabnormals.upgrade_aquatic.common.entities.EntityPike;
import com.teamabnormals.upgrade_aquatic.core.UpgradeAquatic;
import com.teamabnormals.upgrade_aquatic.core.registry.UAItems;
import java.util.List;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.passive.SquidEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class UADispenseBehaviorRegistry {
    static IDispenseItemBehavior fishDispenseItemBehavior = new DefaultDispenseItemBehavior(){
        private final DefaultDispenseItemBehavior field_218405_b = new DefaultDispenseItemBehavior();

        public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            BucketItem bucketitem = (BucketItem)stack.func_77973_b();
            BlockPos blockpos = source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a));
            World world = source.func_197524_h();
            if (bucketitem.func_180616_a(null, world, blockpos, null)) {
                bucketitem.func_203792_a(world, stack, blockpos);
                return new ItemStack((IItemProvider)Items.field_151133_ar);
            }
            return this.field_218405_b.dispense(source, stack);
        }
    };
    static IDispenseItemBehavior bucketFishItemBehavior = new DefaultDispenseItemBehavior(){

        protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            BlockPos blockPos = source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a));
            World world = source.func_197524_h();
            List entities = world.func_217357_a(WaterMobEntity.class, new AxisAlignedBB(blockPos));
            if (!entities.isEmpty()) {
                for (WaterMobEntity mob : entities) {
                    if (mob instanceof AbstractFishEntity) {
                        ItemStack bucket = ((AbstractFishEntity)mob).func_203707_dx();
                        mob.func_70106_y();
                        world.func_184133_a(null, blockPos, SoundEvents.field_203814_aa, SoundCategory.BLOCKS, 0.5f, 1.0f);
                        return bucket;
                    }
                    if (mob instanceof IBucketableEntity) {
                        if (mob instanceof EntityPike) {
                            ItemStack bucket = ((IBucketableEntity)mob).getBucket();
                            CompoundNBT nbt = bucket.func_196082_o();
                            CompoundNBT compoundnbt1 = new CompoundNBT();
                            nbt.func_74768_a("BucketVariantTag", ((EntityPike)mob).getPikeType());
                            if (!mob.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b()) {
                                mob.func_184582_a(EquipmentSlotType.MAINHAND).func_77955_b(compoundnbt1);
                            }
                            nbt.func_218657_a("PikeHeldItem", (INBT)compoundnbt1);
                            nbt.func_74757_a("ShouldDropItem", ((EntityPike)mob).shouldDropItem());
                            mob.func_70106_y();
                            world.func_184133_a(null, blockPos, SoundEvents.field_203814_aa, SoundCategory.BLOCKS, 0.5f, 1.0f);
                            return bucket;
                        }
                        ItemStack bucket = ((IBucketableEntity)mob).getBucket();
                        mob.func_70106_y();
                        world.func_184133_a(null, blockPos, SoundEvents.field_203814_aa, SoundCategory.BLOCKS, 0.5f, 1.0f);
                        return bucket;
                    }
                    if (!(mob instanceof SquidEntity)) continue;
                    ItemStack bucket = new ItemStack((IItemProvider)UAItems.SQUID_BUCKET.get());
                    if (mob.func_145818_k_()) {
                        bucket.func_200302_a(mob.func_200201_e());
                    }
                    mob.func_70106_y();
                    world.func_184133_a(null, blockPos, SoundEvents.field_203814_aa, SoundCategory.BLOCKS, 0.5f, 1.0f);
                    return bucket;
                }
            }
            return fishDispenseItemBehavior.dispense(source, stack);
        }
    };
    static DefaultDispenseItemBehavior spawnEggItemBehavior = new DefaultDispenseItemBehavior(){

        public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            Direction direction = (Direction)source.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a);
            EntityType entitytype = ((SpawnEggItem)stack.func_77973_b()).func_208076_b(stack.func_77978_p());
            entitytype.func_220331_a(source.func_197524_h(), stack, (PlayerEntity)null, source.func_180699_d().func_177972_a(direction), SpawnReason.DISPENSER, direction != Direction.UP, false);
            stack.func_190918_g(1);
            return stack;
        }
    };

    public static void registerDispenseBehaviors() {
        DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)UAItems.NAUTILUS_BUCKET.get()), (IDispenseItemBehavior)fishDispenseItemBehavior);
        DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)UAItems.PIKE_BUCKET.get()), (IDispenseItemBehavior)fishDispenseItemBehavior);
        DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)UAItems.LIONFISH_BUCKET.get()), (IDispenseItemBehavior)fishDispenseItemBehavior);
        DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)UAItems.SQUID_BUCKET.get()), (IDispenseItemBehavior)fishDispenseItemBehavior);
        DispenserBlock.func_199774_a((IItemProvider)Items.field_151131_as, (IDispenseItemBehavior)bucketFishItemBehavior);
        UpgradeAquatic.REGISTRY_HELPER.getDeferredItemRegister().getEntries().stream().filter(entry -> entry.get() instanceof AbnormalsSpawnEggItem).forEach(item -> {
            Item items = (Item)item.get();
            DispenserBlock.func_199774_a((IItemProvider)items, (IDispenseItemBehavior)spawnEggItemBehavior);
        });
    }
}

