/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.core.registry.other;

import com.google.common.collect.Lists;
import com.teamabnormals.abnormals_core.core.library.EntitySpawnHandler;
import com.teamabnormals.upgrade_aquatic.common.blocks.BlockPickerelweed;
import com.teamabnormals.upgrade_aquatic.common.blocks.BlockPickerelweedDouble;
import com.teamabnormals.upgrade_aquatic.common.entities.EntityPike;
import com.teamabnormals.upgrade_aquatic.common.entities.jellyfish.AbstractEntityJellyfish;
import com.teamabnormals.upgrade_aquatic.common.entities.thrasher.EntityThrasher;
import com.teamabnormals.upgrade_aquatic.core.registry.UAEntities;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.registries.ForgeRegistries;

public class UAEntitySpawns
extends EntitySpawnHandler {
    private static final List<EntitySpawnHandler.EntitySpawn<? extends MobEntity>> SPAWNS = (List)Util.func_200696_a((Object)Lists.newArrayList(), spawns -> {
        spawns.add(new EntitySpawnHandler.EntitySpawn(() -> UAEntities.NAUTILUS.get(), new EntitySpawnHandler.SpawnEntry(EntityClassification.WATER_CREATURE, 51, 1, 4), EntitySpawnPlacementRegistry.PlacementType.IN_WATER, Heightmap.Type.MOTION_BLOCKING, UAEntitySpawns::ravineMobCondition, UAEntitySpawns.notColdOceanCondition()));
        spawns.add(new PikeEntitySpawn(() -> UAEntities.PIKE.get(), EntitySpawnPlacementRegistry.PlacementType.IN_WATER, Heightmap.Type.MOTION_BLOCKING));
        spawns.add(new EntitySpawnHandler.EntitySpawn(() -> UAEntities.LIONFISH.get(), new EntitySpawnHandler.SpawnEntry(EntityClassification.WATER_CREATURE, 15, 1, 1), EntitySpawnPlacementRegistry.PlacementType.IN_WATER, Heightmap.Type.MOTION_BLOCKING, UAEntitySpawns::coralCondition, UAEntitySpawns.hotOceanCondition()));
        spawns.add(new ThrasherEntitySpawn(() -> UAEntities.THRASHER.get(), EntitySpawnPlacementRegistry.PlacementType.IN_WATER, Heightmap.Type.MOTION_BLOCKING, UAEntitySpawns.coldOceanCondition()));
        spawns.add(new EntitySpawnHandler.EntitySpawn(() -> UAEntities.BOX_JELLYFISH.get(), new EntitySpawnHandler.SpawnEntry(EntityClassification.WATER_CREATURE, 6, 1, 2), EntitySpawnPlacementRegistry.PlacementType.IN_WATER, Heightmap.Type.MOTION_BLOCKING, AbstractEntityJellyfish::defaultSpawnCondition, UAEntitySpawns.warmishOceanCondition()));
        spawns.add(new EntitySpawnHandler.EntitySpawn(() -> UAEntities.CASSIOPEA_JELLYFISH.get(), new EntitySpawnHandler.SpawnEntry(EntityClassification.WATER_CREATURE, 7, 1, 3), EntitySpawnPlacementRegistry.PlacementType.IN_WATER, Heightmap.Type.MOTION_BLOCKING, AbstractEntityJellyfish::defaultSpawnCondition, biome -> biome == Biomes.field_203615_U));
    });

    public static void registerSpawnPlacements() {
        SPAWNS.forEach(EntitySpawnHandler.EntitySpawn::registerSpawnPlacement);
    }

    public static void processSpawnAdditions() {
        SPAWNS.forEach(EntitySpawnHandler.EntitySpawn::processSpawnAddition);
    }

    private static boolean ravineMobCondition(EntityType<? extends CreatureEntity> entityType, IWorld world, SpawnReason spawnReason, BlockPos pos, Random random) {
        if (world.func_201675_m().func_186058_p() != DimensionType.field_223227_a_) {
            return false;
        }
        return pos.func_177956_o() <= 30;
    }

    public static boolean pickerelCondition(EntityType<? extends EntityPike> entityType, IWorld world, SpawnReason spawnReason, BlockPos pos, Random random) {
        if (world.func_201675_m().func_186058_p() != DimensionType.field_223227_a_) {
            return false;
        }
        for (int yy = pos.func_177956_o() - 2; yy <= pos.func_177956_o() + 2; ++yy) {
            for (int xx = pos.func_177958_n() - 6; xx <= pos.func_177958_n() + 6; ++xx) {
                for (int zz = pos.func_177952_p() - 6; zz <= pos.func_177952_p() + 6; ++zz) {
                    if (!(world.func_180495_p(new BlockPos(xx, yy, zz)).func_177230_c() instanceof BlockPickerelweed) && !(world.func_180495_p(new BlockPos(xx, yy, zz)).func_177230_c() instanceof BlockPickerelweedDouble)) continue;
                    if (random.nextFloat() <= 0.125f && world.func_226691_t_(pos).func_201856_r() == Biome.Category.SWAMP) {
                        return random.nextFloat() <= 0.25f;
                    }
                    return true;
                }
            }
        }
        return random.nextFloat() <= 0.05f;
    }

    private static boolean coralCondition(EntityType<? extends Entity> entityType, IWorld world, SpawnReason spawnReason, BlockPos pos, Random random) {
        if (world.func_201675_m().func_186058_p() != DimensionType.field_223227_a_) {
            return false;
        }
        for (int yy = pos.func_177956_o() - 2; yy <= pos.func_177956_o() + 2; ++yy) {
            for (int xx = pos.func_177958_n() - 6; xx <= pos.func_177958_n() + 6; ++xx) {
                for (int zz = pos.func_177952_p() - 6; zz <= pos.func_177952_p() + 6; ++zz) {
                    if (!world.func_180495_p(new BlockPos(xx, yy, zz)).func_177230_c().func_203417_a(BlockTags.field_205598_B)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean thrasherCondition(EntityType<? extends CreatureEntity> entityType, IWorld world, SpawnReason spawnReason, BlockPos pos, Random random) {
        if (world.func_201675_m().func_186058_p() != DimensionType.field_223227_a_) {
            return false;
        }
        return pos.func_177956_o() <= 30 && (world.func_201672_e().func_226690_K_() || random.nextFloat() < 0.75f);
    }

    public static Predicate<Biome> warmishOceanCondition() {
        return biome -> biome == Biomes.field_203614_T || biome == Biomes.field_203615_U;
    }

    static class ThrasherEntitySpawn<T extends EntityThrasher>
    extends EntitySpawnHandler.EntitySpawn<T> {
        public ThrasherEntitySpawn(Supplier<EntityType<T>> thrasher, EntitySpawnPlacementRegistry.PlacementType placementType, Heightmap.Type heightmapType, Predicate<Biome> biomePredicate) {
            super(thrasher, null, placementType, heightmapType, null, biomePredicate);
        }

        public void registerSpawnPlacement() {
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)this.entity.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING, (x$0, x$1, x$2, x$3, x$4) -> UAEntitySpawns.thrasherCondition((EntityType<? extends CreatureEntity>)x$0, x$1, x$2, x$3, x$4));
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)UAEntities.GREAT_THRASHER.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING, (x$0, x$1, x$2, x$3, x$4) -> UAEntitySpawns.thrasherCondition((EntityType<? extends CreatureEntity>)x$0, x$1, x$2, x$3, x$4));
        }

        public void processSpawnAddition() {
            ForgeRegistries.BIOMES.getEntries().stream().filter(biome -> this.biomePredicate.test(biome.getValue())).forEach(biome -> ((Biome)biome.getValue()).func_201866_a(EntityClassification.WATER_CREATURE, new Biome.SpawnListEntry((EntityType)this.entity.get(), 90, 1, 2)));
        }
    }

    static class PikeEntitySpawn<T extends EntityPike>
    extends EntitySpawnHandler.EntitySpawn<T> {
        public PikeEntitySpawn(Supplier<EntityType<T>> entity, EntitySpawnPlacementRegistry.PlacementType placementType, Heightmap.Type heightmapType) {
            super(entity, null, placementType, heightmapType, UAEntitySpawns::pickerelCondition, null);
        }

        public void registerSpawnPlacement() {
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)this.entity.get()), (EntitySpawnPlacementRegistry.PlacementType)this.placementType, (Heightmap.Type)this.heightmapType, (EntitySpawnPlacementRegistry.IPlacementPredicate)this.placementPredicate);
        }

        public void processSpawnAddition() {
            ForgeRegistries.BIOMES.getEntries().forEach(biomeEntry -> {
                Biome biome = (Biome)biomeEntry.getValue();
                if (biome.func_201856_r() == Biome.Category.SWAMP || biome.func_201856_r() == Biome.Category.RIVER) {
                    if (biome.func_201856_r() == Biome.Category.SWAMP) {
                        biome.func_76747_a(EntityClassification.WATER_CREATURE).add(new Biome.SpawnListEntry((EntityType)UAEntities.PIKE.get(), 5, 1, 2));
                        biome.func_76747_a(EntityClassification.WATER_CREATURE).add(new Biome.SpawnListEntry(EntityType.field_200749_ao, 5, 1, 2));
                        biome.func_76747_a(EntityClassification.WATER_CREATURE).add(new Biome.SpawnListEntry(EntityType.field_203778_ae, 5, 1, 5));
                    } else {
                        biome.func_76747_a(EntityClassification.WATER_CREATURE).add(new Biome.SpawnListEntry((EntityType)UAEntities.PIKE.get(), 11, 1, 2));
                    }
                }
            });
        }
    }
}

