/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.upgrade_aquatic.common.entities.jellyfish;

import com.minecraftabnormals.abnormals_core.core.endimator.Endimation;
import com.minecraftabnormals.upgrade_aquatic.common.blocks.JellyTorchBlock;
import com.minecraftabnormals.upgrade_aquatic.common.entities.jellyfish.AbstractJellyfishEntity;
import com.minecraftabnormals.upgrade_aquatic.common.entities.jellyfish.ColoredSizableJellyfishEntity;
import com.minecraftabnormals.upgrade_aquatic.common.entities.jellyfish.ai.CassiopeaHideInSeagrassGoal;
import com.minecraftabnormals.upgrade_aquatic.common.entities.jellyfish.ai.CassiopeaJellyfishFlipGoal;
import com.minecraftabnormals.upgrade_aquatic.common.entities.jellyfish.ai.JellyfishBoostGoal;
import com.minecraftabnormals.upgrade_aquatic.common.entities.jellyfish.ai.JellyfishSwimIntoDirectionGoal;
import com.minecraftabnormals.upgrade_aquatic.core.other.UADamageSources;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.World;

public class CassiopeaJellyfishEntity
extends ColoredSizableJellyfishEntity {
    public int upsideDownCooldown;
    public int hideCooldown;
    private AbstractJellyfishEntity.RotationController rotationController = new AbstractJellyfishEntity.RotationController(this);

    public CassiopeaJellyfishEntity(EntityType<? extends AbstractJellyfishEntity> type, World world) {
        super(type, world);
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233823_f_, 1.0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new CassiopeaHideInSeagrassGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new CassiopeaJellyfishFlipGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new JellyfishSwimIntoDirectionGoal(this, SWIM_ANIMATION));
        this.field_70714_bg.func_75776_a(3, (Goal)new JellyfishBoostGoal(this, BOOST_ANIMATION));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.hasUpsideDownCooldown()) {
            --this.upsideDownCooldown;
        }
        if (this.hasHideCooldown()) {
            --this.hideCooldown;
        }
        if (this.func_70090_H()) {
            if (this.isEndimationPlaying(BOOST_ANIMATION)) {
                this.func_213317_d(this.func_213322_ci().func_186678_a((double)1.15f));
            } else if (this.isEndimationPlaying(SWIM_ANIMATION)) {
                this.func_213317_d(this.func_213322_ci().func_186678_a((double)1.05f));
            }
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("UpsideDownCooldown", this.upsideDownCooldown);
        compound.func_74768_a("HideCooldown", this.hideCooldown);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.upsideDownCooldown = compound.func_74762_e("UpsideDownCooldown");
        this.hideCooldown = compound.func_74762_e("HideCooldown");
    }

    public boolean hasUpsideDownCooldown() {
        return this.upsideDownCooldown > 0;
    }

    public boolean hasHideCooldown() {
        return this.hideCooldown > 0;
    }

    public EntitySize func_213305_a(Pose pose) {
        return super.func_213305_a(pose).func_220313_a(this.getSize());
    }

    protected float func_213348_b(Pose poseIn, EntitySize size) {
        return size.field_220316_b * 0.5f;
    }

    public int func_70641_bl() {
        return 3;
    }

    public void onEndimationStart(Endimation endimation) {
        float sizeForce;
        float f = sizeForce = this.getSize() < 0.6f ? 0.85f : this.getSize();
        if (endimation == SWIM_ANIMATION) {
            this.getRotationController().addVelocityForLookDirection(0.3f, sizeForce);
        } else if (endimation == BOOST_ANIMATION) {
            this.getRotationController().addVelocityForLookDirection(0.2f, sizeForce);
        }
    }

    @Override
    public AbstractJellyfishEntity.RotationController getRotationController() {
        return this.rotationController;
    }

    @Override
    public String getBucketName() {
        switch (this.getColor()) {
            default: {
                return "cassiopea";
            }
            case 1: {
                return "blue_cassiopea";
            }
            case 2: 
        }
        return "white_cassiopea";
    }

    @Override
    public JellyTorchBlock.JellyTorchType getJellyTorchType() {
        switch (this.getColor()) {
            default: {
                return JellyTorchBlock.JellyTorchType.GREEN;
            }
            case 1: {
                return JellyTorchBlock.JellyTorchType.BLUE;
            }
            case 2: 
        }
        return JellyTorchBlock.JellyTorchType.WHITE;
    }

    @Override
    public float getCooldownChance() {
        return this.getSize() < 1.0f ? 0.9f : 0.8f;
    }

    @Override
    public boolean stingEntity(LivingEntity livingEntity) {
        if ((this.func_70638_az() == livingEntity || this.func_70643_av() == livingEntity) && this.func_70681_au().nextFloat() < 0.5f) {
            return livingEntity.func_70097_a(UADamageSources.causeJellyfishDamage(this), (float)this.func_110148_a(Attributes.field_233823_f_).func_111126_e());
        }
        return false;
    }

    @Override
    protected float getHealthSizeMultiplier() {
        return 6.0f;
    }

    @Override
    protected float getDefaultSize() {
        return 0.85f;
    }

    @Override
    protected String getBucketEntityId() {
        return "cassiopea_jellyfish";
    }
}

