/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.upgrade_aquatic.core.events;

import com.minecraftabnormals.abnormals_core.core.util.TradeUtil;
import com.minecraftabnormals.upgrade_aquatic.api.IGlowable;
import com.minecraftabnormals.upgrade_aquatic.api.util.UAEntityPredicates;
import com.minecraftabnormals.upgrade_aquatic.client.particle.UAParticles;
import com.minecraftabnormals.upgrade_aquatic.common.advancement.UACriteriaTriggers;
import com.minecraftabnormals.upgrade_aquatic.common.blocks.BedrollBlock;
import com.minecraftabnormals.upgrade_aquatic.common.entities.LionfishEntity;
import com.minecraftabnormals.upgrade_aquatic.common.entities.pike.PikeEntity;
import com.minecraftabnormals.upgrade_aquatic.common.entities.thrasher.ThrasherEntity;
import com.minecraftabnormals.upgrade_aquatic.common.items.GlowingInkItem;
import com.minecraftabnormals.upgrade_aquatic.core.registry.UABlocks;
import com.minecraftabnormals.upgrade_aquatic.core.registry.UAEntities;
import com.minecraftabnormals.upgrade_aquatic.core.registry.UAItems;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.monster.DrownedEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.PhantomEntity;
import net.minecraft.entity.passive.DolphinEntity;
import net.minecraft.entity.passive.SquidEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.entity.passive.fish.TropicalFishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SStatisticsPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.stats.ServerStatisticsManager;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="upgrade_aquatic")
public class EntityEvents {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEntitySpawned(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof DrownedEntity) {
            ((CreatureEntity)entity).field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)entity, TurtleEntity.class, 6.0f, 1.0, 1.2));
        }
        if (entity instanceof AbstractFishEntity) {
            ((AbstractFishEntity)entity).field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal((CreatureEntity)entity, PikeEntity.class, 8.0f, 1.6, 1.4, UAEntityPredicates.IS_HIDING_IN_PICKERELWEED::test));
            if (entity instanceof TropicalFishEntity) {
                ((AbstractFishEntity)entity).field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal((CreatureEntity)entity, LionfishEntity.class, 8.0f, 1.6, 1.4, EntityPredicates.field_94557_a::test));
            }
        }
        if (entity instanceof WaterMobEntity && !(entity instanceof IMob)) {
            if (!(entity instanceof DolphinEntity)) {
                ((MobEntity)entity).field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)entity, ThrasherEntity.class, 20.0f, 1.4, 1.6, EntityPredicates.field_94557_a::test));
            }
            if (entity instanceof DolphinEntity) {
                ((MobEntity)entity).field_70715_bh.func_75776_a(0, (Goal)new HurtByTargetGoal((CreatureEntity)((DolphinEntity)entity), new Class[]{ThrasherEntity.class}).func_220794_a(new Class[0]));
                ((MobEntity)entity).field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)((DolphinEntity)entity), 1.2, true));
            }
        }
    }

    @SubscribeEvent
    public static void rightClickItem(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        PlayerEntity player = event.getPlayer();
        ItemStack stack = event.getItemStack();
        if (!player.func_226563_dT_()) {
            IGlowable te;
            if (stack.func_77973_b() == UAItems.GLOWING_INK_SAC.get() && world.func_175625_s(pos) instanceof IGlowable) {
                te = (IGlowable)world.func_175625_s(pos);
                if (te != null && te.setGlowing(true)) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                    }
                    GlowingInkItem.createEffectCloud(Effects.field_76439_r, world, pos);
                    if (world.func_201670_d()) {
                        GlowingInkItem.squirtInk((IParticleData)UAParticles.GLOW_SQUID_INK.get(), (IWorld)world, pos);
                    }
                    world.func_184133_a(player, pos, SoundEvents.field_203639_hT, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                event.setCanceled(true);
                event.setCancellationResult(ActionResultType.SUCCESS);
            }
            if (stack.func_77973_b() == Items.field_196136_br) {
                if (world.func_175625_s(pos) instanceof IGlowable) {
                    te = (IGlowable)world.func_175625_s(pos);
                    if (te != null && te.setGlowing(false)) {
                        if (!player.field_71075_bZ.field_75098_d) {
                            stack.func_190918_g(1);
                        }
                        GlowingInkItem.createEffectCloud(Effects.field_76439_r, world, pos);
                        if (world.func_201670_d()) {
                            GlowingInkItem.squirtInk((IParticleData)ParticleTypes.field_203219_V, (IWorld)world, pos);
                        }
                        world.func_184133_a(player, pos, SoundEvents.field_203639_hT, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    }
                } else {
                    if (!player.field_71075_bZ.field_75098_d) {
                        event.getItemStack().func_190918_g(1);
                    }
                    GlowingInkItem.createEffectCloud(Effects.field_76440_q, world, world.func_180495_p(pos).func_200132_m() ? pos.func_177972_a(event.getFace()) : pos);
                    if (world.func_201670_d()) {
                        GlowingInkItem.squirtInk((IParticleData)ParticleTypes.field_203219_V, (IWorld)world, world.func_180495_p(pos).func_200132_m() ? pos.func_177972_a(event.getFace()) : pos);
                    }
                    world.func_184133_a(player, pos, SoundEvents.field_203639_hT, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                event.setCanceled(true);
                event.setCancellationResult(ActionResultType.SUCCESS);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        ServerPlayerEntity playerMP;
        ServerStatisticsManager statisticsManager;
        LivingEntity entity = event.getEntityLiving();
        if (entity instanceof PhantomEntity && ((PhantomEntity)entity).func_70638_az() instanceof ServerPlayerEntity && (statisticsManager = (playerMP = (ServerPlayerEntity)((PhantomEntity)entity).func_70638_az()).func_147099_x()).func_77444_a(Stats.field_199092_j.func_199076_b((Object)Stats.field_203284_n)) < 72000) {
            ((PhantomEntity)entity).func_70624_b(null);
        }
    }

    @SubscribeEvent
    public static void onPlayerSleep(PlayerSleepInBedEvent event) {
        PlayerEntity player = event.getPlayer();
        BlockState state = player.func_130014_f_().func_180495_p(event.getPos());
        if (event.getResultStatus() == null && state.func_204520_s().func_206882_g() == 8 && state.func_177230_c() instanceof BedrollBlock && player instanceof ServerPlayerEntity && player.func_70089_S()) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
            if (!player.field_70170_p.func_201670_d()) {
                UACriteriaTriggers.SLEEP_UNDERWATER.trigger(serverPlayer);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerSetSpawn(PlayerSetSpawnEvent event) {
        if (event.getEntityLiving().func_130014_f_().func_180495_p(event.getNewSpawn()).func_177230_c() instanceof BedrollBlock) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onInteractEntity(PlayerInteractEvent.EntityInteract event) {
        Entity entity = event.getTarget();
        PlayerEntity player = event.getPlayer();
        ItemStack stack = event.getItemStack();
        if (stack.func_77973_b() == Items.field_151131_as && entity.func_70089_S() && entity instanceof SquidEntity) {
            ItemStack bucket = ItemStack.field_190927_a;
            if (entity.func_200600_R() == EntityType.field_200749_ao) {
                bucket = new ItemStack((IItemProvider)UAItems.SQUID_BUCKET.get());
            } else if (entity.func_200600_R() == UAEntities.GLOW_SQUID.get()) {
                bucket = new ItemStack((IItemProvider)UAItems.GLOW_SQUID_BUCKET.get());
            } else {
                return;
            }
            player.func_184609_a(event.getHand());
            entity.func_184185_a(SoundEvents.field_203814_aa, 1.0f, 1.0f);
            stack.func_190918_g(1);
            if (entity.func_145818_k_()) {
                bucket.func_200302_a(entity.func_200201_e());
            }
            if (!event.getWorld().field_72995_K) {
                CriteriaTriggers.field_204813_j.func_204817_a((ServerPlayerEntity)player, bucket);
            }
            if (stack.func_190926_b()) {
                player.func_184611_a(event.getHand(), bucket);
            } else if (!player.field_71071_by.func_70441_a(bucket)) {
                player.func_71019_a(bucket, false);
            }
            entity.func_70106_y();
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        PlayerEntity player = event.player;
        ItemStack headSlotStack = player.func_184582_a(EquipmentSlotType.HEAD);
        if (!event.player.field_70170_p.field_72995_K && event.player.field_70170_p.func_82737_E() % 5L == 0L && event.player instanceof ServerPlayerEntity) {
            ServerPlayerEntity sPlayer = (ServerPlayerEntity)event.player;
            ServerStatisticsManager statisticsManager = sPlayer.func_147099_x();
            Object2IntOpenHashMap object2intmap = new Object2IntOpenHashMap();
            object2intmap.put((Object)Stats.field_199092_j.func_199076_b((Object)Stats.field_203284_n), statisticsManager.func_77444_a(Stats.field_199092_j.func_199076_b((Object)Stats.field_203284_n)));
            sPlayer.field_71135_a.func_147359_a((IPacket)new SStatisticsPacket((Object2IntMap)object2intmap));
        }
        if (player.func_70613_aW() && !headSlotStack.func_190926_b() && headSlotStack.func_77973_b() == Items.field_203179_ao) {
            int timeTillDamage;
            int n = timeTillDamage = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)headSlotStack) > 0 ? 40 * (1 + EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)headSlotStack) / 2) : 40;
            if (player.func_208600_a((ITag)FluidTags.field_206959_a)) {
                player.func_195064_c(new EffectInstance(Effects.field_76427_o, 210));
                if (player.field_70170_p.func_82737_E() % (long)timeTillDamage == 0L) {
                    headSlotStack.func_222118_a(1, (LivingEntity)player, p_213341_0_ -> p_213341_0_.func_213361_c(EquipmentSlotType.HEAD));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerMount(EntityMountEvent event) {
        Entity mountingEntity = event.getEntityMounting();
        Entity entityBeingMounted = event.getEntityBeingMounted();
        if (mountingEntity instanceof PlayerEntity && entityBeingMounted instanceof ThrasherEntity) {
            PlayerEntity player = (PlayerEntity)mountingEntity;
            ThrasherEntity thrasher = (ThrasherEntity)entityBeingMounted;
            if (event.isDismounting() && player.func_70089_S() && !player.func_184812_l_() && !player.func_175149_v() && thrasher.func_70089_S()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onDrownedPoseChange(EntityEvent.Size event) {
        Entity entity = event.getEntity();
        if (entity instanceof DrownedEntity && event.getPose() == Pose.SWIMMING) {
            DrownedEntity drowned = (DrownedEntity)entity;
            event.setNewSize(new EntitySize(event.getOldSize().field_220315_a, 0.4f, false));
            drowned.field_213325_aI = EntitySize.func_220314_b((float)(drowned.func_70631_g_() ? 0.7f : 0.6f), (float)0.6f);
        }
    }

    @SubscribeEvent
    public static void onWandererTradesEvent(WandererTradesEvent event) {
        TradeUtil.addWandererTrades((WandererTradesEvent)event, (VillagerTrades.ITrade[])new VillagerTrades.ITrade[]{new TradeUtil.AbnormalsTrade(1, ((Block)UABlocks.BEACHGRASS.get()).func_199767_j(), 1, 12, 1), new TradeUtil.AbnormalsTrade(1, ((Block)UABlocks.WHITE_SEAROCKET.get()).func_199767_j(), 1, 8, 1), new TradeUtil.AbnormalsTrade(1, ((Block)UABlocks.PINK_SEAROCKET.get()).func_199767_j(), 1, 8, 1), new TradeUtil.AbnormalsTrade(1, ((Block)UABlocks.BLUE_PICKERELWEED.get()).func_199767_j(), 1, 8, 1), new TradeUtil.AbnormalsTrade(1, ((Block)UABlocks.PURPLE_PICKERELWEED.get()).func_199767_j(), 1, 8, 1), new TradeUtil.AbnormalsTrade(3, ((Block)UABlocks.FINGER_CORAL_BLOCK.get()).func_199767_j(), 1, 8, 1), new TradeUtil.AbnormalsTrade(3, ((Block)UABlocks.ACAN_CORAL_BLOCK.get()).func_199767_j(), 1, 8, 1), new TradeUtil.AbnormalsTrade(3, ((Block)UABlocks.BRANCH_CORAL_BLOCK.get()).func_199767_j(), 1, 8, 1), new TradeUtil.AbnormalsTrade(3, ((Block)UABlocks.PILLOW_CORAL_BLOCK.get()).func_199767_j(), 1, 8, 1), new TradeUtil.AbnormalsTrade(3, ((Block)UABlocks.SILK_CORAL_BLOCK.get()).func_199767_j(), 1, 8, 1), new TradeUtil.AbnormalsTrade(3, ((Block)UABlocks.PETAL_CORAL_BLOCK.get()).func_199767_j(), 1, 8, 1), new TradeUtil.AbnormalsTrade(3, ((Block)UABlocks.MOSS_CORAL_BLOCK.get()).func_199767_j(), 1, 8, 1), new TradeUtil.AbnormalsTrade(3, ((Block)UABlocks.ROCK_CORAL_BLOCK.get()).func_199767_j(), 1, 8, 1), new TradeUtil.AbnormalsTrade(3, ((Block)UABlocks.STAR_CORAL_BLOCK.get()).func_199767_j(), 1, 8, 1), new TradeUtil.AbnormalsTrade(3, ((Block)UABlocks.CHROME_CORAL_BLOCK.get()).func_199767_j(), 1, 8, 1), new TradeUtil.AbnormalsTrade(5, ((Block)UABlocks.EMBEDDED_AMMONITE.get()).func_199767_j(), 1, 5, 1)});
        TradeUtil.addRareWandererTrades((WandererTradesEvent)event, (VillagerTrades.ITrade[])new VillagerTrades.ITrade[]{new TradeUtil.AbnormalsTrade(2, ((Block)UABlocks.DRIFTWOOD_LOG.get()).func_199767_j(), 1, 16, 1), new TradeUtil.AbnormalsTrade(5, (Item)UAItems.PIKE_BUCKET.get(), 1, 4, 1), new TradeUtil.AbnormalsTrade(5, (Item)UAItems.PIKE_BUCKET.get(), 1, 4, 1), new TradeUtil.AbnormalsTrade(5, (Item)UAItems.LIONFISH_BUCKET.get(), 1, 4, 1), new TradeUtil.AbnormalsTrade(5, (Item)UAItems.NAUTILUS_BUCKET.get(), 1, 4, 1)});
    }

    @SubscribeEvent
    public static void onVillagerTradesEvent(VillagerTradesEvent event) {
        TradeUtil.addVillagerTrades((VillagerTradesEvent)event, (VillagerProfession)VillagerProfession.field_221156_f, (int)2, (VillagerTrades.ITrade[])new VillagerTrades.ITrade[]{new TradeUtil.AbnormalsTrade((Item)UAItems.MULBERRY.get(), 9, 1, 12, 10), new TradeUtil.AbnormalsTrade(1, (Item)UAItems.MULBERRY.get(), 5, 12, 5)});
        if (event.getType().equals(VillagerProfession.field_221157_g)) {
            TradeUtil.addVillagerTrades((VillagerTradesEvent)event, (int)3, (VillagerTrades.ITrade[])new VillagerTrades.ITrade[]{new TradeUtil.AbnormalsTrade(new ItemStack((IItemProvider)UAItems.PIKE.get(), 6), new ItemStack((IItemProvider)Items.field_151166_bC, 1), new ItemStack((IItemProvider)UAItems.COOKED_PIKE.get(), 6), 16, 15, 0.15f)});
            TradeUtil.addVillagerTrades((VillagerTradesEvent)event, (int)4, (VillagerTrades.ITrade[])new VillagerTrades.ITrade[]{new TradeUtil.AbnormalsTrade((Item)UAItems.PIKE.get(), 5, 1, 12, 25), new TradeUtil.AbnormalsTrade(new ItemStack((IItemProvider)UAItems.LIONFISH.get(), 6), new ItemStack((IItemProvider)Items.field_151166_bC, 1), new ItemStack((IItemProvider)UAItems.COOKED_LIONFISH.get(), 6), 16, 30, 0.15f)});
            TradeUtil.addVillagerTrades((VillagerTradesEvent)event, (int)5, (VillagerTrades.ITrade[])new VillagerTrades.ITrade[]{new TradeUtil.AbnormalsTrade((Item)UAItems.PIKE.get(), 3, 1, 12, 30)});
        }
        TradeUtil.addVillagerTrades((VillagerTradesEvent)event, (VillagerProfession)VillagerProfession.field_221161_k, (int)5, (VillagerTrades.ITrade[])new VillagerTrades.ITrade[]{new TradeUtil.AbnormalsTrade(5, ((Block)UABlocks.TOOTH_TILES.get()).func_199767_j(), 1, 12, 30), new TradeUtil.AbnormalsTrade(5, ((Block)UABlocks.TOOTH_BRICKS.get()).func_199767_j(), 1, 12, 30)});
        TradeUtil.addVillagerTrades((VillagerTradesEvent)event, (VillagerProfession)VillagerProfession.field_221155_e, (int)4, (VillagerTrades.ITrade[])new VillagerTrades.ITrade[]{new TradeUtil.AbnormalsTrade((Item)UAItems.THRASHER_TOOTH.get(), 1, 1, 12, 15)});
        TradeUtil.addVillagerTrades((VillagerTradesEvent)event, (VillagerProfession)VillagerProfession.field_221159_i, (int)2, (VillagerTrades.ITrade[])new VillagerTrades.ITrade[]{new TradeUtil.AbnormalsTrade(1, ((Block)UABlocks.BEDROLL.get()).func_199767_j(), 1, 8, 10), new TradeUtil.AbnormalsTrade(1, ((Block)UABlocks.WHITE_BEDROLL.get()).func_199767_j(), 1, 8, 10), new TradeUtil.AbnormalsTrade(1, ((Block)UABlocks.ORANGE_BEDROLL.get()).func_199767_j(), 1, 8, 10), new TradeUtil.AbnormalsTrade(1, ((Block)UABlocks.MAGENTA_BEDROLL.get()).func_199767_j(), 1, 8, 10), new TradeUtil.AbnormalsTrade(1, ((Block)UABlocks.LIGHT_BLUE_BEDROLL.get()).func_199767_j(), 1, 8, 10), new TradeUtil.AbnormalsTrade(1, ((Block)UABlocks.YELLOW_BEDROLL.get()).func_199767_j(), 1, 8, 10), new TradeUtil.AbnormalsTrade(1, ((Block)UABlocks.LIME_BEDROLL.get()).func_199767_j(), 1, 8, 10), new TradeUtil.AbnormalsTrade(1, ((Block)UABlocks.PINK_BEDROLL.get()).func_199767_j(), 1, 8, 10), new TradeUtil.AbnormalsTrade(1, ((Block)UABlocks.GRAY_BEDROLL.get()).func_199767_j(), 1, 8, 10), new TradeUtil.AbnormalsTrade(1, ((Block)UABlocks.LIGHT_GRAY_BEDROLL.get()).func_199767_j(), 1, 8, 10), new TradeUtil.AbnormalsTrade(1, ((Block)UABlocks.CYAN_BEDROLL.get()).func_199767_j(), 1, 8, 10), new TradeUtil.AbnormalsTrade(1, ((Block)UABlocks.PURPLE_BEDROLL.get()).func_199767_j(), 1, 8, 10), new TradeUtil.AbnormalsTrade(1, ((Block)UABlocks.BLUE_BEDROLL.get()).func_199767_j(), 1, 8, 10), new TradeUtil.AbnormalsTrade(1, ((Block)UABlocks.BROWN_BEDROLL.get()).func_199767_j(), 1, 8, 10), new TradeUtil.AbnormalsTrade(1, ((Block)UABlocks.GREEN_BEDROLL.get()).func_199767_j(), 1, 8, 10), new TradeUtil.AbnormalsTrade(1, ((Block)UABlocks.RED_BEDROLL.get()).func_199767_j(), 1, 8, 10), new TradeUtil.AbnormalsTrade(1, ((Block)UABlocks.BLACK_BEDROLL.get()).func_199767_j(), 1, 8, 10)});
    }
}

